/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.exporter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.conduktor.NonNullWrapper;
import io.conduktor.NonNullWrapperOrdered;
import io.conduktor.exporter.ObjectJsonifier;
import io.conduktor.models.ConsumerGroupDescription;
import io.conduktor.models.ConsumerGroupState;
import io.conduktor.models.LagValue;
import io.conduktor.models.settings.ConduktorConfig;
import kotlin.Metadata;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/conduktor/exporter/ConsumerJsonifier;", "Lio/conduktor/exporter/ObjectJsonifier;", "Lio/conduktor/models/ConsumerGroupDescription;", "config", "Lio/conduktor/models/settings/ConduktorConfig;", "(Lio/conduktor/models/settings/ConduktorConfig;)V", "getConfig", "()Lio/conduktor/models/settings/ConduktorConfig;", "om", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "toJson", "Lcom/fasterxml/jackson/databind/JsonNode;", "a", "desktop"})
final class ConsumerJsonifier
implements ObjectJsonifier<ConsumerGroupDescription> {
    @NotNull
    private final ConduktorConfig config;
    @NotNull
    private final ObjectMapper om;

    public ConsumerJsonifier(@NotNull ConduktorConfig config) {
        this.config = config;
        this.om = new ObjectMapper();
    }

    @NotNull
    public final ConduktorConfig getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public JsonNode toJson(@NotNull ConsumerGroupDescription a) {
        ObjectNode node = this.om.createObjectNode();
        node.put("group_id", a.getGroupId());
        ConsumerGroupState consumerGroupState = a.getState();
        node.put("state", consumerGroupState != null ? consumerGroupState.name() : null);
        if (this.config.getShowConsumersLagColumn()) {
            LagValue lagValue = (LagValue)((NonNullWrapperOrdered)a.getConsumersOverralLagNonNullProperty().getValue()).getValue();
            node.put("lag", lagValue != null ? Long.valueOf(lagValue.getValue()) : null);
        }
        node.put("members", a.getMembers().size());
        Pair pair = (Pair)((NonNullWrapper)a.getConsumedPartitionsProperty().getValue()).getValue();
        node.put("partitions", pair != null ? (Integer)pair.getFirst() : null);
        Pair pair2 = (Pair)((NonNullWrapper)a.getConsumedPartitionsProperty().getValue()).getValue();
        node.put("topics", pair2 != null ? (Integer)pair2.getSecond() : null);
        return (JsonNode)node;
    }
}

