/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.clustersconfig.impl.v3;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import io.conduktor.clustersconfig.ClustersConfig;
import io.conduktor.clustersconfig.Path;
import io.conduktor.clustersconfig.SchemaRegistryGroups;
import io.conduktor.clustersconfig.TopicGroups;
import io.conduktor.clustersconfig.ZookeeperUrl;
import io.conduktor.clustersconfig.api.models.ClusterDefinition;
import io.conduktor.clustersconfig.api.models.ClusterDefinition$HttpAuth$None$;
import io.conduktor.clustersconfig.api.models.ClusterDefinition$JmxAuth$None$;
import io.conduktor.clustersconfig.api.models.ClusterDefinition$KafkaConnect$Auth$None$;
import io.conduktor.clustersconfig.api.models.ClusterDefinition$KafkaConnect$Configs$;
import io.conduktor.clustersconfig.api.models.ClusterDefinition$KsqlDb$Configs$;
import io.conduktor.clustersconfig.api.models.ClusterDefinition$Metrics$Status$Disabled$;
import io.conduktor.clustersconfig.api.models.ClusterDefinition$Metrics$Status$Enabled$;
import io.conduktor.clustersconfig.cluster;
import io.conduktor.clustersconfig.impl.FileStoreRepository;
import io.conduktor.clustersconfig.impl.v3.ClusterConfigurationV3;
import io.conduktor.clustersconfig.impl.v3.ClusterConfigurationV3$ClusterColor$Blue$;
import io.conduktor.clustersconfig.impl.v3.ClusterConfigurationV3$ClusterColor$Green$;
import io.conduktor.clustersconfig.impl.v3.ClusterConfigurationV3$ClusterColor$None$;
import io.conduktor.clustersconfig.impl.v3.ClusterConfigurationV3$ClusterColor$Pink$;
import io.conduktor.clustersconfig.impl.v3.ClusterConfigurationV3$ClusterColor$Red$;
import io.conduktor.clustersconfig.impl.v3.ClusterConfigurationV3$ClusterColor$Teal$;
import io.conduktor.clustersconfig.impl.v3.ClusterConfigurationV3$ClusterColor$Yellow$;
import io.conduktor.clustersconfig.impl.v3.ClusterConfigurationV3$HttpAuth$None$;
import io.conduktor.clustersconfig.impl.v3.ClusterConfigurationV3$JmxAuth$None$;
import io.conduktor.clustersconfig.jmx;
import io.conduktor.clustersconfig.jolokia;
import io.conduktor.clustersconfig.kafkaconnect;
import io.conduktor.clustersconfig.ksql;
import io.conduktor.clustersconfig.properties;
import io.conduktor.clustersconfig.properties$PropertiesMap$;
import io.conduktor.clustersconfig.serialization$UnsafeSerialize$;
import io.conduktor.clustersconfig.serialization$UnsafeSerialize$Ops$newtype$;
import io.conduktor.clustersconfig.ssh;
import io.conduktor.primitives.types.Color;
import io.conduktor.primitives.types.Password;
import io.conduktor.primitives.types.Port;
import io.conduktor.primitives.types.Url;
import io.conduktor.primitives.types.Username;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right$;
import zio.Chunk;
import zio.IO$;
import zio.ZIO;
import zio.ZIO$;
import zio.prelude.AssociativeBoth$;
import zio.prelude.Invariant$;
import zio.prelude.package$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dh\u0001C\b\u0011!\u0003\r\t\u0001\u0005\u000e\t\u000b\u0005\u0002A\u0011A\u0012\t\u000f\u001d\u0002!\u0019!D\u0001Q!)Q\u0006\u0001C\u0001]!)q\n\u0001C\u0005!\")Q\u000e\u0001C\u0005]\"9\u00111\u0005\u0001\u0005\n\u0005\u0015\u0002bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\b\u0003\u000f\u0002A\u0011BA%\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!a\u001b\u0001\t\u0013\ti\u0007C\u0004\u0002\u0000\u0001!I!!!\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\"9\u0011Q\u0015\u0001\u0005\n\u0005\u001d\u0006bBA\\\u0001\u0011%\u0011\u0011\u0018\u0002\u0014)>\u001cE.^:uKJ$UMZ5oSRLwN\u001c\u0006\u0003#I\t!A^\u001a\u000b\u0005M!\u0012\u0001B5na2T!!\u0006\f\u0002\u001d\rdWo\u001d;feN\u001cwN\u001c4jO*\u0011q\u0003G\u0001\nG>tG-^6u_JT\u0011!G\u0001\u0003S>\u001c\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uI\r\u0001A#\u0001\u0013\u0011\u0005q)\u0013B\u0001\u0014\u001e\u0005\u0011)f.\u001b;\u0002\u001b\u0019LG.Z*u_J,'+\u001a9p+\u0005I\u0003C\u0001\u0016,\u001b\u0005\u0011\u0012B\u0001\u0017\u0013\u0005M1\u0015\u000e\\3Ti>\u0014XMU3q_NLGo\u001c:z\u0003M!xn\u00117vgR,'\u000fR3gS:LG/[8o)\ty\u0013\n\u0005\u00031uu*eBA\u00198\u001d\t\u0011T'D\u00014\u0015\t!$%\u0001\u0004=e>|GOP\u0005\u0002m\u0005\u0019!0[8\n\u0005aJ\u0014a\u00029bG.\fw-\u001a\u0006\u0002m%\u00111\b\u0010\u0002\u0003\u0013>S!\u0001O\u001d\u0011\u0005y\u0012eBA A!\t\u0011T$\u0003\u0002B;\u00051\u0001K]3eK\u001aL!a\u0011#\u0003\rM#(/\u001b8h\u0015\t\tU\u0004\u0005\u0002G\u000f6\tA#\u0003\u0002I)\tq1\t\\;ti\u0016\u00148oQ8oM&<\u0007\"\u0002&\u0004\u0001\u0004Y\u0015AB2p]\u001aLw\r\u0005\u0002M\u001b6\t\u0001#\u0003\u0002O!\t12\t\\;ti\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:46'\u0001\u0005nCB\u001cu\u000e\\8s)\t\tF\r\u0005\u0003S-vJfBA*V\u001d\t\u0011D+C\u0001\u001f\u0013\tAT$\u0003\u0002X1\n1Q)\u001b;iKJT!\u0001O\u000f\u0011\u0007qQF,\u0003\u0002\\;\t1q\n\u001d;j_:\u0004\"!\u00182\u000e\u0003yS!a\u00181\u0002\u000bQL\b/Z:\u000b\u0005\u00054\u0012A\u00039sS6LG/\u001b<fg&\u00111M\u0018\u0002\u0006\u0007>dwN\u001d\u0005\u0006K\u0012\u0001\rAZ\u0001\u0006G>dwN\u001d\t\u0003O*t!\u0001\u00145\n\u0005%\u0004\u0012AF\"mkN$XM]\"p]\u001aLw-\u001e:bi&|gNV\u001a\n\u0005-d'\u0001D\"mkN$XM]\"pY>\u0014(BA5\u0011\u0003Ai\u0017\r]&bM.\f7i\u001c8oK\u000e$8\u000fF\u0002p\u0003'\u0001B\u0001\r\u001e>aB\u0019\u0011/!\u0004\u000f\u0007I\f9AD\u0002t\u0003\u0003q!\u0001^?\u000f\u0005U\\hB\u0001<{\u001d\t9\u0018P\u0004\u00023q&\t\u0011$\u0003\u0002\u00181%\u0011QCF\u0005\u0003yR\t1!\u00199j\u0013\tqx0\u0001\u0004n_\u0012,Gn\u001d\u0006\u0003yRIA!a\u0001\u0002\u0006\u0005\t2\t\\;ti\u0016\u0014H)\u001a4j]&$\u0018n\u001c8\u000b\u0005y|\u0018\u0002BA\u0005\u0003\u0017\tAbS1gW\u0006\u001cuN\u001c8fGRTA!a\u0001\u0002\u0006%!\u0011qBA\t\u0005\u001d\u0019uN\u001c4jONTA!!\u0003\u0002\f!9\u0011QC\u0003A\u0002\u0005]\u0011!D6bM.\f7i\u001c8oK\u000e$8\u000fE\u0003S\u00033\ti\"C\u0002\u0002\u001ca\u0013A\u0001T5tiB\u0019q-a\b\n\u0007\u0005\u0005BN\u0001\u0007LC\u001a\\\u0017mQ8o]\u0016\u001cG/\u0001\u0004nCB\u001c6\u000b\u0013\u000b\u0005\u0003O\ti\u0003E\u0002s\u0003SIA!a\u000b\u0002\f\t\u00191k\u0015%\t\u000f\u0005=b\u00011\u0001\u00022\u0005\u00191o\u001d5\u0011\u0007\u001d\f\u0019$C\u0002\u0002,1\f1\"\\1q\u0011R$\b/Q;uQR!\u0011\u0011HA !\r\u0011\u00181H\u0005\u0005\u0003{\tYA\u0001\u0005IiR\u0004\u0018)\u001e;i\u0011\u001d\t\te\u0002a\u0001\u0003\u0007\nA!Y;uQB\u0019q-!\u0012\n\u0007\u0005uB.\u0001\u0006nCBTU\u000e_!vi\"$B!a\u0013\u0002RA\u0019!/!\u0014\n\t\u0005=\u00131\u0002\u0002\b\u00156D\u0018)\u001e;i\u0011\u001d\t\t\u0005\u0003a\u0001\u0003'\u00022aZA+\u0013\r\ty\u0005\\\u0001\u000f[\u0006\u00048j]9m'\u0016\u0014h/\u001a:t)\u0011\tY&a\u0019\u0011\u000bART(!\u0018\u0011\u0007I\fy&\u0003\u0003\u0002b\u0005-!AB&tc2$%\rC\u0004\u0002f%\u0001\r!a\u001a\u0002\r-\u001c\u0018\u000f\u001c3c!\r9\u0017\u0011N\u0005\u0004\u0003Cb\u0017\u0001D7ba.\u000bgm[1BkRDG\u0003BA8\u0003k\u00022!]A9\u0013\u0011\t\u0019(!\u0005\u0003\t\u0005+H\u000f\u001b\u0005\b\u0003oR\u0001\u0019AA=\u0003AY\u0017MZ6b\u0007>tg.Z2u\u0003V$\b\u000eE\u0002h\u0003wJ1!! m\u0005AY\u0015MZ6b\u0007>tg.Z2u\u0003V$\b.\u0001\u0006nCBlU\r\u001e:jGN$B!a!\u0002\fB)\u0001GO\u001f\u0002\u0006B\u0019!/a\"\n\t\u0005%\u00151\u0002\u0002\b\u001b\u0016$(/[2t\u0011\u001d\tii\u0003a\u0001\u0003\u001f\u000b\u0011\"\\3ue&\u001c7OV\u001a\u0011\u0007\u001d\f\t*C\u0002\u0002\n2\f\u0011#\\1q'\u000eDW-\\1SK\u001eL7\u000f\u001e:z)\u0011\t9*!(\u0011\u0007I\fI*\u0003\u0003\u0002\u001c\u0006-!AD*dQ\u0016l\u0017MU3hSN$(/\u001f\u0005\b\u0003?c\u0001\u0019AAQ\u0003)\u0011XmZ5tiJLhk\r\t\u0004O\u0006\r\u0016bAANY\u00061R.\u00199U_\u000ecWo\u001d;fe\u0012+g-\u001b8ji&|g\u000e\u0006\u0003\u0002*\u0006M\u0006#\u0002\u0019;{\u0005-\u0006\u0003BAW\u0003_k!!!\u0002\n\t\u0005E\u0016Q\u0001\u0002\u0012\u00072,8\u000f^3s\t\u00164\u0017N\\5uS>t\u0007BBA[\u001b\u0001\u00071*\u0001\fdYV\u001cH/\u001a:D_:4\u0017nZ;sCRLwN\u001c,4\u00031i\u0017\r]*u_J,g)\u001b7f)\u0019\tY,a2\u0002NB)\u0001GO\u001f\u0002>B!ADWA`!\u0011\t\t-a1\u000f\t\u00055\u0016\u0011A\u0005\u0005\u0003\u000b\fYA\u0001\tTi>\u0014XMR5mK\u000e{g\u000e^3oi\"9\u0011\u0011\u001a\bA\u0002\u0005-\u0017\u0001\u00029bi\"\u00042\u0001\b.>\u0011\u001d\tyM\u0004a\u0001\u0003#\f\u0001\u0002]1tg^|'\u000f\u001a\t\u00059i\u000b\u0019\u000e\u0005\u0004\u0002V\u0006m\u0017\u0011\u001d\b\u0004k\u0006]\u0017bAAm)\u0005i1/\u001a:jC2L'0\u0019;j_:LA!!8\u0002`\nyQK\\:bM\u0016\u001cVM]5bY&TXMC\u0002\u0002ZR\u00012!XAr\u0013\r\t)O\u0018\u0002\t!\u0006\u001c8o^8sI\u0002")
public interface ToClusterDefinition {
    public FileStoreRepository fileStoreRepo();

    public static /* synthetic */ ZIO toClusterDefinition$(ToClusterDefinition $this, ClusterConfigurationV3 config) {
        return $this.toClusterDefinition(config);
    }

    default public ZIO<Object, String, ClustersConfig> toClusterDefinition(ClusterConfigurationV3 config) {
        return this.mapToClusterDefinition(config).map((Function1 & Serializable)d -> new ClustersConfig((List<ClusterDefinition>)((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterDefinition[]{d})))));
    }

    private Either<String, Option<Color>> mapColor(ClusterConfigurationV3.ClusterColor color) {
        None$ none$;
        Right$ right$ = scala.package$.MODULE$.Right();
        ClusterConfigurationV3.ClusterColor clusterColor = color;
        if (ClusterConfigurationV3$ClusterColor$None$.MODULE$.equals(clusterColor)) {
            none$ = None$.MODULE$;
        } else if (ClusterConfigurationV3$ClusterColor$Blue$.MODULE$.equals(clusterColor)) {
            none$ = new Some((Object)new Color((Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)81))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)134))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)249))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)255))).value()));
        } else if (ClusterConfigurationV3$ClusterColor$Red$.MODULE$.equals(clusterColor)) {
            none$ = new Some((Object)new Color((Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)227))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)74))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)53))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)255))).value()));
        } else if (ClusterConfigurationV3$ClusterColor$Green$.MODULE$.equals(clusterColor)) {
            none$ = new Some((Object)new Color((Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)91))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)208))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)116))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)255))).value()));
        } else if (ClusterConfigurationV3$ClusterColor$Yellow$.MODULE$.equals(clusterColor)) {
            none$ = new Some((Object)new Color((Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)191))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)193))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)75))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)255))).value()));
        } else if (ClusterConfigurationV3$ClusterColor$Pink$.MODULE$.equals(clusterColor)) {
            none$ = new Some((Object)new Color((Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)236))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)171))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)237))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)255))).value()));
        } else if (ClusterConfigurationV3$ClusterColor$Teal$.MODULE$.equals(clusterColor)) {
            none$ = new Some((Object)new Color((Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)90))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)214))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)197))).value(), (Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)255))).value()));
        } else {
            throw new MatchError((Object)clusterColor);
        }
        return right$.apply((Object)none$);
    }

    private ZIO<Object, String, ClusterDefinition.KafkaConnect.Configs> mapKafkaConnects(List<ClusterConfigurationV3.KafkaConnect> kafkaConnects) {
        ZIO connects = (ZIO)package$.MODULE$.ForEachOps(kafkaConnects).forEach((Function1 & Serializable)kafkaConnect -> {
            ClusterDefinition.KafkaConnect.Auth auth = this.mapKafkaAuth(kafkaConnect.auth());
            properties.HeadersMap<String> headers = kafkaConnect.headers();
            kafkaconnect.UnsecuredHttps unsecuredHttps = kafkaConnect.auth().unsecuredHttps();
            ZIO<Object, String, Option<ClusterDefinition.StoreFileContent>> keystore = this.mapStoreFile(kafkaConnect.auth().keyStoreFilePath(), kafkaConnect.auth().keyStoreFilePassword());
            ZIO<Object, String, Option<ClusterDefinition.StoreFileContent>> truststore = this.mapStoreFile(kafkaConnect.auth().trustStoreFilePath(), kafkaConnect.auth().trustStoreFilePassword());
            return keystore.zip(truststore).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Option keyStoreContent = (Option)tuple2._1();
                Option trustStoreContent = (Option)tuple2._2();
                ClusterDefinition.KafkaConnect kafkaConnect = new ClusterDefinition.KafkaConnect(kafkaConnect.id(), kafkaConnect.name(), auth, headers, (Option<ClusterDefinition.StoreFileContent>)keyStoreContent, (Option<ClusterDefinition.StoreFileContent>)trustStoreContent, unsecuredHttps, kafkaConnect.url());
                return kafkaConnect;
            });
        }, AssociativeBoth$.MODULE$.ZIOIdentityBoth(), Invariant$.MODULE$.ZIOCovariant(), Invariant$.MODULE$.ListForEach());
        return connects.map((Function1)ClusterDefinition$KafkaConnect$Configs$.MODULE$);
    }

    private ClusterDefinition.SSH mapSSH(ClusterConfigurationV3.SSH ssh2) {
        Product product;
        ClusterConfigurationV3.SSH.Auth auth = ssh2.method();
        if (auth instanceof ClusterConfigurationV3.SSH.Auth.Password) {
            ClusterDefinition.SSH.Auth.Password password;
            ClusterConfigurationV3.SSH.Auth.Password password2 = (ClusterConfigurationV3.SSH.Auth.Password)auth;
            Option<Object> pwd = password2.pwd();
            Option<Object> option = pwd;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object p = some.value();
                password = new ClusterDefinition.SSH.Auth.Password((Option<Password>)new Some((Object)new Password(serialization$UnsafeSerialize$Ops$newtype$.MODULE$.value$extension(serialization$UnsafeSerialize$.MODULE$.Ops$newtype(p)))));
            } else if (None$.MODULE$.equals(option)) {
                password = new ClusterDefinition.SSH.Auth.Password((Option<Password>)None$.MODULE$);
            } else {
                throw new MatchError(option);
            }
            product = password;
        } else if (auth instanceof ClusterConfigurationV3.SSH.Auth.KeyPair) {
            ClusterConfigurationV3.SSH.Auth.KeyPair keyPair = (ClusterConfigurationV3.SSH.Auth.KeyPair)auth;
            String location = keyPair.location();
            Object passphrase = keyPair.passphrase();
            product = new ClusterDefinition.SSH.Auth.KeyPair(location, serialization$UnsafeSerialize$Ops$newtype$.MODULE$.value$extension(serialization$UnsafeSerialize$.MODULE$.Ops$newtype(passphrase)));
        } else {
            throw new MatchError((Object)auth);
        }
        Product method = product;
        ssh.Status x$1 = ssh2.enabled();
        Username x$2 = ssh2.user();
        Product x$3 = method;
        Port x$4 = ssh2.port();
        return new ClusterDefinition.SSH(x$1, x$2, x$4, (ClusterDefinition.SSH.Auth)x$3);
    }

    private ClusterDefinition.HttpAuth mapHttpAuth(ClusterConfigurationV3.HttpAuth auth) {
        ClusterDefinition.HttpAuth httpAuth;
        ClusterConfigurationV3.HttpAuth httpAuth2 = auth;
        if (httpAuth2 instanceof ClusterConfigurationV3.HttpAuth.Basic) {
            ClusterConfigurationV3.HttpAuth.Basic basic = (ClusterConfigurationV3.HttpAuth.Basic)httpAuth2;
            Username username = basic.username();
            Object password = basic.password();
            httpAuth = new ClusterDefinition.HttpAuth.Basic(username, new Password(serialization$UnsafeSerialize$Ops$newtype$.MODULE$.value$extension(serialization$UnsafeSerialize$.MODULE$.Ops$newtype(password))));
        } else if (httpAuth2 instanceof ClusterConfigurationV3.HttpAuth.Bearer) {
            ClusterConfigurationV3.HttpAuth.Bearer bearer = (ClusterConfigurationV3.HttpAuth.Bearer)httpAuth2;
            Object token = bearer.token();
            httpAuth = new ClusterDefinition.HttpAuth.Bearer(serialization$UnsafeSerialize$Ops$newtype$.MODULE$.value$extension(serialization$UnsafeSerialize$.MODULE$.Ops$newtype(token)));
        } else if (ClusterConfigurationV3$HttpAuth$None$.MODULE$.equals(httpAuth2)) {
            httpAuth = ClusterDefinition$HttpAuth$None$.MODULE$;
        } else {
            throw new MatchError((Object)httpAuth2);
        }
        return httpAuth;
    }

    private ClusterDefinition.JmxAuth mapJmxAuth(ClusterConfigurationV3.JmxAuth auth) {
        Product product;
        ClusterConfigurationV3.JmxAuth jmxAuth = auth;
        if (ClusterConfigurationV3$JmxAuth$None$.MODULE$.equals(jmxAuth)) {
            product = ClusterDefinition$JmxAuth$None$.MODULE$;
        } else if (jmxAuth instanceof ClusterConfigurationV3.JmxAuth.Credentials) {
            ClusterConfigurationV3.JmxAuth.Credentials credentials = (ClusterConfigurationV3.JmxAuth.Credentials)jmxAuth;
            Username username = credentials.username();
            Object password = credentials.password();
            product = new ClusterDefinition.JmxAuth.Credentials(username, new Password(serialization$UnsafeSerialize$Ops$newtype$.MODULE$.value$extension(serialization$UnsafeSerialize$.MODULE$.Ops$newtype(password))));
        } else {
            throw new MatchError((Object)jmxAuth);
        }
        return product;
    }

    private ZIO<Object, String, ClusterDefinition.KsqlDb> mapKsqlServers(ClusterConfigurationV3.KsqlDb ksqldb) {
        ClusterDefinition.HttpAuth auth = this.mapHttpAuth(ksqldb.auth());
        return this.mapStoreFile(ksqldb.keyStoreFilePath(), ksqldb.keyStoreFilePassword()).zip(this.mapStoreFile(ksqldb.trustStoreFilePath(), ksqldb.trustStoreFilePassword())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option keyStore = (Option)tuple2._1();
            Option trustStore = (Option)tuple2._2();
            ksql.Id x$1 = ksqldb.id();
            ksql.Name x$2 = ksqldb.name();
            ClusterDefinition.HttpAuth x$3 = auth;
            properties.HeadersMap<String> x$4 = ksqldb.headers();
            Option x$5 = keyStore;
            Option x$6 = trustStore;
            Option<Url> x$7 = ksqldb.url();
            ClusterDefinition.KsqlDb ksqlDb = new ClusterDefinition.KsqlDb(x$3, x$1, x$2, x$4, (Option<ClusterDefinition.StoreFileContent>)x$5, (Option<ClusterDefinition.StoreFileContent>)x$6, x$7);
            return ksqlDb;
        });
    }

    private ClusterDefinition.KafkaConnect.Auth mapKafkaAuth(ClusterConfigurationV3.KafkaConnectAuth kafkaConnectAuth) {
        Option basic = kafkaConnectAuth.username().zip(kafkaConnectAuth.password()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Username u = (Username)tuple2._1();
            Object p = tuple2._2();
            ClusterDefinition.KafkaConnect.Auth.Basic basic = new ClusterDefinition.KafkaConnect.Auth.Basic(u, new Password(serialization$UnsafeSerialize$Ops$newtype$.MODULE$.value$extension(serialization$UnsafeSerialize$.MODULE$.Ops$newtype(p))));
            return basic;
        });
        Option bearer = kafkaConnectAuth.token().map((Function1 & Serializable)t -> new ClusterDefinition.KafkaConnect.Auth.Bearer(serialization$UnsafeSerialize$Ops$newtype$.MODULE$.value$extension(serialization$UnsafeSerialize$.MODULE$.Ops$newtype(t))));
        return (ClusterDefinition.KafkaConnect.Auth)basic.orElse((Function0 & Serializable)() -> bearer).getOrElse((Function0 & Serializable)() -> ClusterDefinition$KafkaConnect$Auth$None$.MODULE$);
    }

    private ZIO<Object, String, ClusterDefinition.Metrics> mapMetrics(ClusterConfigurationV3.Metrics metricsV3) {
        ZIO zIO;
        ClusterConfigurationV3.MetricsMethod metricsMethod = metricsV3.method();
        if (metricsMethod instanceof ClusterConfigurationV3.MetricsMethod.Jmx) {
            ClusterConfigurationV3.MetricsMethod.Jmx jmx2 = (ClusterConfigurationV3.MetricsMethod.Jmx)metricsMethod;
            Port port = jmx2.port();
            jmx.SecuredRegistry securedRegistry = jmx2.securedRegistry();
            ClusterConfigurationV3.JmxAuth auth = jmx2.auth();
            Option<String> keyStoreFilePath = jmx2.keyStoreFilePath();
            Option<Object> keyStoreFilePassword = jmx2.keyStoreFilePassword();
            Option<String> trustStoreFilePath = jmx2.trustStoreFilePath();
            Option<Object> trustStoreFilePassword = jmx2.trustStoreFilePassword();
            zIO = this.mapStoreFile(keyStoreFilePath, keyStoreFilePassword).flatMap((Function1 & Serializable)keyStore -> this.mapStoreFile(trustStoreFilePath, trustStoreFilePassword).map((Function1 & Serializable)trustStore -> new ClusterDefinition.MetricsMethod.Jmx(this.mapJmxAuth(auth), port, (Option<ClusterDefinition.StoreFileContent>)keyStore, securedRegistry, (Option<ClusterDefinition.StoreFileContent>)trustStore)));
        } else if (metricsMethod instanceof ClusterConfigurationV3.MetricsMethod.Jolokia) {
            ClusterConfigurationV3.MetricsMethod.Jolokia jolokia2 = (ClusterConfigurationV3.MetricsMethod.Jolokia)metricsMethod;
            Port port = jolokia2.port();
            jolokia.Prefix prefix = jolokia2.prefix();
            jolokia.Protocol protocol = jolokia2.protocol();
            ClusterConfigurationV3.HttpAuth auth = jolokia2.auth();
            zIO = IO$.MODULE$.succeed((Function0 & Serializable)() -> {
                Port x$1 = port;
                jolokia.Prefix x$2 = prefix;
                jolokia.Protocol x$3 = protocol;
                ClusterDefinition.HttpAuth x$4 = this.mapHttpAuth(auth);
                return new ClusterDefinition.MetricsMethod.Jolokia(x$4, x$1, x$2, x$3);
            });
        } else {
            throw new MatchError((Object)metricsMethod);
        }
        return zIO.map((Function1 & Serializable)method -> {
            Product enabled = metricsV3.enabled() ? ClusterDefinition$Metrics$Status$Enabled$.MODULE$ : ClusterDefinition$Metrics$Status$Disabled$.MODULE$;
            return new ClusterDefinition.Metrics((ClusterDefinition.Metrics.Status)enabled, (Option<ClusterDefinition.MetricsMethod>)new Some(method));
        });
    }

    private ClusterDefinition.SchemaRegistry mapSchemaRegistry(ClusterConfigurationV3.SchemaRegistry registryV3) {
        return new ClusterDefinition.SchemaRegistry(this.mapHttpAuth(registryV3.auth()), registryV3.url(), (properties.PropertiesMap)registryV3.additionalProperties().getOrElse((Function0 & Serializable)() -> properties$PropertiesMap$.MODULE$.empty()));
    }

    private ZIO<Object, String, ClusterDefinition> mapToClusterDefinition(ClusterConfigurationV3 clusterConfigurationV3) {
        return ZIO$.MODULE$.fromEither((Function0 & Serializable)() -> this.mapColor(clusterConfigurationV3.color())).flatMap((Function1 & Serializable)color -> {
            properties.PropertiesMap additionalProperties = (properties.PropertiesMap)clusterConfigurationV3.additionalProperties().getOrElse((Function0 & Serializable)() -> properties$PropertiesMap$.MODULE$.empty());
            return this.mapKafkaConnects(clusterConfigurationV3.kafkaConnects().configs()).flatMap((Function1 & Serializable)kafkaConnects -> ((ZIO)package$.MODULE$.ForEachOps(clusterConfigurationV3.ksqlDbServers().configs()).forEach((Function1 & Serializable)ksqldb -> this.mapKsqlServers((ClusterConfigurationV3.KsqlDb)ksqldb), AssociativeBoth$.MODULE$.ZIOIdentityBoth(), Invariant$.MODULE$.ZIOCovariant(), Invariant$.MODULE$.ListForEach())).map((Function1)ClusterDefinition$KsqlDb$Configs$.MODULE$).flatMap((Function1 & Serializable)ksqlDbServers -> ((ZIO)package$.MODULE$.ForEachOps(clusterConfigurationV3.metrics()).forEach((Function1 & Serializable)metricsV3 -> this.mapMetrics((ClusterConfigurationV3.Metrics)metricsV3), AssociativeBoth$.MODULE$.ZIOIdentityBoth(), Invariant$.MODULE$.ZIOCovariant(), Invariant$.MODULE$.OptionForEach())).map((Function1 & Serializable)metrics -> {
                Option registry = clusterConfigurationV3.schemaRegistry().map((Function1 & Serializable)registryV3 -> this.mapSchemaRegistry((ClusterConfigurationV3.SchemaRegistry)registryV3));
                cluster.GroupsDefinition registryGroups = clusterConfigurationV3.schemaRegistryGroups().toGroupDefinition();
                cluster.GroupsDefinition topicGroups = clusterConfigurationV3.topicGroups().toGroupDefinition();
                Option<ClusterConfigurationV3.SSH> ssh3 = clusterConfigurationV3.ssh();
                Option<ZookeeperUrl> zookeeperUrl = clusterConfigurationV3.zookeeperUrl();
                cluster.BootstrapServers x$1 = clusterConfigurationV3.bootstrapServers();
                cluster.Name x$2 = clusterConfigurationV3.clusterName();
                Option x$3 = color;
                cluster.InternalId x$4 = clusterConfigurationV3.internalId();
                properties.PropertiesMap x$5 = additionalProperties;
                ClusterDefinition.KafkaConnect.Configs x$6 = kafkaConnects;
                ClusterDefinition.KsqlDb.Configs x$7 = ksqlDbServers;
                Option x$8 = metrics;
                Option x$9 = registry;
                Some x$10 = new Some((Object)new SchemaRegistryGroups(registryGroups));
                Some x$11 = new Some((Object)new TopicGroups(topicGroups));
                Option x$12 = ssh3.map((Function1 & Serializable)ssh2 -> this.mapSSH((ClusterConfigurationV3.SSH)ssh2));
                Option<ZookeeperUrl> x$13 = zookeeperUrl;
                return new ClusterDefinition(x$1, x$2, (Option<Color>)x$3, x$4, x$5, x$6, x$7, (Option<ClusterDefinition.Metrics>)x$8, (Option<ClusterDefinition.SchemaRegistry>)x$9, (Option<SchemaRegistryGroups>)x$10, (Option<ClusterDefinition.SSH>)x$12, (Option<TopicGroups>)x$11, x$13);
            })));
        });
    }

    private ZIO<Object, String, Option<ClusterDefinition.StoreFileContent>> mapStoreFile(Option<String> path, Option<Object> password) {
        return (ZIO)package$.MODULE$.ForEachOps((Object)path.zip(password)).forEach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Object pwd = tuple2._2();
            ZIO zIO = this.fileStoreRepo().readContent(path).map((Function1 & Serializable)content -> new ClusterDefinition.StoreFileContent(new Password(serialization$UnsafeSerialize$Ops$newtype$.MODULE$.value$extension(serialization$UnsafeSerialize$.MODULE$.Ops$newtype(pwd))), (Chunk<Object>)content, new Path(path)));
            return zIO;
        }, AssociativeBoth$.MODULE$.ZIOIdentityBoth(), Invariant$.MODULE$.ZIOCovariant(), Invariant$.MODULE$.OptionForEach());
    }

    public static void $init$(ToClusterDefinition $this) {
    }
}

