/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import io.confluent.ksql.function.KsqlFunction;
import io.confluent.ksql.function.KsqlTableFunction;
import io.confluent.ksql.function.UdfIndex;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.udf.UdfMetadata;
import io.confluent.ksql.schema.ksql.SqlArgument;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TableFunctionFactory {
    private final UdfIndex<KsqlTableFunction> udtfIndex;
    private final UdfMetadata metadata;

    public TableFunctionFactory(UdfMetadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata");
        this.udtfIndex = new UdfIndex(metadata.getName(), true);
    }

    public UdfMetadata getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.metadata.getName();
    }

    public synchronized void eachFunction(Consumer<KsqlTableFunction> consumer) {
        this.udtfIndex.values().forEach(consumer);
    }

    public synchronized KsqlTableFunction createTableFunction(List<SqlArgument> argTypes) {
        return this.udtfIndex.getFunction(argTypes);
    }

    protected synchronized List<List<ParamType>> supportedParams() {
        return this.udtfIndex.values().stream().map(KsqlFunction::parameters).collect(Collectors.toList());
    }

    synchronized void addFunction(KsqlTableFunction tableFunction) {
        this.udtfIndex.addFunction(tableFunction);
    }
}

