/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.config;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.testing.EffectivelyImmutable;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Map;
import java.util.Objects;

@Immutable
public final class SessionConfig {
    @EffectivelyImmutable
    private final ImmutableMap<String, Object> overrides;
    private final KsqlConfig systemConfig;

    public static SessionConfig of(KsqlConfig systemConfig, Map<String, ?> overrides) {
        return new SessionConfig(systemConfig, overrides);
    }

    public SessionConfig copyWith(Map<String, ?> additionOverrides) {
        ImmutableMap newOverrides = ImmutableMap.builder().putAll(this.overrides).putAll(additionOverrides).build();
        return new SessionConfig(this.systemConfig, (Map<String, ?>)newOverrides);
    }

    private SessionConfig(KsqlConfig systemConfig, Map<String, ?> overrides) {
        this.systemConfig = Objects.requireNonNull(systemConfig, "systemConfig");
        this.overrides = ImmutableMap.copyOf(Objects.requireNonNull(overrides, "overrides"));
    }

    public KsqlConfig getConfig(boolean withOverridesApplied) {
        return withOverridesApplied ? this.systemConfig.cloneWithPropertyOverwrite((Map<String, ?>)this.overrides) : this.systemConfig;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="overrides is ImmutableMap")
    public Map<String, Object> getOverrides() {
        return this.overrides;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionConfig that = (SessionConfig)o;
        return Objects.equals(this.overrides, that.overrides) && Objects.equals((Object)this.systemConfig, (Object)that.systemConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.overrides, this.systemConfig});
    }

    public String toString() {
        return "SessionConfig{overrides=" + this.overrides + ", systemConfig=" + (Object)((Object)this.systemConfig) + '}';
    }
}

