/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.config.ConfigItem;
import io.confluent.ksql.config.KsqlConfigResolver;
import io.confluent.ksql.rest.entity.KsqlEntity;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PropertiesList
extends KsqlEntity {
    private static final List<String> QueryLevelPropertyList = ImmutableList.of((Object)"ksql.cast.strings.preserve.nulls", (Object)"ksql.nested.error.set.null", (Object)"ksql.query.error.max.queue.size", (Object)"ksql.query.retry.backoff.initial.ms", (Object)"ksql.query.retry.backoff.max.ms", (Object)"ksql.timestamp.throw.on.invalid", (Object)"ksql.fail.on.deserialization.error");
    public static final List<String> EditablePropertyList = ImmutableList.of((Object)"max.poll.records", (Object)"max.poll.interval.ms", (Object)"session.timeout.ms", (Object)"heartbeat.interval.ms", (Object)"auto.offset.reset", (Object)"fetch.min.bytes", (Object)"fetch.max.bytes", (Object)"fetch.max.wait.ms", (Object)"metadata.max.age.ms", (Object)"max.partition.fetch.bytes", (Object)"send.buffer.bytes", (Object)"receive.buffer.bytes", (Object[])new String[]{"client.rack", "reconnect.backoff.ms", "reconnect.backoff.max.ms", "retry.backoff.ms", "metrics.sample.window.ms", "metrics.num.samples", "metrics.recording.level", "check.crcs", "key.deserializer", "value.deserializer", "socket.connection.setup.timeout.ms", "socket.connection.setup.timeout.max.ms", "connections.max.idle.ms", "request.timeout.ms", "default.api.timeout.ms", "interceptor.classes", "exclude.internal.topics", "isolation.level", "allow.auto.create.topics", "security.providers", "metadata.max.idle.ms", "batch.size", "acks", "linger.ms", "delivery.timeout.ms", "max.request.size", "max.block.ms", "buffer.memory", "compression.type", "retries", "key.serializer", "value.serializer", "partitioner.class", "enable.idempotence", "transaction.timeout.ms", "acceptable.recovery.lag", "application.server", "built.in.metrics.version", "cache.max.bytes.buffering", "commit.interval.ms", "default.deserialization.exception.handler", "default.production.exception.handler", "default.key.serde", "default.value.serde", "default.timestamp.extractor", "max.task.idle.ms", "max.warmup.replicas", "num.standby.replicas", "poll.ms", "probing.rebalance.interval.ms", "processing.guarantee", "replication.factor", "rocksdb.config.setter", "security.protocol", "state.cleanup.delay.ms", "state.dir", "task.timeout.ms", "window.size.ms", "upgrade.from"});
    private final ImmutableList<Property> properties;
    private final ImmutableList<String> overwrittenProperties;
    private final ImmutableList<String> defaultProperties;

    @JsonCreator
    public PropertiesList(@JsonProperty(value="statementText") String statementText, @JsonProperty(value="properties") List<Property> properties, @JsonProperty(value="overwrittenProperties") List<String> overwrittenProperties, @JsonProperty(value="defaultProperties") List<String> defaultProperties) {
        super(statementText);
        this.properties = ImmutableList.copyOf(properties);
        this.overwrittenProperties = ImmutableList.copyOf(overwrittenProperties);
        this.defaultProperties = ImmutableList.copyOf(defaultProperties);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="properties is ImmutableList")
    public List<Property> getProperties() {
        return this.properties;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="overwrittenProperties is ImmutableList")
    public List<String> getOverwrittenProperties() {
        return this.overwrittenProperties;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="defaultProperties is ImmutableList")
    public List<String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public boolean equals(Object o) {
        return o instanceof PropertiesList && Objects.equals(this.properties, ((PropertiesList)o).properties) && Objects.equals(this.overwrittenProperties, ((PropertiesList)o).overwrittenProperties) && Objects.equals(this.defaultProperties, ((PropertiesList)o).defaultProperties);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.overwrittenProperties, this.defaultProperties);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Property {
        private final String name;
        private final String scope;
        private final String value;
        @JsonProperty(value="editable")
        private final boolean editable;
        @JsonProperty(value="level")
        private final String level;

        @JsonCreator
        public Property(@JsonProperty(value="name") String name, @JsonProperty(value="scope") String scope, @JsonProperty(value="value") String value) {
            this.name = name;
            this.scope = scope;
            this.value = value;
            this.editable = Property.isEditable(name);
            this.level = QueryLevelPropertyList.contains(name) ? "QUERY" : "SERVER";
        }

        public static boolean isEditable(String propertyName) {
            KsqlConfigResolver resolver = new KsqlConfigResolver();
            Optional resolvedItem = resolver.resolve(propertyName, false);
            return resolvedItem.isPresent() && EditablePropertyList.contains(((ConfigItem)resolvedItem.get()).getPropertyName());
        }

        public String getLevel() {
            return this.level;
        }

        public boolean getEditable() {
            return this.editable;
        }

        public String getName() {
            return this.name;
        }

        public String getScope() {
            return this.scope;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Property that = (Property)object;
            return Objects.equals(this.name, that.name) && Objects.equals(this.scope, that.scope) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.scope, this.value);
        }

        public String toString() {
            return "Property{name='" + this.name + '\'' + ", scope='" + this.scope + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }
}

