/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.entity.HealthCheckResponseDetail;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class HealthCheckResponse {
    private final boolean isHealthy;
    private final ImmutableMap<String, HealthCheckResponseDetail> details;

    @JsonCreator
    public HealthCheckResponse(@JsonProperty(value="isHealthy") boolean isHealthy, @JsonProperty(value="details") Map<String, HealthCheckResponseDetail> details) {
        this.isHealthy = isHealthy;
        this.details = ImmutableMap.copyOf(Objects.requireNonNull(details, "details"));
    }

    public boolean getIsHealthy() {
        return this.isHealthy;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="details is ImmutableMap")
    public Map<String, HealthCheckResponseDetail> getDetails() {
        return this.details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthCheckResponse that = (HealthCheckResponse)o;
        return this.isHealthy == that.isHealthy && Objects.equals(this.details, that.details);
    }

    public int hashCode() {
        return Objects.hash(this.isHealthy, this.details);
    }
}

