/*
 * Decompiled with CFR 0.152.
 */
package com.github.kittinunf.fuel.core.requests;

import com.github.kittinunf.fuel.core.Body;
import com.github.kittinunf.fuel.core.Deserializable;
import com.github.kittinunf.fuel.core.DeserializableKt;
import com.github.kittinunf.fuel.core.FuelError;
import com.github.kittinunf.fuel.core.Handler;
import com.github.kittinunf.fuel.core.Headers;
import com.github.kittinunf.fuel.core.Method;
import com.github.kittinunf.fuel.core.Request;
import com.github.kittinunf.fuel.core.RequestExecutionOptions;
import com.github.kittinunf.fuel.core.Response;
import com.github.kittinunf.fuel.core.ResponseDeserializable;
import com.github.kittinunf.fuel.core.ResponseHandler;
import com.github.kittinunf.fuel.core.deserializers.ByteArrayDeserializer;
import com.github.kittinunf.fuel.core.deserializers.StringDeserializer;
import com.github.kittinunf.fuel.core.requests.CancellableRequest;
import com.github.kittinunf.fuel.core.requests.DefaultBody;
import com.github.kittinunf.result.Result;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0083\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012 \b\u0002\u0010\b\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n0\tj\u0002`\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\u0018\b\u0002\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u0011j\u0002`\u0012\u0012\u001c\b\u0002\u0010\u0013\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\f0\u0011j\u0002`\u0015\u00a2\u0006\u0002\u0010\u0016J\u0010\u00104\u001a\u00020\u00012\u0006\u00104\u001a\u000205H\u0016J9\u00106\u001a\u00020\u00012*\u00107\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n08\"\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016\u00a2\u0006\u0002\u00109J\u0018\u00106\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\fH\u0016J)\u00106\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u000b2\u0012\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f08\"\u00020\fH\u0016\u00a2\u0006\u0002\u0010=J\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u000fH\u0016J@\u0010\u001b\u001a\u00020\u00012\u0010\u0010>\u001a\f\u0012\u0004\u0012\u00020@0?j\u0002`A2\u0014\u0010B\u001a\u0010\u0012\u0004\u0012\u00020C\u0018\u00010?j\u0004\u0018\u0001`D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u000205H\u0016J\u0018\u0010\u001b\u001a\u00020\u00012\u0006\u0010H\u001a\u00020I2\u0006\u0010E\u001a\u00020FH\u0016J6\u0010\u001b\u001a\u00020\u00012\u0006\u0010J\u001a\u00020@2\u0014\u0010B\u001a\u0010\u0012\u0004\u0012\u00020C\u0018\u00010?j\u0004\u0018\u0001`D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u000205H\u0016J\u0018\u0010\u001b\u001a\u00020\u00012\u0006\u0010K\u001a\u00020L2\u0006\u0010E\u001a\u00020FH\u0016J\u0018\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020FH\u0016J\t\u0010M\u001a\u00020\u0003H\u00c6\u0003J\t\u0010N\u001a\u00020\u0005H\u00c6\u0003J\t\u0010O\u001a\u00020\u0007H\u00c6\u0003J!\u0010P\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n0\tj\u0002`\rH\u00c6\u0003J\u000e\u0010Q\u001a\u00020\u000fH\u00c0\u0003\u00a2\u0006\u0002\bRJ\u0019\u0010S\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u0011j\u0002`\u0012H\u00c6\u0003J\u001d\u0010T\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\f0\u0011j\u0002`\u0015H\u00c2\u0003J\u008b\u0001\u0010U\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072 \b\u0002\u0010\b\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n0\tj\u0002`\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0018\b\u0002\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u0011j\u0002`\u00122\u001c\b\u0002\u0010\u0013\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\f0\u0011j\u0002`\u0015H\u00c6\u0001J\u0013\u0010V\u001a\u0002052\b\u0010W\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\u001b\u0010X\u001a\f\u0012\u0004\u0012\u00020\u000b0Yj\u0002`Z2\u0006\u0010:\u001a\u00020\u000bH\u0096\u0002J'\u0010[\u001a\u0004\u0018\u0001H\\\"\b\b\u0000\u0010\\*\u00020\f2\f\u0010]\u001a\b\u0012\u0004\u0012\u0002H\\0\u0014H\u0016\u00a2\u0006\u0002\u0010^J\t\u0010_\u001a\u00020`H\u00d6\u0001J9\u0010:\u001a\u00020\u00012*\u00107\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n08\"\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016\u00a2\u0006\u0002\u00109J\u001a\u0010:\u001a\f\u0012\u0004\u0012\u00020\u000b0Yj\u0002`Z2\u0006\u0010:\u001a\u00020\u000bH\u0016J\u0018\u0010:\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\fH\u0016J)\u0010:\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u000b2\u0012\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f08\"\u00020\fH\u0016\u00a2\u0006\u0002\u0010=J\u001c\u0010:\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u000b2\n\u0010<\u001a\u0006\u0012\u0002\b\u00030YH\u0016J\u001c\u0010:\u001a\u00020\u00012\u0012\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0bH\u0016J \u0010c\u001a\u00020\u00012\u0016\u0010c\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020e0dj\u0002`fH\u0016JD\u0010g\u001a\u00020\u00012:\u0010h\u001a6\u0012\u0013\u0012\u00110C\u00a2\u0006\f\bj\u0012\b\bk\u0012\u0004\b\b(l\u0012\u0013\u0012\u00110C\u00a2\u0006\f\bj\u0012\b\bk\u0012\u0004\b\b(m\u0012\u0004\u0012\u00020e0ij\u0002`nH\u0016J0\u0010o\u001a*\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020s0r0pj\b\u0012\u0004\u0012\u00020L`tH\u0016J\u0016\u0010o\u001a\u00020u2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020L0vH\u0016J\u0016\u0010o\u001a\u00020u2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020L0wH\u0016J>\u0010o\u001a\u00020u24\u0010h\u001a0\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0xj\b\u0012\u0004\u0012\u00020L`yH\u0016J2\u0010o\u001a\u00020u2(\u0010h\u001a$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0dj\b\u0012\u0004\u0012\u00020L`zH\u0016JH\u0010{\u001a*\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\\\u0012\u0004\u0012\u00020s0r0pj\b\u0012\u0004\u0012\u0002H\\`t\"\b\b\u0000\u0010\\*\u00020\f2\f\u0010|\u001a\b\u0012\u0004\u0012\u0002H\\0}H\u0016J.\u0010{\u001a\u00020u\"\b\b\u0000\u0010\\*\u00020\f2\f\u0010|\u001a\b\u0012\u0004\u0012\u0002H\\0}2\f\u0010h\u001a\b\u0012\u0004\u0012\u0002H\\0vH\u0016J.\u0010{\u001a\u00020u\"\b\b\u0000\u0010\\*\u00020\f2\f\u0010|\u001a\b\u0012\u0004\u0012\u0002H\\0}2\f\u0010h\u001a\b\u0012\u0004\u0012\u0002H\\0wH\u0016JV\u0010{\u001a\u00020u\"\b\b\u0000\u0010\\*\u00020\f2\f\u0010|\u001a\b\u0012\u0004\u0012\u0002H\\0}24\u0010h\u001a0\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\\\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0xj\b\u0012\u0004\u0012\u0002H\\`yH\u0016JJ\u0010{\u001a\u00020u\"\b\b\u0000\u0010\\*\u00020\f2\f\u0010|\u001a\b\u0012\u0004\u0012\u0002H\\0}2(\u0010h\u001a$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\\\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0dj\b\u0012\u0004\u0012\u0002H\\`zH\u0016JD\u0010~\u001a\u00020\u00012:\u0010h\u001a6\u0012\u0013\u0012\u00110C\u00a2\u0006\f\bj\u0012\b\bk\u0012\u0004\b\b(l\u0012\u0013\u0012\u00110C\u00a2\u0006\f\bj\u0012\b\bk\u0012\u0004\b\b(m\u0012\u0004\u0012\u00020e0ij\u0002`nH\u0016J0\u0010\u007f\u001a*\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020s0r0pj\b\u0012\u0004\u0012\u00020\u000b`tH\u0016J\u0016\u0010\u007f\u001a\u00020u2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020\u000b0vH\u0016J\u0016\u0010\u007f\u001a\u00020u2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020\u000b0wH\u0016J>\u0010\u007f\u001a\u00020u24\u0010h\u001a0\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0xj\b\u0012\u0004\u0012\u00020\u000b`yH\u0016J2\u0010\u007f\u001a\u00020u2(\u0010h\u001a$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0dj\b\u0012\u0004\u0012\u00020\u000b`zH\u0016J8\u0010\u007f\u001a*\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020s0r0pj\b\u0012\u0004\u0012\u00020\u000b`t2\u0006\u0010E\u001a\u00020FH\u0016J\u001e\u0010\u007f\u001a\u00020u2\u0006\u0010E\u001a\u00020F2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020\u000b0vH\u0016J\u001e\u0010\u007f\u001a\u00020u2\u0006\u0010E\u001a\u00020F2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020\u000b0wH\u0016JF\u0010\u007f\u001a\u00020u2\u0006\u0010E\u001a\u00020F24\u0010h\u001a0\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0xj\b\u0012\u0004\u0012\u00020\u000b`yH\u0016J:\u0010\u007f\u001a\u00020u2\u0006\u0010E\u001a\u00020F2(\u0010h\u001a$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0dj\b\u0012\u0004\u0012\u00020\u000b`zH\u0016J\u001a\u0010\u0080\u0001\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\fH\u0096\u0002J\u001e\u0010\u0080\u0001\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u000b2\n\u0010<\u001a\u0006\u0012\u0002\b\u00030YH\u0096\u0002J\u0012\u0010\u0081\u0001\u001a\u00020\u00012\u0007\u0010\u0082\u0001\u001a\u00020\fH\u0016J\u0012\u0010\u0083\u0001\u001a\u00020\u00012\u0007\u0010\u0083\u0001\u001a\u00020`H\u0016J\u0012\u0010\u0084\u0001\u001a\u00020\u00012\u0007\u0010\u0083\u0001\u001a\u00020`H\u0016J\t\u0010\u0085\u0001\u001a\u00020\u000bH\u0016J\u0012\u0010\u0086\u0001\u001a\u00020\u00012\u0007\u0010\u0086\u0001\u001a\u000205H\u0016J#\u0010\u0087\u0001\u001a\u00020\u00012\u0018\u0010\u0088\u0001\u001a\u0013\u0012\u0004\u0012\u00020q\u0012\u0004\u0012\u0002050dj\u0003`\u0089\u0001H\u0016R\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R$\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u0011j\u0002`\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R2\u0010\b\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n0\tj\u0002`\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\"\u0010\u0013\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\f0\u0011j\u0002`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103\u00a8\u0006\u008a\u0001"}, d2={"Lcom/github/kittinunf/fuel/core/requests/DefaultRequest;", "Lcom/github/kittinunf/fuel/core/Request;", "method", "Lcom/github/kittinunf/fuel/core/Method;", "url", "Ljava/net/URL;", "headers", "Lcom/github/kittinunf/fuel/core/Headers;", "parameters", "", "Lkotlin/Pair;", "", "", "Lcom/github/kittinunf/fuel/core/Parameters;", "_body", "Lcom/github/kittinunf/fuel/core/Body;", "enabledFeatures", "", "Lcom/github/kittinunf/fuel/core/RequestFeatures;", "tags", "Lkotlin/reflect/KClass;", "Lcom/github/kittinunf/fuel/core/Tags;", "(Lcom/github/kittinunf/fuel/core/Method;Ljava/net/URL;Lcom/github/kittinunf/fuel/core/Headers;Ljava/util/List;Lcom/github/kittinunf/fuel/core/Body;Ljava/util/Map;Ljava/util/Map;)V", "get_body$fuel", "()Lcom/github/kittinunf/fuel/core/Body;", "set_body$fuel", "(Lcom/github/kittinunf/fuel/core/Body;)V", "body", "getBody", "getEnabledFeatures", "()Ljava/util/Map;", "executionOptions", "Lcom/github/kittinunf/fuel/core/RequestExecutionOptions;", "getExecutionOptions", "()Lcom/github/kittinunf/fuel/core/RequestExecutionOptions;", "setExecutionOptions", "(Lcom/github/kittinunf/fuel/core/RequestExecutionOptions;)V", "getHeaders", "()Lcom/github/kittinunf/fuel/core/Headers;", "getMethod", "()Lcom/github/kittinunf/fuel/core/Method;", "getParameters", "()Ljava/util/List;", "setParameters", "(Ljava/util/List;)V", "request", "getRequest", "()Lcom/github/kittinunf/fuel/core/Request;", "getUrl", "()Ljava/net/URL;", "setUrl", "(Ljava/net/URL;)V", "allowRedirects", "", "appendHeader", "pairs", "", "([Lkotlin/Pair;)Lcom/github/kittinunf/fuel/core/Request;", "header", "value", "values", "(Ljava/lang/String;[Ljava/lang/Object;)Lcom/github/kittinunf/fuel/core/Request;", "openStream", "Lkotlin/Function0;", "Ljava/io/InputStream;", "Lcom/github/kittinunf/fuel/core/BodySource;", "calculateLength", "", "Lcom/github/kittinunf/fuel/core/BodyLength;", "charset", "Ljava/nio/charset/Charset;", "repeatable", "file", "Ljava/io/File;", "stream", "bytes", "", "component1", "component2", "component3", "component4", "component5", "component5$fuel", "component6", "component7", "copy", "equals", "other", "get", "", "Lcom/github/kittinunf/fuel/core/HeaderValues;", "getTag", "T", "clazz", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "hashCode", "", "map", "", "interrupt", "Lkotlin/Function1;", "", "Lcom/github/kittinunf/fuel/core/InterruptCallback;", "requestProgress", "handler", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "readBytes", "totalBytes", "Lcom/github/kittinunf/fuel/core/ProgressCallback;", "response", "Lkotlin/Triple;", "Lcom/github/kittinunf/fuel/core/Response;", "Lcom/github/kittinunf/result/Result;", "Lcom/github/kittinunf/fuel/core/FuelError;", "Lcom/github/kittinunf/fuel/core/ResponseResultOf;", "Lcom/github/kittinunf/fuel/core/requests/CancellableRequest;", "Lcom/github/kittinunf/fuel/core/Handler;", "Lcom/github/kittinunf/fuel/core/ResponseHandler;", "Lkotlin/Function3;", "Lcom/github/kittinunf/fuel/core/ResponseResultHandler;", "Lcom/github/kittinunf/fuel/core/ResultHandler;", "responseObject", "deserializer", "Lcom/github/kittinunf/fuel/core/ResponseDeserializable;", "responseProgress", "responseString", "set", "tag", "t", "timeout", "timeoutRead", "toString", "useHttpCache", "validate", "validator", "Lcom/github/kittinunf/fuel/core/ResponseValidator;", "fuel"})
public final class DefaultRequest
implements Request {
    @NotNull
    public RequestExecutionOptions executionOptions;
    @NotNull
    private final Method method;
    @NotNull
    private URL url;
    @NotNull
    private final Headers headers;
    @NotNull
    private List<? extends Pair<String, ? extends Object>> parameters;
    @NotNull
    private Body _body;
    @NotNull
    private final Map<String, Request> enabledFeatures;
    private final Map<KClass<?>, Object> tags;

    @Override
    @NotNull
    public RequestExecutionOptions getExecutionOptions() {
        RequestExecutionOptions requestExecutionOptions = this.executionOptions;
        if (requestExecutionOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executionOptions");
        }
        return requestExecutionOptions;
    }

    @Override
    public void setExecutionOptions(@NotNull RequestExecutionOptions requestExecutionOptions) {
        Intrinsics.checkNotNullParameter((Object)requestExecutionOptions, (String)"<set-?>");
        this.executionOptions = requestExecutionOptions;
    }

    @Override
    @NotNull
    public Body getBody() {
        return this._body;
    }

    @Override
    @NotNull
    public Collection<String> get(@NotNull String header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        return (Collection)this.getHeaders().get((Object)header);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Request set(@NotNull String header, @NotNull Collection<?> values) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Iterable iterable = values;
        String string = header;
        Headers headers = this.getHeaders();
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = String.valueOf(it);
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        headers.set(string, collection);
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request set(@NotNull String header, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Collection) {
            this.set(header, (Collection)value);
        } else {
            this.getHeaders().set(header, value.toString());
        }
        return this.getRequest();
    }

    @Override
    @NotNull
    public Collection<String> header(@NotNull String header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        return this.get(header);
    }

    @Override
    @NotNull
    public Request header(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.getHeaders().putAll(Headers.Companion.from(map));
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request header(Pair<String, ? extends Object> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.getHeaders().putAll(Headers.Companion.from(Arrays.copyOf(pairs, pairs.length)));
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request header(@NotNull String header, @NotNull Collection<?> values) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return this.set(header, values);
    }

    @Override
    @NotNull
    public Request header(@NotNull String header, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.set(header, value);
    }

    @Override
    @NotNull
    public Request header(@NotNull String header, Object ... values) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return this.set(header, ArraysKt.toList((Object[])values));
    }

    @Override
    @NotNull
    public Request appendHeader(@NotNull String header, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getHeaders().append(header, value);
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request appendHeader(@NotNull String header, Object ... values) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.getHeaders().append(header, ArraysKt.toList((Object[])values));
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request appendHeader(Pair<String, ? extends Object> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        Pair<String, ? extends Object>[] $this$forEach$iv = pairs;
        boolean $i$f$forEach = false;
        Pair<String, ? extends Object>[] pairArray = $this$forEach$iv;
        int n = pairArray.length;
        for (int i = 0; i < n; ++i) {
            Pair<String, ? extends Object> element$iv;
            Pair<String, ? extends Object> pair = element$iv = pairArray[i];
            boolean bl = false;
            this.appendHeader((String)pair.getFirst(), pair.getSecond());
        }
        return this.getRequest();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Request body(@NotNull Function0<? extends InputStream> openStream, @Nullable Function0<Long> calculateLength, @NotNull Charset charset, boolean repeatable) {
        void body2;
        Body body3;
        Intrinsics.checkNotNullParameter(openStream, (String)"openStream");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        DefaultBody defaultBody = DefaultBody.Companion.from(openStream, calculateLength, charset);
        boolean bl = false;
        boolean bl2 = false;
        DefaultBody defaultBody2 = defaultBody;
        DefaultRequest defaultRequest = this;
        boolean bl3 = false;
        defaultRequest._body = body3 = repeatable ? (Body)body2.asRepeatable() : (Body)body2;
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request body(@NotNull InputStream stream, @Nullable Function0<Long> calculateLength, @NotNull Charset charset, boolean repeatable) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return this.body((Function0<? extends InputStream>)((Function0)new Function0<InputStream>(stream){
            final /* synthetic */ InputStream $stream;

            @NotNull
            public final InputStream invoke() {
                return this.$stream;
            }
            {
                this.$stream = inputStream;
                super(0);
            }
        }), calculateLength, charset, repeatable);
    }

    @Override
    @NotNull
    public Request body(@NotNull byte[] bytes, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return this.body(new ByteArrayInputStream(bytes), (Function0<Long>)((Function0)new Function0<Long>(bytes){
            final /* synthetic */ byte[] $bytes;

            public final long invoke() {
                return this.$bytes.length;
            }
            {
                this.$bytes = byArray;
                super(0);
            }
        }), charset, true);
    }

    @Override
    @NotNull
    public Request body(@NotNull String body2, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Object object = body2;
        boolean bl = false;
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = this.body(byArray, charset);
        bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        CharSequence charSequence = (CharSequence)CollectionsKt.lastOrNull((Iterable)this.header("Content-Type"));
        boolean bl4 = false;
        boolean bl5 = false;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? this.header("Content-Type", (Object)("text/plain; charset=" + charset.name())) : it;
    }

    @Override
    @NotNull
    public Request body(@NotNull File file, @NotNull Charset charset) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Object object2 = charset;
        object2 = Intrinsics.areEqual((Object)object2, (Object)Charsets.UTF_8) ? Request.DefaultImpls.body$default((Request)this, (Function0)new Function0<InputStream>(file){
            final /* synthetic */ File $file;

            @NotNull
            public final InputStream invoke() {
                return new FileInputStream(this.$file);
            }
            {
                this.$file = file;
                super(0);
            }
        }, (Function0)new Function0<Long>(file){
            final /* synthetic */ File $file;

            public final long invoke() {
                return this.$file.length();
            }
            {
                this.$file = file;
                super(0);
            }
        }, charset, false, 8, null) : Request.DefaultImpls.body$default((Request)this, (Function0)new Function0<InputStream>(file){
            final /* synthetic */ File $file;

            @NotNull
            public final InputStream invoke() {
                return new FileInputStream(this.$file);
            }
            {
                this.$file = file;
                super(0);
            }
        }, null, charset, false, 8, null);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object2;
        boolean bl3 = false;
        CharSequence charSequence = (CharSequence)CollectionsKt.lastOrNull((Iterable)this.header("Content-Type"));
        boolean bl4 = false;
        boolean bl5 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            String contentType = URLConnection.guessContentTypeFromName(file.getName());
            object = this.header("Content-Type", (Object)(contentType + "; charset=" + charset.name()));
        } else {
            object = it;
        }
        return object;
    }

    @Override
    @NotNull
    public Request body(@NotNull Body body2) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        this._body = body2;
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request requestProgress(@NotNull Function2<? super Long, ? super Long, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.getExecutionOptions().getRequestProgress().plusAssign(handler);
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request responseProgress(@NotNull Function2<? super Long, ? super Long, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.getExecutionOptions().getResponseProgress().plusAssign(handler);
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request interrupt(@NotNull Function1<? super Request, Unit> interrupt) {
        Intrinsics.checkNotNullParameter(interrupt, (String)"interrupt");
        Request request2 = this.getRequest();
        boolean bl = false;
        boolean bl2 = false;
        Request it = request2;
        boolean bl3 = false;
        Collection<Function1<Request, Unit>> collection = it.getExecutionOptions().getInterruptCallbacks();
        Function1<? super Request, Unit> function1 = interrupt;
        boolean bl4 = false;
        collection.add(function1);
        return request2;
    }

    @Override
    @NotNull
    public Request timeout(int timeout) {
        Request request2 = this.getRequest();
        boolean bl = false;
        boolean bl2 = false;
        Request it = request2;
        boolean bl3 = false;
        it.getExecutionOptions().setTimeoutInMillisecond(timeout);
        return request2;
    }

    @Override
    @NotNull
    public Request timeoutRead(int timeout) {
        Request request2 = this.getRequest();
        boolean bl = false;
        boolean bl2 = false;
        Request it = request2;
        boolean bl3 = false;
        it.getExecutionOptions().setTimeoutReadInMillisecond(timeout);
        return request2;
    }

    @Override
    @NotNull
    public Request allowRedirects(boolean allowRedirects) {
        Request request2 = this.getRequest();
        boolean bl = false;
        boolean bl2 = false;
        Request it = request2;
        boolean bl3 = false;
        it.getExecutionOptions().setAllowRedirects(allowRedirects);
        return request2;
    }

    @Override
    @NotNull
    public Request useHttpCache(boolean useHttpCache) {
        Request request2 = this.getRequest();
        boolean bl = false;
        boolean bl2 = false;
        Request it = request2;
        boolean bl3 = false;
        it.getExecutionOptions().setUseHttpCache(useHttpCache);
        return request2;
    }

    @Override
    @NotNull
    public Request validate(@NotNull Function1<? super Response, Boolean> validator) {
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        Request request2 = this.getRequest();
        boolean bl = false;
        boolean bl2 = false;
        Request it = request2;
        boolean bl3 = false;
        it.getExecutionOptions().setResponseValidator(validator);
        return request2;
    }

    @Override
    @NotNull
    public Request tag(@NotNull Object t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Request request2 = this.getRequest();
        boolean bl = false;
        boolean bl2 = false;
        Request it = request2;
        boolean bl3 = false;
        this.tags.put(Reflection.getOrCreateKotlinClass(t.getClass()), t);
        return request2;
    }

    @Override
    @Nullable
    public <T> T getTag(@NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Object object = this.tags.get(clazz);
        if (!(object instanceof Object)) {
            object = null;
        }
        return (T)object;
    }

    @Override
    @NotNull
    public Request getRequest() {
        return this;
    }

    @Override
    @NotNull
    public String toString() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        StringBuilder stringBuilder2 = $this$buildString;
        String string = "--> " + (Object)((Object)this.getMethod()) + ' ' + this.getUrl();
        boolean bl6 = false;
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        stringBuilder2 = $this$buildString;
        string = "Body : " + this.getBody().asString((String)CollectionsKt.lastOrNull((Iterable)this.header("Content-Type")));
        bl6 = false;
        StringBuilder stringBuilder4 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        stringBuilder2 = $this$buildString;
        string = "Headers : (" + this.getHeaders().size() + ')';
        bl6 = false;
        StringBuilder stringBuilder5 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder5);
        Function2 appendHeaderWithValue2 = (Function2)new Function2<String, String, StringBuilder>($this$buildString){
            final /* synthetic */ StringBuilder $this_buildString;

            @NotNull
            public final StringBuilder invoke(@NotNull String key, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                StringBuilder stringBuilder = this.$this_buildString;
                String string = key + " : " + value;
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder.append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                return StringsKt.appendln((StringBuilder)stringBuilder2);
            }
            {
                this.$this_buildString = stringBuilder;
                super(2);
            }
        };
        Headers.transformIterate$default(this.getHeaders(), appendHeaderWithValue2, null, 2, null);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Override
    @NotNull
    public CancellableRequest response(@NotNull Function3<? super Request, ? super Response, ? super Result<byte[], ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return DeserializableKt.response((Request)this, (Deserializable)new ByteArrayDeserializer(), handler);
    }

    @Override
    @NotNull
    public CancellableRequest response(@NotNull Function1<? super Result<byte[], ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return DeserializableKt.response((Request)this, (Deserializable)new ByteArrayDeserializer(), handler);
    }

    @Override
    @NotNull
    public CancellableRequest response(@NotNull ResponseHandler<? super byte[]> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return DeserializableKt.response((Request)this, (Deserializable)new ByteArrayDeserializer(), handler);
    }

    @Override
    @NotNull
    public CancellableRequest response(@NotNull Handler<? super byte[]> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return DeserializableKt.response((Request)this, (Deserializable)new ByteArrayDeserializer(), handler);
    }

    @Override
    @NotNull
    public Triple<Request, Response, Result<byte[], FuelError>> response() {
        return DeserializableKt.response(this, (Deserializable)new ByteArrayDeserializer());
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull Charset charset, @NotNull Function3<? super Request, ? super Response, ? super Result<String, ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return DeserializableKt.response((Request)this, (Deserializable)new StringDeserializer(charset), handler);
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull Function3<? super Request, ? super Response, ? super Result<String, ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return this.responseString(Charsets.UTF_8, handler);
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull Charset charset, @NotNull Function1<? super Result<String, ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return DeserializableKt.response((Request)this, (Deserializable)new StringDeserializer(charset), handler);
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull Function1<? super Result<String, ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return this.responseString(Charsets.UTF_8, handler);
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull Charset charset, @NotNull ResponseHandler<? super String> handler) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return DeserializableKt.response((Request)this, (Deserializable)new StringDeserializer(charset), handler);
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull ResponseHandler<? super String> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return DeserializableKt.response((Request)this, (Deserializable)new StringDeserializer(null, 1, null), handler);
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull Charset charset, @NotNull Handler<? super String> handler) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return DeserializableKt.response((Request)this, (Deserializable)new StringDeserializer(charset), handler);
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull Handler<? super String> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return DeserializableKt.response((Request)this, (Deserializable)new StringDeserializer(null, 1, null), handler);
    }

    @Override
    @NotNull
    public Triple<Request, Response, Result<String, FuelError>> responseString(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return DeserializableKt.response(this, (Deserializable)new StringDeserializer(charset));
    }

    @Override
    @NotNull
    public Triple<Request, Response, Result<String, FuelError>> responseString() {
        return DeserializableKt.response(this, (Deserializable)new StringDeserializer(Charsets.UTF_8));
    }

    @Override
    @NotNull
    public <T> CancellableRequest responseObject(@NotNull ResponseDeserializable<? extends T> deserializer, @NotNull Function3<? super Request, ? super Response, ? super Result<? extends T, ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return DeserializableKt.response((Request)this, (Deserializable)deserializer, handler);
    }

    @Override
    @NotNull
    public <T> CancellableRequest responseObject(@NotNull ResponseDeserializable<? extends T> deserializer, @NotNull Function1<? super Result<? extends T, ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return DeserializableKt.response((Request)this, (Deserializable)deserializer, handler);
    }

    @Override
    @NotNull
    public <T> CancellableRequest responseObject(@NotNull ResponseDeserializable<? extends T> deserializer, @NotNull ResponseHandler<? super T> handler) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return DeserializableKt.response((Request)this, (Deserializable)deserializer, handler);
    }

    @Override
    @NotNull
    public <T> CancellableRequest responseObject(@NotNull ResponseDeserializable<? extends T> deserializer, @NotNull Handler<? super T> handler) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return DeserializableKt.response((Request)this, (Deserializable)deserializer, handler);
    }

    @Override
    @NotNull
    public <T> Triple<Request, Response, Result<T, FuelError>> responseObject(@NotNull ResponseDeserializable<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        return DeserializableKt.response(this, (Deserializable)deserializer);
    }

    @Override
    @NotNull
    public Method getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(@NotNull URL uRL) {
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"<set-?>");
        this.url = uRL;
    }

    @Override
    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    @NotNull
    public List<Pair<String, Object>> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(@NotNull List<? extends Pair<String, ? extends Object>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.parameters = list;
    }

    @NotNull
    public final Body get_body$fuel() {
        return this._body;
    }

    public final void set_body$fuel(@NotNull Body body2) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"<set-?>");
        this._body = body2;
    }

    @Override
    @NotNull
    public Map<String, Request> getEnabledFeatures() {
        return this.enabledFeatures;
    }

    public DefaultRequest(@NotNull Method method, @NotNull URL url, @NotNull Headers headers, @NotNull List<? extends Pair<String, ? extends Object>> parameters, @NotNull Body _body, @NotNull Map<String, Request> enabledFeatures, @NotNull Map<KClass<?>, Object> tags) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)_body, (String)"_body");
        Intrinsics.checkNotNullParameter(enabledFeatures, (String)"enabledFeatures");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.parameters = parameters;
        this._body = _body;
        this.enabledFeatures = enabledFeatures;
        this.tags = tags;
    }

    public /* synthetic */ DefaultRequest(Method method, URL uRL, Headers headers, List list, Body body2, Map map, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl;
        if ((n & 4) != 0) {
            headers = new Headers();
        }
        if ((n & 8) != 0) {
            bl = false;
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            body2 = new DefaultBody(null, null, null, 7, null);
        }
        if ((n & 0x20) != 0) {
            bl = false;
            map = new LinkedHashMap();
        }
        if ((n & 0x40) != 0) {
            bl = false;
            map2 = new LinkedHashMap();
        }
        this(method, uRL, headers, list, body2, map, map2);
    }

    @NotNull
    public final Method component1() {
        return this.getMethod();
    }

    @NotNull
    public final URL component2() {
        return this.getUrl();
    }

    @NotNull
    public final Headers component3() {
        return this.getHeaders();
    }

    @NotNull
    public final List<Pair<String, Object>> component4() {
        return this.getParameters();
    }

    @NotNull
    public final Body component5$fuel() {
        return this._body;
    }

    @NotNull
    public final Map<String, Request> component6() {
        return this.getEnabledFeatures();
    }

    private final Map<KClass<?>, Object> component7() {
        return this.tags;
    }

    @NotNull
    public final DefaultRequest copy(@NotNull Method method, @NotNull URL url, @NotNull Headers headers, @NotNull List<? extends Pair<String, ? extends Object>> parameters, @NotNull Body _body, @NotNull Map<String, Request> enabledFeatures, @NotNull Map<KClass<?>, Object> tags) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)_body, (String)"_body");
        Intrinsics.checkNotNullParameter(enabledFeatures, (String)"enabledFeatures");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        return new DefaultRequest(method, url, headers, parameters, _body, enabledFeatures, tags);
    }

    public static /* synthetic */ DefaultRequest copy$default(DefaultRequest defaultRequest, Method method, URL uRL, Headers headers, List list, Body body2, Map map, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            method = defaultRequest.getMethod();
        }
        if ((n & 2) != 0) {
            uRL = defaultRequest.getUrl();
        }
        if ((n & 4) != 0) {
            headers = defaultRequest.getHeaders();
        }
        if ((n & 8) != 0) {
            list = defaultRequest.getParameters();
        }
        if ((n & 0x10) != 0) {
            body2 = defaultRequest._body;
        }
        if ((n & 0x20) != 0) {
            map = defaultRequest.getEnabledFeatures();
        }
        if ((n & 0x40) != 0) {
            map2 = defaultRequest.tags;
        }
        return defaultRequest.copy(method, uRL, headers, list, body2, map, map2);
    }

    public int hashCode() {
        Method method = this.getMethod();
        URL uRL = this.getUrl();
        Headers headers = this.getHeaders();
        List<Pair<String, Object>> list = this.getParameters();
        Body body2 = this._body;
        Map<String, Request> map = this.getEnabledFeatures();
        Map<KClass<?>, Object> map2 = this.tags;
        return ((((((method != null ? ((Object)((Object)method)).hashCode() : 0) * 31 + (uRL != null ? ((Object)uRL).hashCode() : 0)) * 31 + (headers != null ? headers.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (body2 != null ? body2.hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DefaultRequest)) break block3;
                DefaultRequest defaultRequest = (DefaultRequest)object;
                if (!Intrinsics.areEqual((Object)((Object)this.getMethod()), (Object)((Object)defaultRequest.getMethod())) || !Intrinsics.areEqual((Object)this.getUrl(), (Object)defaultRequest.getUrl()) || !Intrinsics.areEqual((Object)this.getHeaders(), (Object)defaultRequest.getHeaders()) || !Intrinsics.areEqual(this.getParameters(), defaultRequest.getParameters()) || !Intrinsics.areEqual((Object)this._body, (Object)defaultRequest._body) || !Intrinsics.areEqual(this.getEnabledFeatures(), defaultRequest.getEnabledFeatures()) || !Intrinsics.areEqual(this.tags, defaultRequest.tags)) break block3;
            }
            return true;
        }
        return false;
    }
}

