/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.ssl;

import io.conduktor.ssl.AbstractConduktorSslEngineFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.net.ssl.SSLContext;
import net.harawata.appdirs.AppDirsFactory;
import nl.altindag.ssl.SSLFactory;
import org.apache.kafka.common.KafkaException;

public class ConduktorDefaultSslEngineFactory
extends AbstractConduktorSslEngineFactory {
    @Override
    protected SSLContext createSSLContext(AbstractConduktorSslEngineFactory.SecurityStore keystore, AbstractConduktorSslEngineFactory.SecurityStore truststore) {
        try {
            Path localCACert;
            SSLFactory.Builder builder = SSLFactory.builder();
            builder.withDefaultTrustMaterial();
            builder.withSystemTrustMaterial();
            if (truststore != null) {
                builder.withTrustMaterial(truststore.get());
            }
            if (keystore != null) {
                builder.withIdentityMaterial(keystore.get(), keystore.keyPassword());
            }
            if (Files.exists(localCACert = Paths.get(AppDirsFactory.getInstance().getUserConfigDir("conduktor", "cacerts", "conduktor"), new String[0]), new LinkOption[0])) {
                builder.withTrustMaterial(localCACert, "changeit".toCharArray());
            }
            return builder.build().getSslContext();
        }
        catch (Exception e) {
            throw new KafkaException((Throwable)e);
        }
    }
}

