/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.OptionalLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface ToLongFunctionWithThrowable<T, E extends Throwable>
extends ToLongFunction<T> {
    public static <T, E extends Throwable> ToLongFunctionWithThrowable<T, E> castToLongFunctionWithThrowable(ToLongFunctionWithThrowable<T, E> tolongfunctionwiththrowable) {
        return tolongfunctionwiththrowable;
    }

    public static <T, E extends Throwable> ToLongFunction<T> aToLongFunctionThatUnsafelyThrowsUnchecked(ToLongFunctionWithThrowable<T, E> tolongfunctionwiththrowable) throws E {
        return tolongfunctionwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, E extends Throwable> ToLongFunctionWithThrowable<T, E> asToLongFunctionWithThrowable(ToLongFunction<T> tolongfunction) {
        return tolongfunction::applyAsLong;
    }

    @Override
    default public long applyAsLong(T v1) {
        try {
            return this.applyAsLongWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public long applyAsLongWithThrowable(T var1) throws E;

    default public Function<T, OptionalLong> thatReturnsOptional() {
        return v1 -> {
            try {
                return OptionalLong.of(this.applyAsLongWithThrowable(v1));
            }
            catch (Throwable throwable) {
                return OptionalLong.empty();
            }
        };
    }

    default public ToLongFunction<T> thatReturnsOnCatch(long defaultReturnValue) {
        return v1 -> {
            try {
                return this.applyAsLongWithThrowable(v1);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public ToLongFunction<T> thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                return this.applyAsLongWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return 0L;
            }
        };
    }

    default public ToLongFunctionWithThrowable<T, E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                return this.applyAsLongWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public ToLongFunctionWithThrowable<T, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in ToLongFunctionWithThrowable with the argument [{}]");
    }

    default public ToLongFunctionWithThrowable<T, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public ToLongFunctionWithThrowable<T, E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                return this.applyAsLongWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public ToLongFunctionWithThrowable<T, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                return this.applyAsLongWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

