/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface LongSupplierWithThrowable<E extends Throwable>
extends LongSupplier {
    public static <E extends Throwable> LongSupplierWithThrowable<E> castLongSupplierWithThrowable(LongSupplierWithThrowable<E> longsupplierwiththrowable) {
        return longsupplierwiththrowable;
    }

    public static <E extends Throwable> LongSupplier aLongSupplierThatUnsafelyThrowsUnchecked(LongSupplierWithThrowable<E> longsupplierwiththrowable) throws E {
        return longsupplierwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <E extends Throwable> LongSupplierWithThrowable<E> asLongSupplierWithThrowable(LongSupplier longsupplier) {
        return longsupplier::getAsLong;
    }

    @Override
    default public long getAsLong() {
        try {
            return this.getAsLongWithThrowable();
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public long getAsLongWithThrowable() throws E;

    default public LongSupplier thatReturnsOnCatch(long defaultReturnValue) {
        return () -> {
            try {
                return this.getAsLongWithThrowable();
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public LongSupplier thatUnsafelyThrowsUnchecked() throws E {
        return () -> {
            try {
                return this.getAsLongWithThrowable();
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return 0L;
            }
        };
    }

    default public LongSupplierWithThrowable<E> withLogging(Logger logger, String message) {
        return () -> {
            try {
                return this.getAsLongWithThrowable();
            }
            catch (Throwable throwable) {
                logger.error(message, throwable);
                throw throwable;
            }
        };
    }

    default public LongSupplierWithThrowable<E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in LongSupplierWithThrowable");
    }

    default public LongSupplierWithThrowable<E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public LongSupplierWithThrowable<E> onException(Consumer<Throwable> consumer) {
        return () -> {
            try {
                return this.getAsLongWithThrowable();
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }
}

