/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface FunctionWithThrowable<T, R, E extends Throwable>
extends Function<T, R> {
    public static <T, R, E extends Throwable> FunctionWithThrowable<T, R, E> castFunctionWithThrowable(FunctionWithThrowable<T, R, E> functionwiththrowable) {
        return functionwiththrowable;
    }

    public static <T, R, E extends Throwable> Function<T, R> aFunctionThatUnsafelyThrowsUnchecked(FunctionWithThrowable<T, R, E> functionwiththrowable) throws E {
        return functionwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, R, E extends Throwable> FunctionWithThrowable<T, R, E> asFunctionWithThrowable(Function<T, R> function) {
        return function::apply;
    }

    @Override
    default public R apply(T v1) {
        try {
            return this.applyWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public R applyWithThrowable(T var1) throws E;

    default public Function<T, Optional<R>> thatReturnsOptional() {
        return v1 -> {
            try {
                return Optional.ofNullable(this.applyWithThrowable(v1));
            }
            catch (Throwable throwable) {
                return Optional.empty();
            }
        };
    }

    default public Function<T, R> thatReturnsOnCatch(R defaultReturnValue) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public Function<T, R> thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return null;
            }
        };
    }

    default public FunctionWithThrowable<T, R, E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public FunctionWithThrowable<T, R, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in FunctionWithThrowable with the argument [{}]");
    }

    default public FunctionWithThrowable<T, R, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public FunctionWithThrowable<T, R, E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public FunctionWithThrowable<T, R, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

