/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface ConsumerWithThrowable<T, E extends Throwable>
extends Consumer<T> {
    public static <T, E extends Throwable> ConsumerWithThrowable<T, E> castConsumerWithThrowable(ConsumerWithThrowable<T, E> consumerwiththrowable) {
        return consumerwiththrowable;
    }

    public static <T, E extends Throwable> Consumer<T> aConsumerThatUnsafelyThrowsUnchecked(ConsumerWithThrowable<T, E> consumerwiththrowable) throws E {
        return consumerwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, E extends Throwable> ConsumerWithThrowable<T, E> asConsumerWithThrowable(Consumer<T> consumer) {
        return consumer::accept;
    }

    @Override
    default public void accept(T v1) {
        try {
            this.acceptWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public void acceptWithThrowable(T var1) throws E;

    default public Consumer<T> thatThrowsNothing() {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
    }

    default public Consumer<T> thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
            }
        };
    }

    default public ConsumerWithThrowable<T, E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public ConsumerWithThrowable<T, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in ConsumerWithThrowable with the argument [{}]");
    }

    default public ConsumerWithThrowable<T, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public ConsumerWithThrowable<T, E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public ConsumerWithThrowable<T, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

