/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface BiConsumerWithThrowable<T, U, E extends Throwable>
extends BiConsumer<T, U> {
    public static <T, U, E extends Throwable> BiConsumerWithThrowable<T, U, E> castBiConsumerWithThrowable(BiConsumerWithThrowable<T, U, E> biconsumerwiththrowable) {
        return biconsumerwiththrowable;
    }

    public static <T, U, E extends Throwable> BiConsumer<T, U> aBiConsumerThatUnsafelyThrowsUnchecked(BiConsumerWithThrowable<T, U, E> biconsumerwiththrowable) throws E {
        return biconsumerwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, U, E extends Throwable> BiConsumerWithThrowable<T, U, E> asBiConsumerWithThrowable(BiConsumer<T, U> biconsumer) {
        return biconsumer::accept;
    }

    @Override
    default public void accept(T v1, U v2) {
        try {
            this.acceptWithThrowable(v1, v2);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public void acceptWithThrowable(T var1, U var2) throws E;

    default public BiConsumer<T, U> thatThrowsNothing() {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
    }

    default public BiConsumer<T, U> thatUnsafelyThrowsUnchecked() throws E {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
            }
        };
    }

    default public BiConsumerWithThrowable<T, U, E> withLogging(Logger logger, String message) {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                logger.error(message, new Object[]{v1, v2, throwable});
                throw throwable;
            }
        };
    }

    default public BiConsumerWithThrowable<T, U, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in BiConsumerWithThrowable with the arguments [{}, {}]");
    }

    default public BiConsumerWithThrowable<T, U, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public BiConsumerWithThrowable<T, U, E> onException(Consumer<Throwable> consumer) {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public BiConsumerWithThrowable<T, U, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1, v2});
                throw throwable;
            }
        };
    }
}

