/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\u0011EvAB7o\u0011\u0003\u0001(O\u0002\u0004u]\"\u0005\u0001/\u001e\u0005\u0006y\u0006!\tA \u0005\t\u007f\u0006\u0011\r\u0011\"\u0001\u0002\u0002!A\u00111C\u0001!\u0002\u0013\t\u0019\u0001C\u0005\u0002\u0016\u0005\u0011\r\u0011\"\u0001\u0002\u0002!A\u0011qC\u0001!\u0002\u0013\t\u0019\u0001C\u0005\u0002\u001a\u0005\u0011\r\u0011\"\u0001\u0002\u0002!A\u00111D\u0001!\u0002\u0013\t\u0019\u0001C\u0005\u0002\u001e\u0005\u0011\r\u0011\"\u0001\u0002 !A\u0011qE\u0001!\u0002\u0013\t\tC\u0002\u0004u]\u0002\u0001\u0018\u0011\u0006\u0005\u000b\u0003{Y!Q1A\u0005\u0002\u0005}\u0001BCA \u0017\t\u0005\t\u0015!\u0003\u0002\"!Q\u0011\u0011I\u0006\u0003\u0002\u0003\u0006I!a\u0011\t\u0015\u0005u3B!A!\u0002\u0013\t\t\u0003\u0003\u0006\u0002`-\u0011\t\u0011)A\u0005\u0003CB!\"a\u001a\f\u0005\u0003\u0005\u000b\u0011BA5\u0011)\tyg\u0003B\u0001B\u0003%\u0011\u0011\u000f\u0005\u000b\u0003oZ!\u0011!Q\u0001\n\u0005\u0005\u0002BCA=\u0017\t\u0005\t\u0015!\u0003\u0002|!Q\u0011QQ\u0006\u0003\u0002\u0003\u0006I!a\"\t\u0015\u0005]5B!A!\u0002\u0013\tI\n\u0003\u0006\u00028-\u0011\t\u0011)A\u0005\u0003KC!\"a,\f\u0005\u0003\u0005\u000b\u0011BAY\u0011)\tYl\u0003B\u0001B\u0003%\u0011Q\u0018\u0005\u000b\u0003\u0013\\!\u0011!Q\u0001\n\u0005-\u0007BCAi\u0017\t\u0005\t\u0015!\u0003\u0002\"!Q\u00111[\u0006\u0003\u0002\u0003\u0006I!!6\t\u0015\u0005m7B!A!\u0002\u0013\ti\u000e\u0003\u0004}\u0017\u0011\u0005\u00111]\u0004\b\u0005\u0013Y\u0001\u0012\u0002B\u0006\r\u001d\u0011ya\u0003E\u0005\u0005#Aa\u0001 \u0011\u0005\u0002\t}\u0001b\u0002B\u0011A\u0011\u0005!1\u0005\u0005\n\u0005[\u0004\u0013\u0011!CA\u0005_D\u0011Ba?!\u0003\u0003%\tI!@\u0007\u000f\t=1\u0002\u00118\u0003.!Q!1J\u0013\u0003\u0016\u0004%\tA!\u0014\t\u0015\tuSE!E!\u0002\u0013\u0011y\u0005\u0003\u0006\u0003`\u0015\u0012)\u001a!C\u0001\u0003?A!B!\u0019&\u0005#\u0005\u000b\u0011BA\u0011\u0011)\u0011\u0019'\nBK\u0002\u0013\u0005!Q\n\u0005\u000b\u0005K*#\u0011#Q\u0001\n\t=\u0003B\u0003B4K\tU\r\u0011\"\u0001\u0002 !Q!\u0011N\u0013\u0003\u0012\u0003\u0006I!!\t\t\u0015\t-TE!f\u0001\n\u0003\ty\u0002\u0003\u0006\u0003n\u0015\u0012\t\u0012)A\u0005\u0003CAa\u0001`\u0013\u0005\u0002\t=\u0004b\u0002B>K\u0011\u0005#Q\u0010\u0005\n\u0005\u007f*\u0013\u0011!C\u0001\u0005\u0003C\u0011B!$&#\u0003%\tAa$\t\u0013\t\u0015V%%A\u0005\u0002\t\u001d\u0006\"\u0003BVKE\u0005I\u0011\u0001BH\u0011%\u0011i+JI\u0001\n\u0003\u00119\u000bC\u0005\u00030\u0016\n\n\u0011\"\u0001\u0003(\"I!\u0011W\u0013\u0002\u0002\u0013\u0005\u0013\u0011\u0001\u0005\n\u0005g+\u0013\u0011!C\u0001\u0003?A\u0011B!.&\u0003\u0003%\tAa.\t\u0013\t\rW%!A\u0005B\t\u0015\u0007\"\u0003BjK\u0005\u0005I\u0011\u0001Bk\u0011%\u0011I.JA\u0001\n\u0003\u0012Y\u000eC\u0005\u0003`\u0016\n\t\u0011\"\u0011\u0003b\"I!1]\u0013\u0002\u0002\u0013\u0005#Q\u001d\u0005\n\u0007\u0017Y!\u0019!C\u0005\u0007\u001bA\u0001ba\f\fA\u0003%1q\u0002\u0005\n\u0007cY!\u0019!C\u0005\u0007gA\u0001ba\u0014\fA\u0003%1Q\u0007\u0005\n\u0007#Z!\u0019!C\u0005\u0007'B\u0001ba\u0017\fA\u0003%1Q\u000b\u0005\u000b\u0007;Z!\u0019!C\u0001a\u000e}\u0003\u0002CB4\u0017\u0001\u0006Ia!\u0019\t\u0013\r%4B1A\u0005\u0002\r-\u0004\u0002CB=\u0017\u0001\u0006Ia!\u001c\t\u0013\rm4B1A\u0005\n\ru\u0004\u0002CBD\u0017\u0001\u0006Iaa \t\u0015\r%5B1A\u0005\u00029\u001cY\t\u0003\u0005\u0004\u0014.\u0001\u000b\u0011BBG\u0011!\u0019)j\u0003C\t]\u000e]\u0005\"CBR\u0017\u0001\u0007I\u0011BA\u0010\u0011%\u0019)k\u0003a\u0001\n\u0013\u00199\u000b\u0003\u0005\u00042.\u0001\u000b\u0015BA\u0011\u0011\u001d\u0019\u0019l\u0003C!\u0007kC\u0001ba.\f\t\u0003q7\u0011\u0018\u0005\b\u0007\u0013\\A\u0011BBf\u0011\u001d\u0019)n\u0003C\u0005\u0007kC\u0001ba6\f\t#q7\u0011\u001c\u0005\b\u0007S\\A\u0011BB[\u0011\u001d\u0019Yo\u0003C\t\u0007[Dq\u0001b\u0002\f\t\u0013\u0019)\fC\u0004\u0005\n-!Ia!.\t\u000f\u0011-1\u0002\"\u0003\u0005\u000e!9A\u0011C\u0006\u0005\n\rU\u0006b\u0002C\n\u0017\u0011%1Q\u0017\u0005\b\t+YA\u0011\u0002C\f\u0011\u001d!ib\u0003C\u0001\t?Aq\u0001b\u0011\f\t\u0013\u0019)\fC\u0004\u0005F-!Ia!.\t\u0011\u0011m1\u0002\"\u0005o\t\u000fB\u0001\u0002\"\u0017\f\t\u0003qG1\f\u0005\b\t?ZA\u0011\u0002C1\u0011!!\u0019g\u0003C\u0001]\u0006}\u0001\u0002\u0003C3\u0017\u0011\u0005a.a\b\t\u0011\u0011\u001d4\u0002\"\u0001o\tSBq\u0001\"\u001e\f\t\u0013!9\bC\u0004\u0005\".!I\u0001b)\t\u0011\u0011\u001d6\u0002\"\u0001o\tSCq\u0001\",\f\t\u0003\u001a)\fC\u0004\u00050.!\te!.\u0002\u0013A\u0013xnY3tg>\u0014(BA8q\u0003\u001dqW\r^<pe.T\u0011!]\u0001\u0006W\u000647.\u0019\t\u0003g\u0006i\u0011A\u001c\u0002\n!J|7-Z:t_J\u001c\"!\u0001<\u0011\u0005]TX\"\u0001=\u000b\u0003e\fQa]2bY\u0006L!a\u001f=\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001:\u0002+%#G.\u001a)fe\u000e,g\u000e^'fiJL7MT1nKV\u0011\u00111\u0001\t\u0005\u0003\u000b\ty!\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0011\u0001\u00026bm\u0006LA!!\u0005\u0002\b\t11\u000b\u001e:j]\u001e\fa#\u00133mKB+'oY3oi6+GO]5d\u001d\u0006lW\rI\u0001\u001a\u001d\u0016$xo\u001c:l!J|7-Z:t_JlU\r\u001e:jGR\u000bw-\u0001\u000eOKR<xN]6Qe>\u001cWm]:pe6+GO]5d)\u0006<\u0007%A\tMSN$XM\\3s\u001b\u0016$(/[2UC\u001e\f!\u0003T5ti\u0016tWM]'fiJL7\rV1hA\u0005\u00192i\u001c8oK\u000e$\u0018n\u001c8Rk\u0016,XmU5{KV\u0011\u0011\u0011\u0005\t\u0004o\u0006\r\u0012bAA\u0013q\n\u0019\u0011J\u001c;\u0002)\r{gN\\3di&|g.U;fk\u0016\u001c\u0016N_3!'\u0015Y\u00111FA\u0019!\r\u0019\u0018QF\u0005\u0004\u0003_q'\u0001F!cgR\u0014\u0018m\u0019;TKJ4XM\u001d+ie\u0016\fG\r\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9\u0004]\u0001\b[\u0016$(/[2t\u0013\u0011\tY$!\u000e\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/\u0001\u0002jI\u0006\u0019\u0011\u000e\u001a\u0011\u0002\tQLW.\u001a\t\u0005\u0003\u000b\nI&\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\u0015)H/\u001b7t\u0015\u0011\ti%a\u0014\u0002\r\r|W.\\8o\u0015\r\t\u0018\u0011\u000b\u0006\u0005\u0003'\n)&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003/\n1a\u001c:h\u0013\u0011\tY&a\u0012\u0003\tQKW.Z\u0001\u000f[\u0006D(+Z9vKN$8+\u001b>f\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2\u00042a]A2\u0013\r\t)G\u001c\u0002\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0003A\u0019wN\u001c8fGRLwN\\)v_R\f7\u000fE\u0002t\u0003WJ1!!\u001co\u0005A\u0019uN\u001c8fGRLwN\\)v_R\f7/\u0001\u000bd_:tWm\u0019;j_:\u001cX*\u0019=JI2,Wj\u001d\t\u0004o\u0006M\u0014bAA;q\n!Aj\u001c8h\u0003m1\u0017-\u001b7fI\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u0012+G.Y=Ng\u0006aA.[:uK:,'OT1nKB!\u0011QPAA\u001b\t\tyHC\u0002p\u0003\u0017JA!a!\u0002\u0000\taA*[:uK:,'OT1nK\u0006\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\t\u0005\u0003\u0013\u000b\u0019*\u0004\u0002\u0002\f*!\u0011QRAH\u0003\u0011\tW\u000f\u001e5\u000b\t\u0005E\u00151J\u0001\tg\u0016\u001cWO]5us&!\u0011QSAF\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.\u0001\u0004d_:4\u0017n\u001a\t\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*\u0019\u0011q\u00149\u0002\rM,'O^3s\u0013\u0011\t\u0019+!(\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\t\u0005\u0003O\u000bY+\u0004\u0002\u0002**!\u0011qGA&\u0013\u0011\ti+!+\u0003\u000f5+GO]5dg\u0006\u00112M]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s!\u0011\t\u0019,a.\u000e\u0005\u0005U&bAAIa&!\u0011\u0011XA[\u0005I\u0019%/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\u0002\u00155,Wn\u001c:z!>|G\u000e\u0005\u0003\u0002@\u0006\u0015WBAAa\u0015\u0011\t\u0019-a\u0013\u0002\r5,Wn\u001c:z\u0013\u0011\t9-!1\u0003\u00155+Wn\u001c:z!>|G.\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u0004B!!\u0012\u0002N&!\u0011qZA$\u0005)aunZ\"p]R,\u0007\u0010^\u0001\u0014G>tg.Z2uS>t\u0017+^3vKNK'0Z\u0001\u0015SN\u0004&/\u001b<jY\u0016<W\r\u001a'jgR,g.\u001a:\u0011\u0007]\f9.C\u0002\u0002Zb\u0014qAQ8pY\u0016\fg.A\tba&4VM]:j_:l\u0015M\\1hKJ\u0004B!a'\u0002`&!\u0011\u0011]AO\u0005E\t\u0005/\u001b,feNLwN\\'b]\u0006<WM\u001d\u000b%\u0003K\f9/!;\u0002l\u00065\u0018q^Ay\u0003g\f)0a>\u0002z\u0006m\u0018Q`A\u0000\u0005\u0003\u0011\u0019A!\u0002\u0003\bA\u00111o\u0003\u0005\b\u0003{q\u0002\u0019AA\u0011\u0011\u001d\t\tE\ba\u0001\u0003\u0007Bq!!\u0018\u001f\u0001\u0004\t\t\u0003C\u0004\u0002`y\u0001\r!!\u0019\t\u000f\u0005\u001dd\u00041\u0001\u0002j!9\u0011q\u000e\u0010A\u0002\u0005E\u0004bBA<=\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003sr\u0002\u0019AA>\u0011\u001d\t)I\ba\u0001\u0003\u000fCq!a&\u001f\u0001\u0004\tI\nC\u0004\u00028y\u0001\r!!*\t\u000f\u0005=f\u00041\u0001\u00022\"9\u00111\u0018\u0010A\u0002\u0005u\u0006bBAe=\u0001\u0007\u00111\u001a\u0005\b\u0003#t\u0002\u0019AA\u0011\u0011\u001d\t\u0019N\ba\u0001\u0003+Dq!a7\u001f\u0001\u0004\ti.\u0001\u0007D_:tWm\u0019;j_:LE\rE\u0002\u0003\u000e\u0001j\u0011a\u0003\u0002\r\u0007>tg.Z2uS>t\u0017\nZ\n\u0005AY\u0014\u0019\u0002\u0005\u0003\u0003\u0016\tmQB\u0001B\f\u0015\u0011\u0011I\"a\u0003\u0002\u0005%|\u0017\u0002\u0002B\u000f\u0005/\u0011AbU3sS\u0006d\u0017N_1cY\u0016$\"Aa\u0003\u0002\u0015\u0019\u0014x.\\*ue&tw\r\u0006\u0003\u0003&\t%\b#B<\u0003(\t-\u0012b\u0001B\u0015q\n1q\n\u001d;j_:\u00042A!\u0004&'\u0019)cOa\f\u00036A\u0019qO!\r\n\u0007\tM\u0002PA\u0004Qe>$Wo\u0019;\u0011\t\t]\"q\t\b\u0005\u0005s\u0011\u0019E\u0004\u0003\u0003<\t\u0005SB\u0001B\u001f\u0015\r\u0011y$`\u0001\u0007yI|w\u000e\u001e \n\u0003eL1A!\u0012y\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\b\u0003J)\u0019!Q\t=\u0002\u00131|7-\u00197I_N$XC\u0001B(!\u0011\u0011\tF!\u0017\u000f\t\tM#Q\u000b\t\u0004\u0005wA\u0018b\u0001B,q\u00061\u0001K]3eK\u001aLA!!\u0005\u0003\\)\u0019!q\u000b=\u0002\u00151|7-\u00197I_N$\b%A\u0005m_\u000e\fG\u000eU8si\u0006QAn\\2bYB{'\u000f\u001e\u0011\u0002\u0015I,Wn\u001c;f\u0011>\u001cH/A\u0006sK6|G/\u001a%pgR\u0004\u0013A\u0003:f[>$X\rU8si\u0006Y!/Z7pi\u0016\u0004vN\u001d;!\u0003\u0015Ig\u000eZ3y\u0003\u0019Ig\u000eZ3yAQa!1\u0006B9\u0005g\u0012)Ha\u001e\u0003z!9!1\n\u0019A\u0002\t=\u0003b\u0002B0a\u0001\u0007\u0011\u0011\u0005\u0005\b\u0005G\u0002\u0004\u0019\u0001B(\u0011\u001d\u00119\u0007\ra\u0001\u0003CAqAa\u001b1\u0001\u0004\t\t#\u0001\u0005u_N#(/\u001b8h)\t\u0011y%\u0001\u0003d_BLH\u0003\u0004B\u0016\u0005\u0007\u0013)Ia\"\u0003\n\n-\u0005\"\u0003B&eA\u0005\t\u0019\u0001B(\u0011%\u0011yF\rI\u0001\u0002\u0004\t\t\u0003C\u0005\u0003dI\u0002\n\u00111\u0001\u0003P!I!q\r\u001a\u0011\u0002\u0003\u0007\u0011\u0011\u0005\u0005\n\u0005W\u0012\u0004\u0013!a\u0001\u0003C\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0012*\"!q\nBJW\t\u0011)\n\u0005\u0003\u0003\u0018\n\u0005VB\u0001BM\u0015\u0011\u0011YJ!(\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BPq\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r&\u0011\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005SSC!!\t\u0003\u0014\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B]\u0005\u007f\u00032a\u001eB^\u0013\r\u0011i\f\u001f\u0002\u0004\u0003:L\b\"\u0003Bau\u0005\u0005\t\u0019AA\u0011\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0019\t\u0007\u0005\u0013\u0014yM!/\u000e\u0005\t-'b\u0001Bgq\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tE'1\u001a\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002V\n]\u0007\"\u0003Bay\u0005\u0005\t\u0019\u0001B]\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\r!Q\u001c\u0005\n\u0005\u0003l\u0014\u0011!a\u0001\u0003C\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003C\ta!Z9vC2\u001cH\u0003BAk\u0005OD\u0011B!1@\u0003\u0003\u0005\rA!/\t\u000f\t-(\u00051\u0001\u0003P\u0005\t1/A\u0003baBd\u0017\u0010\u0006\u0007\u0003,\tE(1\u001fB{\u0005o\u0014I\u0010C\u0004\u0003L\r\u0002\rAa\u0014\t\u000f\t}3\u00051\u0001\u0002\"!9!1M\u0012A\u0002\t=\u0003b\u0002B4G\u0001\u0007\u0011\u0011\u0005\u0005\b\u0005W\u001a\u0003\u0019AA\u0011\u0003\u001d)h.\u00199qYf$BAa@\u0004\bA)qOa\n\u0004\u0002Aiqoa\u0001\u0003P\u0005\u0005\"qJA\u0011\u0003CI1a!\u0002y\u0005\u0019!V\u000f\u001d7fk!I1\u0011\u0002\u0013\u0002\u0002\u0003\u0007!1F\u0001\u0004q\u0012\u0002\u0014A\u00048fo\u000e{gN\\3di&|gn]\u000b\u0003\u0007\u001f\u0001ba!\u0005\u0004\u001c\r}QBAB\n\u0015\u0011\u0019)ba\u0006\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0004\u001a\u0005-\u0011\u0001B;uS2LAa!\b\u0004\u0014\t\u0011\u0012I\u001d:bs\ncwnY6j]\u001e\fV/Z;f!\u0011\u0019\tca\u000b\u000e\u0005\r\r\"\u0002BB\u0013\u0007O\t\u0001b\u00195b]:,Gn\u001d\u0006\u0005\u0007S\tY!A\u0002oS>LAa!\f\u0004$\ti1k\\2lKR\u001c\u0005.\u00198oK2\fqB\\3x\u0007>tg.Z2uS>t7\u000fI\u0001\u0012S:4G.[4iiJ+7\u000f]8og\u0016\u001cXCAB\u001b!!\u00199d!\u0010\u0003P\r\u0005SBAB\u001d\u0015\u0011\u0019YDa3\u0002\u000f5,H/\u00192mK&!1qHB\u001d\u0005\ri\u0015\r\u001d\t\u0005\u0007\u0007\u001aIED\u0002t\u0007\u000bJ1aa\u0012o\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2LAaa\u0013\u0004N\tA!+Z:q_:\u001cXMC\u0002\u0004H9\f!#\u001b8gY&<\u0007\u000e\u001e*fgB|gn]3tA\u0005i!/Z:q_:\u001cX-U;fk\u0016,\"a!\u0016\u0011\r\rE1qKB!\u0013\u0011\u0019Ifa\u0005\u0003'1Kgn[3e\u00052|7m[5oO\u0012+\u0017/^3\u0002\u001dI,7\u000f]8og\u0016\fV/Z;fA\u0005QQ.\u001a;sS\u000e$\u0016mZ:\u0016\u0005\r\u0005\u0004\u0003CB2\u0007K\n\u0019!a\u0001\u000e\u0005\r]\u0011\u0002BB \u0007/\t1\"\\3ue&\u001cG+Y4tA\u0005iR\r\u001f9je\u0016$7i\u001c8oK\u000e$\u0018n\u001c8t\u0017&dG.\u001a3D_VtG/\u0006\u0002\u0004nA!1qNB;\u001b\t\u0019\tH\u0003\u0003\u0004t\u0005%\u0016!B:uCR\u001c\u0018\u0002BB<\u0007c\u0012QbQ;nk2\fG/\u001b<f'Vl\u0017AH3ya&\u0014X\rZ\"p]:,7\r^5p]N\\\u0015\u000e\u001c7fI\u000e{WO\u001c;!\u0003\u001d*\u0007\u0010]5sK\u0012\u001cuN\u001c8fGRLwN\\:LS2dW\rZ\"pk:$X*\u001a;sS\u000et\u0015-\\3\u0016\u0005\r}\u0004\u0003BBA\u0007\u0007k!!a\u0013\n\t\r\u0015\u00151\n\u0002\u000b\u001b\u0016$(/[2OC6,\u0017\u0001K3ya&\u0014X\rZ\"p]:,7\r^5p]N\\\u0015\u000e\u001c7fI\u000e{WO\u001c;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013\u0001C:fY\u0016\u001cGo\u001c:\u0016\u0005\r5\u0005\u0003BA?\u0007\u001fKAa!%\u0002\u0000\tA1+\u001a7fGR|'/A\u0005tK2,7\r^8sA\u0005q1M]3bi\u0016\u001cV\r\\3di>\u0014H\u0003BBG\u00073Cqaa'O\u0001\u0004\u0019i*\u0001\bdQ\u0006tg.\u001a7Ck&dG-\u001a:\u0011\t\u0005u4qT\u0005\u0005\u0007C\u000byH\u0001\bDQ\u0006tg.\u001a7Ck&dG-\u001a:\u0002'9,\u0007\u0010^\"p]:,7\r^5p]&sG-\u001a=\u0002/9,\u0007\u0010^\"p]:,7\r^5p]&sG-\u001a=`I\u0015\fH\u0003BBU\u0007_\u00032a^BV\u0013\r\u0019i\u000b\u001f\u0002\u0005+:LG\u000fC\u0005\u0003BB\u000b\t\u00111\u0001\u0002\"\u0005!b.\u001a=u\u0007>tg.Z2uS>t\u0017J\u001c3fq\u0002\n1A];o)\t\u0019I+\u0001\tqe>\u001cWm]:Fq\u000e,\u0007\u000f^5p]R11\u0011VB^\u0007\u007fCqa!0T\u0001\u0004\u0011y%\u0001\u0007feJ|'/T3tg\u0006<W\rC\u0004\u0004BN\u0003\raa1\u0002\u0013QD'o\\<bE2,\u0007\u0003\u0002B\u001c\u0007\u000bLAaa2\u0003J\tIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u0018aJ|7-Z:t\u0007\"\fgN\\3m\u000bb\u001cW\r\u001d;j_:$\u0002b!+\u0004N\u000eE71\u001b\u0005\b\u0007\u001f$\u0006\u0019\u0001B(\u0003%\u0019\u0007.\u00198oK2LE\rC\u0004\u0004>R\u0003\rAa\u0014\t\u000f\r\u0005G\u000b1\u0001\u0004D\u0006\u0019\u0002O]8dKN\u001ch*Z<SKN\u0004xN\\:fg\u0006a1/\u001a8e%\u0016\u001c\bo\u001c8tKR11\u0011VBn\u0007?Dqa!8W\u0001\u0004\u0019\t%\u0001\u0005sKN\u0004xN\\:f\u0011\u001d\u0019\tO\u0016a\u0001\u0007G\fAB]3ta>t7/Z*f]\u0012\u0004B!! \u0004f&!1q]A@\u0005\u0011\u0019VM\u001c3\u0002\tA|G\u000e\\\u0001\u0013a\u0006\u00148/\u001a*fcV,7\u000f\u001e%fC\u0012,'\u000f\u0006\u0003\u0004p\u000em\b\u0003BBy\u0007ol!aa=\u000b\t\rU\u00181J\u0001\te\u0016\fX/Z:ug&!1\u0011`Bz\u00055\u0011V-];fgRDU-\u00193fe\"91Q -A\u0002\r}\u0018A\u00022vM\u001a,'\u000f\u0005\u0003\u0005\u0002\u0011\rQBAB\u0014\u0013\u0011!)aa\n\u0003\u0015\tKH/\u001a\"vM\u001a,'/\u0001\rqe>\u001cWm]:D_6\u0004H.\u001a;fIJ+7-Z5wKN\fQ\u0003\u001d:pG\u0016\u001c8oQ8na2,G/\u001a3TK:$7/\u0001\u000bva\u0012\fG/\u001a*fcV,7\u000f^'fiJL7m\u001d\u000b\u0005\u0007S#y\u0001C\u0004\u0004^n\u0003\ra!\u0011\u0002'A\u0014xnY3tg\u0012K7oY8o]\u0016\u001cG/\u001a3\u0002-\rdwn]3Fq\u000e,7o]\"p]:,7\r^5p]N\fQa\u00197pg\u0016$Ba!+\u0005\u001a!9A1\u00040A\u0002\t=\u0013\u0001D2p]:,7\r^5p]&#\u0017AB1dG\u0016\u0004H\u000f\u0006\u0005\u0002V\u0012\u0005BQ\u0005C\u0015\u0011\u001d!\u0019c\u0018a\u0001\u0007?\tQb]8dW\u0016$8\t[1o]\u0016d\u0007b\u0002C\u0014?\u0002\u0007\u0011Q[\u0001\t[\u0006L(\t\\8dW\"9A1F0A\u0002\u00115\u0012\u0001G1dG\u0016\u0004Ho\u001c:JI2,\u0007+\u001a:dK:$X*\u001a;feB!Aq\u0006C \u001b\t!\tD\u0003\u0003\u00054\u0011U\u0012\u0001B2pe\u0016TA!a\u000e\u00058)!A\u0011\bC\u001e\u0003\u0019I\u0018-\\7fe*\u0011AQH\u0001\u0004G>l\u0017\u0002\u0002C!\tc\u0011Q!T3uKJ\fqcY8oM&<WO]3OK^\u001cuN\u001c8fGRLwN\\:\u0002\u0011\rdwn]3BY2$BAa\u0014\u0005J!9A1\n2A\u0002\u00115\u0013AB:pG.,G\u000f\u0005\u0003\u0005P\u0011USB\u0001C)\u0015\u0011!\u0019&a\u0003\u0002\u00079,G/\u0003\u0003\u0005X\u0011E#AB*pG.,G/A\bf]F,X-^3SKN\u0004xN\\:f)\u0011\u0019I\u000b\"\u0018\t\u000f\ru7\r1\u0001\u0004B\u0005yA-Z9vKV,'+Z:q_:\u001cX\r\u0006\u0002\u0004B\u0005\t\"/Z:q_:\u001cX-U;fk\u0016\u001c\u0016N_3\u0002+%tg\r\\5hQR\u0014Vm\u001d9p]N,7i\\;oi\u0006!r\u000e]3o\u001fJ\u001cEn\\:j]\u001e\u001c\u0005.\u00198oK2$B\u0001b\u001b\u0005tA)qOa\n\u0005nA!\u0011Q\u0010C8\u0013\u0011!\t(a \u0003\u0019-\u000bgm[1DQ\u0006tg.\u001a7\t\u000f\u0011mq\r1\u0001\u0003P\u00051\u0002.\u00198eY\u0016\u001c\u0005.\u00198oK2lU\u000f^3Fm\u0016tG\u000f\u0006\u0004\u0004*\u0012eD1\u0010\u0005\b\t7A\u0007\u0019\u0001B(\u0011\u001d!i\b\u001ba\u0001\t\u007f\nQ!\u001a<f]R\u0004B\u0001\"!\u0005\u001c:!A1\u0011CL\u001d\u0011!)\t\"&\u000f\t\u0011\u001dE1\u0013\b\u0005\t\u0013#\tJ\u0004\u0003\u0005\f\u0012=e\u0002\u0002B\u001e\t\u001bK!!a\u0016\n\t\u0005M\u0013QK\u0005\u0004c\u0006E\u0013\u0002BA'\u0003\u001fJ1a\\A&\u0013\u0011!I*a \u0002\u0019-\u000bgm[1DQ\u0006tg.\u001a7\n\t\u0011uEq\u0014\u0002\u0011\u0007\"\fgN\\3m\u001bV$X-\u0012<f]RTA\u0001\"'\u0002\u0000\u0005\u0001BO]=V]6,H/Z\"iC:tW\r\u001c\u000b\u0005\u0007S#)\u000bC\u0004\u0005\u001c%\u0004\rAa\u0014\u0002\u000f\rD\u0017M\u001c8fYR!A1\u000eCV\u0011\u001d!YB\u001ba\u0001\u0005\u001f\naa^1lKV\u0004\u0018\u0001E5oSRL\u0017\r^3TQV$Hm\\<o\u0001")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    private final Time time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final int failedAuthenticationDelayMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final int connectionQueueSize;
    private final boolean isPrivilegedListener;
    private final ApiVersionManager apiVersionManager;
    private final ArrayBlockingQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final LinkedBlockingDeque<RequestChannel.Response> responseQueue;
    private final java.util.Map<String, String> metricTags;
    private final CumulativeSum expiredConnectionsKilledCount;
    private final MetricName expiredConnectionsKilledCountMetricName;
    private final Selector selector;
    private int nextConnectionIndex;

    public static int ConnectionQueueSize() {
        return Processor$.MODULE$.ConnectionQueueSize();
    }

    public static String ListenerMetricTag() {
        return Processor$.MODULE$.ListenerMetricTag();
    }

    public static String NetworkProcessorMetricTag() {
        return Processor$.MODULE$.NetworkProcessorMetricTag();
    }

    public static String IdlePercentMetricName() {
        return Processor$.MODULE$.IdlePercentMetricName();
    }

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(com.yammer.metrics.core.MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ArrayBlockingQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    private LinkedBlockingDeque<RequestChannel.Response> responseQueue() {
        return this.responseQueue;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    public CumulativeSum expiredConnectionsKilledCount() {
        return this.expiredConnectionsKilledCount;
    }

    private MetricName expiredConnectionsKilledCountMetricName() {
        return this.expiredConnectionsKilledCountMetricName;
    }

    public Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.failedAuthenticationDelayMs, this.metrics, this.time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.configureNewConnections();
                    this.processNewResponses();
                    this.poll();
                    this.processCompletedReceives();
                    this.processCompletedSends();
                    this.processDisconnected();
                    this.closeExcessConnections();
                }
                catch (Throwable e) {
                    this.processException("Processor got uncaught exception.", e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Closing selector - processor ").append(this.id()).toString());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.closeAll(), this, Level.ERROR);
            this.shutdownComplete();
        }
    }

    public void processException(String errorMessage, Throwable throwable) {
        if (throwable instanceof ControlThrowable) {
            throw (ControlThrowable)throwable;
        }
        this.error((Function0<String>)(Function0 & Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Closing socket for ").append(channelId).append(" because of error").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        RequestChannel.Response currentResponse;
        while ((currentResponse = this.dequeueResponse()) != null) {
            String channelId = currentResponse.request().context().connectionId;
            try {
                if (currentResponse instanceof RequestChannel.NoOpResponse) {
                    RequestChannel.NoOpResponse noOpResponse = (RequestChannel.NoOpResponse)currentResponse;
                    this.updateRequestMetrics(noOpResponse);
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Socket server received empty response to send, registering for read: ").append(noOpResponse).toString());
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.SendResponse) {
                    RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)currentResponse;
                    this.sendResponse(sendResponse, sendResponse.responseSend());
                    continue;
                }
                if (currentResponse instanceof RequestChannel.CloseConnectionResponse) {
                    RequestChannel.CloseConnectionResponse closeConnectionResponse = (RequestChannel.CloseConnectionResponse)currentResponse;
                    this.updateRequestMetrics(closeConnectionResponse);
                    this.trace((Function0<String>)(Function0 & Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.StartThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_STARTED);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.EndThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_ENDED);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                throw new IllegalArgumentException(new StringBuilder(23).append("Unknown response type: ").append(currentResponse.getClass()).toString());
            }
            catch (Throwable e) {
                this.processChannelException(channelId, new StringBuilder(40).append("Exception while processing response for ").append(channelId).toString(), e);
            }
        }
    }

    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        String connectionId = response.request().context().connectionId;
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(85).append("Socket server received response to send to ").append(connectionId).append(", registering for write and sending data: ").append(response).toString());
        if (this.channel(connectionId).isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Attempting to send response via channel for which there is no open connection, connection id ").append(connectionId).toString());
            response.request().updateRequestMetrics(0L, response);
        }
        if (this.openOrClosingChannel(connectionId).isDefined()) {
            this.selector().send(new NetworkSend(connectionId, responseSend));
            this.inflightResponses().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)connectionId), (Object)response));
        }
    }

    private void poll() {
        int pollTimeout = this.newConnections().isEmpty() ? 300 : 0;
        try {
            this.selector().poll((long)pollTimeout);
            return;
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof IllegalStateException ? true : throwable instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Processor ").append(this.id()).append(" poll failed").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                return;
            }
            throw throwable;
        }
    }

    public RequestHeader parseRequestHeader(ByteBuffer buffer) {
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        if (this.apiVersionManager.isApiEnabled(header.apiKey())) {
            return header;
        }
        throw new InvalidRequestException(new StringBuilder(46).append("Received request api key ").append(header.apiKey()).append(" which is not enabled").toString());
    }

    private void processCompletedReceives() {
        this.selector().completedReceives().forEach(receive -> {
            block9: {
                try {
                    Option<KafkaChannel> option = this.openOrClosingChannel(receive.source());
                    if (option instanceof Some) {
                        KafkaChannel channel = (KafkaChannel)((Some)option).value();
                        RequestHeader header = this.parseRequestHeader(receive.payload());
                        ApiKeys apiKeys = header.apiKey();
                        ApiKeys apiKeys2 = ApiKeys.SASL_HANDSHAKE;
                        if (!(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null) && channel.maybeBeginServerReauthentication(receive, () -> Predef$.MODULE$.long2Long($this.time.nanoseconds()))) {
                            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("Begin re-authentication: ").append(channel).toString());
                        } else {
                            long nowNanos = $this.time.nanoseconds();
                            if (channel.serverAuthenticationSessionExpired(nowNanos)) {
                                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Disconnecting expired channel: ").append(channel).append(" : ").append(header).toString());
                                this.close(channel.id());
                                this.expiredConnectionsKilledCount().record(null, 1.0, 0L);
                            } else {
                                ApiVersionsRequest apiVersionsRequest;
                                String connectionId = receive.source();
                                RequestContext context = new RequestContext(header, connectionId, channel.socketAddress(), channel.principal(), $this.listenerName, $this.securityProtocol, channel.channelMetadataRegistry().clientInformation(), $this.isPrivilegedListener, channel.principalSerde());
                                RequestChannel.Request req = new RequestChannel.Request(this.id(), context, nowNanos, $this.memoryPool, receive.payload(), $this.requestChannel.metrics(), (Option<RequestChannel.Request>)None$.MODULE$);
                                ApiKeys apiKeys3 = header.apiKey();
                                ApiKeys apiKeys4 = ApiKeys.API_VERSIONS;
                                if (!(apiKeys3 != null ? !apiKeys3.equals(apiKeys4) : apiKeys4 != null) && (apiVersionsRequest = (ApiVersionsRequest)req.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).isValid()) {
                                    channel.channelMetadataRegistry().registerClientInformation(new ClientInformation(apiVersionsRequest.data().clientSoftwareName(), apiVersionsRequest.data().clientSoftwareVersion()));
                                }
                                $this.requestChannel.sendRequest(req);
                                this.selector().mute(connectionId);
                                this.handleChannelMuteEvent(connectionId, KafkaChannel.ChannelMuteEvent.REQUEST_RECEIVED);
                            }
                        }
                        break block9;
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalStateException(new StringBuilder(66).append("Channel ").append(receive.source()).append(" removed from selector before processing completed receive").toString());
                    }
                    throw new MatchError(option);
                }
                catch (Throwable e) {
                    this.processChannelException(receive.source(), new StringBuilder(40).append("Exception while processing request from ").append(receive.source()).toString(), e);
                }
            }
        });
        this.selector().clearCompletedReceives();
    }

    private void processCompletedSends() {
        this.selector().completedSends().forEach(send -> {
            try {
                RequestChannel.Response response = (RequestChannel.Response)this.inflightResponses().remove((Object)send.destinationId()).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(51).append("Send for ").append(send.destinationId()).append(" completed, but not in `inflightResponses`").toString());
                });
                this.updateRequestMetrics(response);
                response.onComplete().foreach((Function1 & Serializable)onComplete -> {
                    onComplete.apply((Object)send);
                    return BoxedUnit.UNIT;
                });
                this.handleChannelMuteEvent(send.destinationId(), KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                this.tryUnmuteChannel(send.destinationId());
                return;
            }
            catch (Throwable e) {
                this.processChannelException(send.destinationId(), new StringBuilder(45).append("Exception while processing completed send to ").append(send.destinationId()).toString(), e);
                return;
            }
        });
        this.selector().clearCompletedSends();
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        RequestChannel.Request request = response.request();
        long networkThreadTimeNanos = BoxesRunTime.unboxToLong((Object)this.openOrClosingChannel(request.context().connectionId).fold((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.getAndResetNetworkThreadTimeNanos())));
        request.updateRequestMetrics(networkThreadTimeNanos, response);
    }

    private void processDisconnected() {
        this.selector().disconnected().keySet().forEach(connectionId -> {
            try {
                String remoteHost = ((ConnectionId)this.ConnectionId().fromString((String)connectionId).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(36).append("connectionId has unexpected format: ").append((String)connectionId).toString());
                })).remoteHost();
                this.inflightResponses().remove(connectionId).foreach((Function1 & Serializable)response -> {
                    this.updateRequestMetrics(response);
                    return BoxedUnit.UNIT;
                });
                $this.connectionQuotas.dec($this.listenerName, InetAddress.getByName(remoteHost));
                return;
            }
            catch (Throwable e) {
                this.processException(new StringBuilder(44).append("Exception while processing disconnection of ").append((String)connectionId).toString(), e);
                return;
            }
        });
    }

    private void closeExcessConnections() {
        KafkaChannel channel;
        if (this.connectionQuotas.maxConnectionsExceeded(this.listenerName) && (channel = this.selector().lowestPriorityChannel()) != null) {
            this.close(channel.id());
            return;
        }
    }

    private void close(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable)channel -> {
            Processor.$anonfun$close$2(this, connectionId, channel);
            return BoxedUnit.UNIT;
        });
    }

    public boolean accept(SocketChannel socketChannel, boolean mayBlock, Meter acceptorIdlePercentMeter) {
        boolean accepted;
        boolean bl;
        if (this.newConnections().offer(socketChannel)) {
            bl = true;
        } else if (mayBlock) {
            long startNs = this.time.nanoseconds();
            this.newConnections().put(socketChannel);
            acceptorIdlePercentMeter.mark(this.time.nanoseconds() - startNs);
            bl = true;
        } else {
            bl = accepted = false;
        }
        if (accepted) {
            this.wakeup();
        }
        return accepted;
    }

    private void configureNewConnections() {
        int connectionsProcessed = 0;
        while (connectionsProcessed < this.connectionQueueSize && !this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Processor ").append(this.id()).append(" listening to new connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
                this.selector().register(this.connectionId(channel.socket()), channel);
                ++connectionsProcessed;
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.close(this.listenerName, channel);
                this.processException(new StringBuilder(34).append("Processor ").append(this.id()).append(" closed connection from ").append(remoteAddress).toString(), e);
            }
        }
    }

    private void closeAll() {
        while (!this.newConnections().isEmpty()) {
            ((AbstractInterruptibleChannel)this.newConnections().poll()).close();
        }
        this.selector().channels().forEach(channel -> this.close(channel.id()));
        this.selector().close();
        this.removeMetric(Processor$.MODULE$.IdlePercentMetricName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)Integer.toString(this.id()))}))));
    }

    public String connectionId(Socket socket) {
        String localHost = socket.getLocalAddress().getHostAddress();
        int localPort = socket.getLocalPort();
        String remoteHost = socket.getInetAddress().getHostAddress();
        int remotePort = socket.getPort();
        String connId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort, this.nextConnectionIndex()).toString();
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public void enqueueResponse(RequestChannel.Response response) {
        this.responseQueue().put(response);
        this.wakeup();
    }

    /*
     * WARNING - void declaration
     */
    private RequestChannel.Response dequeueResponse() {
        void var1_1;
        RequestChannel.Response response = this.responseQueue().poll();
        if (response != null) {
            response.request().responseDequeueTimeNanos_$eq(Time.SYSTEM.nanoseconds());
        }
        return var1_1;
    }

    public int responseQueueSize() {
        return this.responseQueue().size();
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId)).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)this.selector().closingChannel(connectionId)));
    }

    private void handleChannelMuteEvent(String connectionId, KafkaChannel.ChannelMuteEvent event) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable)c -> {
            c.handleChannelMuteEvent(event);
            return BoxedUnit.UNIT;
        });
    }

    private void tryUnmuteChannel(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable)c -> {
            Processor.$anonfun$tryUnmuteChannel$1(this, c);
            return BoxedUnit.UNIT;
        });
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        this.removeMetric("IdlePercent", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)Integer.toString(this.id()))}))));
        this.metrics.removeMetric(this.expiredConnectionsKilledCountMetricName());
    }

    private final void ConnectionId$lzycompute$1() {
        synchronized (this) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ double $anonfun$new$3(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public final /* synthetic */ double kafka$network$Processor$$$anonfun$new$1() {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)this.metrics.metric(this.metrics.metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), this.metricTags()))).fold((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function1 & Serializable)m -> BoxesRunTime.boxToDouble((double)Processor.$anonfun$new$3(m))));
    }

    public static final /* synthetic */ void $anonfun$close$2(Processor $this, String connectionId$3, KafkaChannel channel) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Closing selector connection ").append(connectionId$3).toString());
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec($this.listenerName, address);
        }
        $this.selector().close(connectionId$3);
        $this.inflightResponses().remove((Object)connectionId$3).foreach((Function1 & Serializable)response -> {
            $this.updateRequestMetrics(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$tryUnmuteChannel$1(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, int failedAuthenticationDelayMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext, int connectionQueueSize, boolean isPrivilegedListener, ApiVersionManager apiVersionManager) {
        this.id = id;
        this.time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.config = config;
        this.metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        this.connectionQueueSize = connectionQueueSize;
        this.isPrivilegedListener = isPrivilegedListener;
        this.apiVersionManager = apiVersionManager;
        super(connectionQuotas);
        this.newConnections = new ArrayBlockingQueue(connectionQueueSize);
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.responseQueue = new LinkedBlockingDeque();
        this.metricTags = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)listenerName.value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)Integer.toString(id))}))).asJava();
        this.newGauge(Processor$.MODULE$.IdlePercentMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public final double value() {
                return this.$outer.kafka$network$Processor$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)Integer.toString(id))}))));
        this.expiredConnectionsKilledCount = new CumulativeSum();
        this.expiredConnectionsKilledCountMetricName = metrics.metricName("expired-connections-killed-count", SocketServer$.MODULE$.MetricsGroup(), this.metricTags());
        metrics.addMetric(this.expiredConnectionsKilledCountMetricName(), (Measurable)this.expiredConnectionsKilledCount());
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (listenerName.equals(config.interBrokerListenerName()) ? 1 : 0) != 0, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache(), (DelegationTokenCache)credentialProvider.tokenCache(), (Time)time, (LogContext)logContext, () -> $this.apiVersionManager.apiVersionResponse(0)));
        this.nextConnectionIndex = 0;
    }

    public class ConnectionId
    implements Product,
    Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        private final int index;
        public final /* synthetic */ Processor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return new StringBuilder(4).append(this.localHost()).append(":").append(this.localPort()).append("-").append(this.remoteHost()).append(":").append(this.remotePort()).append("-").append(this.index()).toString();
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort, int index) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort, index);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public int copy$default$5() {
            return this.index();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.localHost();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.localPort());
                }
                case 2: {
                    return this.remoteHost();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this.remotePort());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this.index());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "localHost";
                }
                case 1: {
                    return "localPort";
                }
                case 2: {
                    return "remoteHost";
                }
                case 3: {
                    return "remotePort";
                }
                case 4: {
                    return "index";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.localHost())), (int)this.localPort()), (int)Statics.anyHash((Object)this.remoteHost())), (int)this.remotePort()), (int)this.index()), (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ConnectionId)) return false;
            if (((ConnectionId)x$1).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            if (this.localPort() != connectionId.localPort()) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (this.index() != connectionId.index()) return false;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort, int index) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

