/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client;

import io.confluent.ksql.api.client.AcksPublisher;
import io.confluent.ksql.api.client.BatchedQueryResult;
import io.confluent.ksql.api.client.ClientOptions;
import io.confluent.ksql.api.client.ConnectorDescription;
import io.confluent.ksql.api.client.ConnectorInfo;
import io.confluent.ksql.api.client.ExecuteStatementResult;
import io.confluent.ksql.api.client.KsqlObject;
import io.confluent.ksql.api.client.QueryInfo;
import io.confluent.ksql.api.client.ServerInfo;
import io.confluent.ksql.api.client.SourceDescription;
import io.confluent.ksql.api.client.StreamInfo;
import io.confluent.ksql.api.client.StreamedQueryResult;
import io.confluent.ksql.api.client.TableInfo;
import io.confluent.ksql.api.client.TopicInfo;
import io.confluent.ksql.api.client.impl.ClientImpl;
import io.vertx.core.Vertx;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;

public interface Client
extends Closeable {
    public CompletableFuture<StreamedQueryResult> streamQuery(String var1);

    public CompletableFuture<StreamedQueryResult> streamQuery(String var1, Map<String, Object> var2);

    public BatchedQueryResult executeQuery(String var1);

    public BatchedQueryResult executeQuery(String var1, Map<String, Object> var2);

    public CompletableFuture<Void> insertInto(String var1, KsqlObject var2);

    public CompletableFuture<AcksPublisher> streamInserts(String var1, Publisher<KsqlObject> var2);

    public CompletableFuture<Void> terminatePushQuery(String var1);

    public CompletableFuture<ExecuteStatementResult> executeStatement(String var1);

    public CompletableFuture<ExecuteStatementResult> executeStatement(String var1, Map<String, Object> var2);

    public CompletableFuture<List<StreamInfo>> listStreams();

    public CompletableFuture<List<TableInfo>> listTables();

    public CompletableFuture<List<TopicInfo>> listTopics();

    public CompletableFuture<List<QueryInfo>> listQueries();

    public CompletableFuture<SourceDescription> describeSource(String var1);

    public CompletableFuture<ServerInfo> serverInfo();

    public CompletableFuture<Void> createConnector(String var1, boolean var2, Map<String, Object> var3);

    public CompletableFuture<Void> dropConnector(String var1);

    public CompletableFuture<List<ConnectorInfo>> listConnectors();

    public CompletableFuture<ConnectorDescription> describeConnector(String var1);

    public HttpRequest buildRequest(String var1, String var2);

    public void define(String var1, Object var2);

    public void undefine(String var1);

    public Map<String, Object> getVariables();

    @Override
    public void close();

    public static Client create(ClientOptions clientOptions) {
        return new ClientImpl(clientOptions);
    }

    public static Client create(ClientOptions clientOptions, Vertx vertx) {
        return new ClientImpl(clientOptions, vertx);
    }

    public static interface HttpResponse {
        public int status();

        public byte[] body();

        public <T> Map<String, T> bodyAsMap();
    }

    public static interface HttpRequest {
        public HttpRequest payload(String var1, Object var2);

        public HttpRequest payload(Map<String, Object> var1);

        public Map<String, Object> payload();

        public HttpRequest property(String var1, Object var2);

        public Map<String, Object> properties();

        public HttpRequest properties(Map<String, Object> var1);

        public HttpRequest propertiesKey(String var1);

        public String propertiesKey();

        public String path();

        public String method();

        public CompletableFuture<HttpResponse> send();
    }
}

