/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.KeyManagerKeyStoreBuilder;
import com.tersesystems.securitybuilder.KeyStoreBuilder;
import com.tersesystems.securitybuilder.KeyStoreDefaults;
import com.tersesystems.securitybuilder.PrivateKeyStoreImpl;
import com.tersesystems.securitybuilder.RuntimeKeyStoreException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Map;

public interface PrivateKeyStore
extends Map<String, KeyStore.PrivateKeyEntry> {
    public static PrivateKeyStore create(KeyStore.Builder builder) {
        return new PrivateKeyStoreImpl(builder);
    }

    public static PrivateKeyStore create() {
        return PrivateKeyStore.create("".toCharArray());
    }

    public static PrivateKeyStore create(char[] password) {
        return PrivateKeyStore.create(new KeyStore.PasswordProtection(password));
    }

    public static PrivateKeyStore create(KeyStore.ProtectionParameter protectionParameter) {
        return PrivateKeyStore.create(KeyStoreBuilder.empty(), protectionParameter);
    }

    public static PrivateKeyStore create(KeyStore keyStore, char[] password) {
        return PrivateKeyStore.create(keyStore, new KeyStore.PasswordProtection(password));
    }

    public static PrivateKeyStore create(KeyStore keyStore, KeyStore.ProtectionParameter protectionParameter) {
        return PrivateKeyStore.create(KeyManagerKeyStoreBuilder.newInstance(keyStore, protectionParameter));
    }

    public static PrivateKeyStore create(String alias, PrivateKey privateKey, Certificate ... chain) {
        KeyStore.PrivateKeyEntry entry = new KeyStore.PrivateKeyEntry(privateKey, chain);
        return PrivateKeyStore.create(alias, entry, new KeyStore.PasswordProtection("".toCharArray()));
    }

    public static PrivateKeyStore create(String alias, PrivateKey privateKey, KeyStore.ProtectionParameter protectionParameter, Certificate ... chain) {
        KeyStore.PrivateKeyEntry entry = new KeyStore.PrivateKeyEntry(privateKey, chain);
        return PrivateKeyStore.create(alias, entry, protectionParameter);
    }

    public static PrivateKeyStore create(String alias, KeyStore.PrivateKeyEntry entry, KeyStore.ProtectionParameter protectionParameter) {
        PrivateKeyStore privateKeyStore = PrivateKeyStore.create(protectionParameter);
        privateKeyStore.put(alias, entry);
        return privateKeyStore;
    }

    public static PrivateKeyStore system() {
        try {
            return PrivateKeyStore.create(KeyStoreDefaults.getKeyStore(), System.getProperty("javax.net.ssl.keyStorePassword", "").toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeKeyStoreException(e);
        }
    }

    public KeyStore getKeyStore();

    public KeyStore.Builder getBuilder();
}

