/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import org.slieb.throwables.SupplierWithThrowable;

public abstract class InstanceGenerator<I, E extends Exception> {
    FactoryInstance getInstance() {
        return new FactoryInstance();
    }

    class FactoryInstance {
        private final Class<I> clazz;

        private FactoryInstance() {
            this.clazz = (Class)((ParameterizedType)InstanceGenerator.this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }

        private Class<I> getClazz() {
            return this.clazz;
        }

        SupplierWithThrowable<I, E> withAlgorithm(String algorithm) {
            Objects.requireNonNull(algorithm);
            return () -> this.singleGetInstance(algorithm);
        }

        SupplierWithThrowable<I, E> withType(String type) {
            Objects.requireNonNull(type);
            return () -> this.singleGetInstance(type);
        }

        SupplierWithThrowable<I, E> withProtocol(String protocol) {
            Objects.requireNonNull(protocol);
            return () -> this.singleGetInstance(protocol);
        }

        SupplierWithThrowable<I, E> withProtocolAndProvider(String protocol, String provider) {
            Objects.requireNonNull(protocol);
            return () -> this.doubleGetInstance(protocol, provider);
        }

        SupplierWithThrowable<I, E> withDefaultAlgorithm() {
            return () -> this.singleGetInstanceWithDefault("getDefaultAlgorithm");
        }

        SupplierWithThrowable<I, E> withDefaultType() {
            return () -> this.singleGetInstanceWithDefault("getDefaultType");
        }

        SupplierWithThrowable<I, E> withAlgorithmAndProvider(String algorithm, String provider) {
            Objects.requireNonNull(algorithm);
            return () -> this.doubleGetInstance(algorithm, provider);
        }

        SupplierWithThrowable<I, E> withTypeAndProvider(String type, String provider) {
            Objects.requireNonNull(type);
            return () -> this.doubleGetInstance(type, provider);
        }

        private I singleGetInstance(String stringParam) {
            try {
                Method getInstance = this.getClazz().getMethod("getInstance", String.class);
                return getInstance.invoke(null, stringParam);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        private I doubleGetInstance(String stringParam, String provider) {
            try {
                Method getInstance = this.getClazz().getMethod("getInstance", String.class, String.class);
                return getInstance.invoke(null, stringParam, provider);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        private I singleGetInstanceWithDefault(String defaultMethodName) {
            try {
                Method defaultAlgorithmMethod = this.getClazz().getMethod(defaultMethodName, new Class[0]);
                String defaultAlgorithm = (String)defaultAlgorithmMethod.invoke(null, new Object[0]);
                Method getInstance = this.getClazz().getMethod("getInstance", String.class);
                return getInstance.invoke(null, defaultAlgorithm);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

