/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.static;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import sttp.model.MediaType;
import sttp.model.MediaType$;
import sttp.model.headers.ETag;
import sttp.monad.MonadError;
import sttp.monad.syntax;
import sttp.monad.syntax$;
import sttp.tapir.static.StaticErrorOutput;
import sttp.tapir.static.StaticErrorOutput$NotFound$;
import sttp.tapir.static.StaticInput;
import sttp.tapir.static.StaticOutput;
import sttp.tapir.static.StaticOutput$NotModified$;
import sttp.tapir.static.package$;

public final class Resources$ {
    public static final Resources$ MODULE$ = new Resources$();

    public <F> Function1<StaticInput, F> apply(ClassLoader classLoader, String resourcePrefix, boolean useETags, boolean useGzippedIfAvailable, MonadError<F> evidence$1) {
        return (Function1 & Serializable)resourcesInput -> MODULE$.resources(classLoader, (List<String>)Predef$.MODULE$.wrapRefArray((Object[])resourcePrefix.split("/")).toList(), useETags, useGzippedIfAvailable, (StaticInput)resourcesInput, evidence$1);
    }

    public <F> boolean apply$default$3() {
        return true;
    }

    public <F> boolean apply$default$4() {
        return false;
    }

    private <F> F resources(ClassLoader classLoader, List<String> resourcePrefix, boolean useETags, boolean useGzippedIfAvailable, StaticInput resourcesInput, MonadError<F> m) {
        boolean gzippedResource = useGzippedIfAvailable && resourcesInput.acceptEncoding().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals("gzip")));
        String name = ((IterableOnceOps)resourcePrefix.$plus$plus(resourcesInput.path())).mkString("/");
        Object gzipUrl = gzippedResource ? m.blocking((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)classLoader.getResource(name.concat(".gz")))) : m.unit((Object)Option$.MODULE$.empty());
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> gzipUrl).flatMap((Function1 & Serializable)maybeUrl -> m.blocking((Function0 & Serializable)() -> (Either)maybeUrl.map((Function1 & Serializable)url -> MODULE$.readResource(useETags, resourcesInput, (URL)url, (Option<MediaType>)new Some((Object)MediaType$.MODULE$.ApplicationGzip()), (Option<String>)new Some((Object)"gzip"))).getOrElse((Function0 & Serializable)() -> (Either)Option$.MODULE$.apply((Object)classLoader.getResource(name)).map((Function1 & Serializable)url -> MODULE$.readResource(useETags, resourcesInput, (URL)url, (Option<MediaType>)new Some((Object)package$.MODULE$.contentTypeFromName(name)), (Option<String>)None$.MODULE$)).getOrElse((Function0 & Serializable)() -> scala.package$.MODULE$.Left().apply((Object)StaticErrorOutput$NotFound$.MODULE$)))), m)).handleError((PartialFunction)new Serializable(m){
            private static final long serialVersionUID = 0L;
            private final MonadError m$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof FileNotFoundException ? syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)scala.package$.MODULE$.Left().apply((Object)StaticErrorOutput$NotFound$.MODULE$)), this.m$1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof FileNotFoundException;
                return bl;
            }
            {
                this.m$1 = m$1;
            }
        }, m);
    }

    private <F> Either<StaticErrorOutput, StaticOutput<InputStream>> readResource(boolean useETags, StaticInput resourcesInput, URL url, Option<MediaType> contentType, Option<String> contentEncoding) {
        URLConnection conn = url.openConnection();
        long lastModified = conn.getLastModified();
        long length = conn.getContentLengthLong();
        None$ etag = useETags ? new Some((Object)package$.MODULE$.defaultETag(lastModified, length)) : None$.MODULE$;
        return package$.MODULE$.isModified(resourcesInput, (Option<ETag>)etag, lastModified) ? scala.package$.MODULE$.Right().apply(new StaticOutput.Found<InputStream>(conn.getInputStream(), (Option<Instant>)new Some((Object)Instant.ofEpochMilli(lastModified)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)length)), contentType, (Option<ETag>)etag, contentEncoding)) : scala.package$.MODULE$.Right().apply((Object)StaticOutput$NotModified$.MODULE$);
    }

    private Resources$() {
    }
}

