/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.static;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Left;
import sttp.model.ContentRangeUnits$;
import sttp.model.MediaType;
import sttp.model.headers.ETag;
import sttp.model.headers.Range;
import sttp.monad.MonadError;
import sttp.monad.MonadError$;
import sttp.monad.syntax;
import sttp.monad.syntax$;
import sttp.tapir.FileRange;
import sttp.tapir.FileRange$;
import sttp.tapir.RangeValue;
import sttp.tapir.static.HeadInput;
import sttp.tapir.static.HeadOutput;
import sttp.tapir.static.StaticErrorOutput$NotFound$;
import sttp.tapir.static.StaticErrorOutput$RangeNotSatisfiable$;
import sttp.tapir.static.StaticInput;
import sttp.tapir.static.StaticOutput;
import sttp.tapir.static.StaticOutput$NotModified$;
import sttp.tapir.static.package$;

public final class Files$ {
    public static final Files$ MODULE$ = new Files$();

    public <F> Function1<HeadInput, F> head(String systemPath, MonadError<F> evidence$1) {
        return (Function1 & Serializable)input -> MonadError$.MODULE$.apply(evidence$1).blocking((Function0 & Serializable)() -> {
            Left left;
            Path resolved = (Path)input.path().foldLeft((Object)Paths.get(systemPath, new String[0]).toRealPath(new LinkOption[0]), (Function2 & Serializable)(x$1, x$2) -> x$1.resolve((String)x$2));
            if (Files.exists(resolved, LinkOption.NOFOLLOW_LINKS)) {
                File file = resolved.toFile();
                left = scala.package$.MODULE$.Right().apply((Object)new HeadOutput.Found((Option<String>)new Some((Object)ContentRangeUnits$.MODULE$.Bytes()), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)file.length())), (Option<MediaType>)new Some((Object)package$.MODULE$.contentTypeFromName(file.getName()))));
            } else {
                left = scala.package$.MODULE$.Left().apply((Object)StaticErrorOutput$NotFound$.MODULE$);
            }
            return left;
        });
    }

    public <F> Function1<StaticInput, F> get(String systemPath, MonadError<F> evidence$2) {
        return this.get(systemPath, (Function1 & Serializable)file -> MODULE$.defaultEtag((File)file, evidence$2), evidence$2);
    }

    public <F> Function1<StaticInput, F> get(String systemPath, Function1<File, F> calculateETag, MonadError<F> evidence$3) {
        return (Function1 & Serializable)filesInput -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> MonadError$.MODULE$.apply(evidence$3).blocking((Function0 & Serializable)() -> Paths.get(systemPath, new String[0]).toRealPath(new LinkOption[0]))).flatMap((Function1 & Serializable)path2 -> MODULE$.files((Path)path2, calculateETag, (StaticInput)filesInput, evidence$3), evidence$3);
    }

    public <F> F defaultEtag(File file, MonadError<F> evidence$4) {
        return (F)MonadError$.MODULE$.apply(evidence$4).blocking((Function0 & Serializable)() -> file.isFile() ? new Some((Object)package$.MODULE$.defaultETag(file.lastModified(), file.length())) : None$.MODULE$);
    }

    private <F> F files(Path realSystemPath, Function1<File, F> calculateETag, StaticInput filesInput, MonadError<F> m) {
        Path resolved = (Path)filesInput.path().foldLeft((Object)realSystemPath, (Function2 & Serializable)(x$3, x$4) -> x$3.resolve((String)x$4));
        return (F)m.flatten(m.blocking((Function0 & Serializable)() -> {
            Object object;
            if (!Files.exists(resolved, LinkOption.NOFOLLOW_LINKS)) {
                object = syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)scala.package$.MODULE$.Left().apply((Object)StaticErrorOutput$NotFound$.MODULE$)), m);
            } else {
                Path realRequestedPath = resolved.toRealPath(LinkOption.NOFOLLOW_LINKS);
                if (!realRequestedPath.startsWith(realSystemPath)) {
                    object = syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)scala.package$.MODULE$.Left().apply((Object)StaticErrorOutput$NotFound$.MODULE$)), m);
                } else if (realRequestedPath.toFile().isDirectory()) {
                    object = MODULE$.files(realSystemPath, calculateETag, filesInput.copy((List<String>)((List)filesInput.path().$colon$plus((Object)"index.html")), filesInput.copy$default$2(), filesInput.copy$default$3(), filesInput.copy$default$4(), filesInput.copy$default$5()), m);
                } else {
                    Object object2;
                    Option<Range> option = filesInput.range();
                    if (option instanceof Some) {
                        long fileSize;
                        Some some = (Some)option;
                        Range range = (Range)some.value();
                        object2 = range.isValid(fileSize = realRequestedPath.toFile().length()) ? syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> MODULE$.rangeFileOutput(filesInput, realRequestedPath, calculateETag, new RangeValue((Option<Object>)range.start(), (Option<Object>)range.end(), fileSize), m)).map((Function1 & Serializable)x$5 -> scala.package$.MODULE$.Right().apply(x$5), m) : syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)scala.package$.MODULE$.Left().apply((Object)StaticErrorOutput$RangeNotSatisfiable$.MODULE$)), m);
                    } else if (None$.MODULE$.equals(option)) {
                        object2 = syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> MODULE$.wholeFileOutput(filesInput, realRequestedPath, calculateETag, m)).map((Function1 & Serializable)x$6 -> scala.package$.MODULE$.Right().apply(x$6), m);
                    } else {
                        throw new MatchError(option);
                    }
                    object = object2;
                }
            }
            return object;
        }));
    }

    private <F> F rangeFileOutput(StaticInput filesInput, Path file, Function1<File, F> calculateETag, RangeValue range, MonadError<F> m) {
        return this.fileOutput(filesInput, file, calculateETag, (Function3<Object, Object, Option<ETag>, StaticOutput<FileRange>>)(Function3 & Serializable)(lastModified, x$7, etag) -> Files$.$anonfun$rangeFileOutput$1(file, range, BoxesRunTime.unboxToLong((Object)lastModified), BoxesRunTime.unboxToLong((Object)x$7), etag), m);
    }

    private <F> F wholeFileOutput(StaticInput filesInput, Path file, Function1<File, F> calculateETag, MonadError<F> m) {
        return this.fileOutput(filesInput, file, calculateETag, (Function3<Object, Object, Option<ETag>, StaticOutput<FileRange>>)(Function3 & Serializable)(lastModified, fileLength, etag) -> Files$.$anonfun$wholeFileOutput$1(file, BoxesRunTime.unboxToLong((Object)lastModified), BoxesRunTime.unboxToLong((Object)fileLength), etag), m);
    }

    private <F> F fileOutput(StaticInput filesInput, Path file, Function1<File, F> calculateETag, Function3<Object, Object, Option<ETag>, StaticOutput<FileRange>> result, MonadError<F> m) {
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> calculateETag.apply((Object)file.toFile())).flatMap((Function1 & Serializable)etag -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> m.blocking((Function0)(JFunction0.mcJ.sp & Serializable)() -> file.toFile().lastModified())).flatMap((Function1 & Serializable)lastModified -> Files$.$anonfun$fileOutput$5(filesInput, etag, m, file, result, BoxesRunTime.unboxToLong((Object)lastModified)), m), m);
    }

    public static final /* synthetic */ StaticOutput.FoundPartial $anonfun$rangeFileOutput$1(Path file$2, RangeValue range$2, long lastModified, long x$7, Option etag) {
        return new StaticOutput.FoundPartial<FileRange>(new FileRange(file$2.toFile(), (Option<RangeValue>)new Some((Object)range$2)), (Option<Instant>)new Some((Object)Instant.ofEpochMilli(lastModified)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)range$2.contentLength())), (Option<MediaType>)new Some((Object)package$.MODULE$.contentTypeFromName(file$2.toFile().getName())), (Option<ETag>)etag, (Option<String>)new Some((Object)ContentRangeUnits$.MODULE$.Bytes()), (Option<String>)new Some((Object)range$2.toContentRange().toString()));
    }

    public static final /* synthetic */ StaticOutput.Found $anonfun$wholeFileOutput$1(Path file$3, long lastModified, long fileLength, Option etag) {
        return new StaticOutput.Found<FileRange>(new FileRange(file$3.toFile(), FileRange$.MODULE$.apply$default$2()), (Option<Instant>)new Some((Object)Instant.ofEpochMilli(lastModified)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)fileLength)), (Option<MediaType>)new Some((Object)package$.MODULE$.contentTypeFromName(file$3.toFile().getName())), (Option<ETag>)etag, (Option<String>)None$.MODULE$);
    }

    public static final /* synthetic */ StaticOutput $anonfun$fileOutput$9(Function3 result$1, long lastModified$1, Option etag$1, long fileLength) {
        return (StaticOutput)result$1.apply((Object)BoxesRunTime.boxToLong((long)lastModified$1), (Object)BoxesRunTime.boxToLong((long)fileLength), (Object)etag$1);
    }

    public static final /* synthetic */ Object $anonfun$fileOutput$5(StaticInput filesInput$3, Option etag$1, MonadError m$2, Path file$4, Function3 result$1, long lastModified) {
        return syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> package$.MODULE$.isModified(filesInput$3, (Option<ETag>)etag$1, lastModified) ? syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> m$2.blocking((Function0)(JFunction0.mcJ.sp & Serializable)() -> file$4.toFile().length())).map((Function1 & Serializable)fileLength -> Files$.$anonfun$fileOutput$9(result$1, lastModified, etag$1, BoxesRunTime.unboxToLong((Object)fileLength)), m$2) : syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)StaticOutput$NotModified$.MODULE$), m$2)).map((Function1 & Serializable)result -> result, m$2);
    }

    private Files$() {
    }
}

