/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.common.scala.io;

import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.CsvRow;
import io.conduktor.common.scala.io.CsvParser;
import io.conduktor.common.scala.io.CsvParser$EmptyFile$;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import zio.CanFail$;
import zio.Task$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.ZManaged$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class CsvParser$ {
    public static final CsvParser$ MODULE$ = new CsvParser$();
    private static volatile byte bitmap$init$0;

    public ZIO<Object, Throwable, CsvParser.GuessedCsvConfig> tryGuessingCsvConfig(List<String> headers, File file) {
        return ZManaged$.MODULE$.fromAutoCloseable(Task$.MODULE$.apply((Function0 & Serializable)() -> Files.lines(file.toPath()))).use((Function1 & Serializable)stream -> Task$.MODULE$.apply((Function0 & Serializable)() -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(stream.findFirst()))).flatMap((Function1 & Serializable)opt -> ZIO$.MODULE$.fromOption((Function0 & Serializable)() -> opt).orElseFail((Function0 & Serializable)() -> CsvParser$EmptyFile$.MODULE$, CanFail$.MODULE$.canFail()).map((Function1 & Serializable)line -> {
            char delimiter = StringOps$.MODULE$.count$extension(Predef$.MODULE$.augmentString(line), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CsvParser$.$anonfun$tryGuessingCsvConfig$8(BoxesRunTime.unboxToChar((Object)x$1)))) > StringOps$.MODULE$.count$extension(Predef$.MODULE$.augmentString(line), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CsvParser$.$anonfun$tryGuessingCsvConfig$9(BoxesRunTime.unboxToChar((Object)x$2)))) ? (char)';' : (char)',';
            boolean hasHeader = headers.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(line), delimiter)), (Object)x$3)));
            return new CsvParser.GuessedCsvConfig((String)line, hasHeader, delimiter);
        })));
    }

    public <A> ZIO<Object, Throwable, ZStream<Object, Throwable, A>> parseCsv(File file, CsvParser.CsvConfig config, CsvParser.Decoder<A> decoder) {
        ZManaged managedParser = ZManaged$.MODULE$.fromAutoCloseable(Task$.MODULE$.apply((Function0 & Serializable)() -> {
            CsvReader reader = new CsvReader();
            reader.setContainsHeader(config.hasHeader());
            reader.setFieldSeparator(config.delimiter());
            return reader.parse(file, StandardCharsets.UTF_8);
        }));
        ZIO checkCsv = managedParser.use((Function1 & Serializable)parser -> {
            ZIO zIO;
            CsvRow line = parser.nextRow();
            if (config.hasHeader()) {
                List foundHeaders = CollectionConverters$.MODULE$.ListHasAsScala(parser.getHeader()).asScala().toList();
                zIO = ZIO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> !config.headers().forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)foundHeaders.contains((Object)x$5))), (Function0 & Serializable)() -> Task$.MODULE$.fail((Function0 & Serializable)() -> new CsvParser.InvalidHeaders(config.headers())));
            } else {
                zIO = ZIO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> line.getFieldCount() != config.headers().length(), (Function0 & Serializable)() -> Task$.MODULE$.fail((Function0 & Serializable)() -> new CsvParser.WrongNumberOfColumns(config.headers())));
            }
            return zIO;
        });
        ZStream rstream = ZStream$.MODULE$.managed(managedParser).flatMap((Function1 & Serializable)parser -> ZStream$.MODULE$.repeatEffect(Task$.MODULE$.apply((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)parser.nextRow()))).takeWhile((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDefined())).mapM((Function1 & Serializable)row -> {
            Map data = config.hasHeader() ? CollectionConverters$.MODULE$.MapHasAsScala(((CsvRow)row.get()).getFieldMap()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()) : ((IterableOnceOps)config.headers().zip((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(((CsvRow)row.get()).getFields()).asScala())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return ZIO$.MODULE$.fromEither((Function0 & Serializable)() -> (Either)decoder.decode().apply((Object)data));
        }));
        return checkCsv.map((Function1 & Serializable)x$7 -> {
            BoxedUnit boxedUnit = x$7;
            ZStream zStream = rstream;
            return zStream;
        });
    }

    public static final /* synthetic */ boolean $anonfun$tryGuessingCsvConfig$8(char x$1) {
        return x$1 == ';';
    }

    public static final /* synthetic */ boolean $anonfun$tryGuessingCsvConfig$9(char x$2) {
        return x$2 == ',';
    }

    private CsvParser$() {
    }
}

