/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.jumpstart.helper;

import io.conduktor.jumpstart.WorkingDirectory;
import io.conduktor.jumpstart.domain.AgentProperties;
import io.conduktor.jumpstart.domain.JumpStartError;
import io.conduktor.jumpstart.domain.JumpStartError$FileSystemOperationError$;
import io.conduktor.jumpstart.helper.SafeFileOps$;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.Period;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import zio.CanFail$;
import zio.Has;
import zio.ZIO;
import zio.ZIO$;
import zio.blocking.package;
import zio.clock.package;
import zio.clock.package$;
import zio.nio.file.Files$;
import zio.nio.file.Path;

public final class ProcessUtils$ {
    public static final ProcessUtils$ MODULE$ = new ProcessUtils$();
    private static final Period RetentionDays = Period.ofDays(7);

    private final Period RetentionDays() {
        return RetentionDays;
    }

    public ZIO<Has<package.Clock.Service>, JumpStartError.FileSystemOperationError, Path> prepareLogFile(WorkingDirectory workingDirectory, String fileName) {
        return this.backupLogPath(workingDirectory, fileName).flatMap((Function1 & Serializable)backupPath -> {
            Path logPath = workingDirectory.logPath().$div(fileName);
            return MODULE$.applyRetentionLogs(workingDirectory).flatMap((Function1 & Serializable)x$2 -> {
                BoxedUnit boxedUnit = x$2;
                ZIO zIO = Files$.MODULE$.move(logPath, backupPath, (Seq)Nil$.MODULE$).ignore().flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                    ZIO zIO = SafeFileOps$.MODULE$.createFile(logPath).as((Function0 & Serializable)() -> logPath).mapError((Function1)JumpStartError$FileSystemOperationError$.MODULE$, CanFail$.MODULE$.canFail());
                    return zIO;
                });
                return zIO;
            });
        });
    }

    public String prettyPrintConfig(Path scriptPath, Path configPath, Option<Path> javaHome, AgentProperties agentProps) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(82).append("script     : ").append(scriptPath).append("\n       | config     : ").append(configPath).append("\n       | javaHome   : ").append(javaHome).append("\n       | agentProps : ").append(agentProps.toJvmArg()).toString()));
    }

    private ZIO<Has<package.Blocking.Service>, Nothing$, BoxedUnit> applyRetentionLogs(WorkingDirectory workingDirectory) {
        return ZIO$.MODULE$.service(Tag$.MODULE$.apply(package.Clock.Service.class, LightTypeTag$.MODULE$.parse(-1230456148, "\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u0017zio.clock.Clock.Service\u0001\u0002\u0003\u0000\u0000\u000fzio.clock.Clock\u0001\u0002\u0003\u0000\u0000\u0011zio.clock.package\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0002\u0003\u0000\u0000\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 21))).flatMap((Function1 & Serializable)x$4 -> x$4.instant().map((Function1 & Serializable)x$5 -> x$5.minus(MODULE$.RetentionDays()))).flatMap((Function1 & Serializable)retentionTime -> Files$.MODULE$.list(workingDirectory.logPath()).filterM((Function1 & Serializable)logPath -> Files$.MODULE$.getLastModifiedTime(logPath, (Seq)Nil$.MODULE$).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ProcessUtils$.$anonfun$applyRetentionLogs$5(retentionTime, x$6)))).foreach((Function1 & Serializable)logPath -> Files$.MODULE$.deleteIfExists(logPath))).ignore();
    }

    private ZIO<Has<package.Clock.Service>, Nothing$, Path> backupLogPath(WorkingDirectory workingDirectory, String fileName) {
        return package$.MODULE$.instant().map((Function1 & Serializable)now -> workingDirectory.logPath().$div(new StringBuilder(1).append(fileName).append(".").append(now.getEpochSecond()).toString()));
    }

    public static final /* synthetic */ boolean $anonfun$applyRetentionLogs$5(Instant retentionTime$1, FileTime x$6) {
        return x$6.toInstant().isBefore(retentionTime$1);
    }

    private ProcessUtils$() {
    }
}

