/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.util;

import com.netflix.atlas.core.util.InternMap;
import com.netflix.atlas.core.util.OpenHashInternMap$;
import com.netflix.atlas.core.util.PrimeFinder;
import com.netflix.spectator.api.Clock;
import java.io.Serializable;
import scala.Function1;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001\u0002\u000f\u001e\u0001!B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"A\u0011\n\u0001B\u0002B\u0003-!\nC\u0003V\u0001\u0011\u0005a\u000bC\u0004]\u0001\t\u0007I\u0011B/\t\ry\u0003\u0001\u0015!\u0003>\u0011\u001dy\u0006\u00011A\u0005\n\u0001Dq\u0001\u001a\u0001A\u0002\u0013%Q\r\u0003\u0004l\u0001\u0001\u0006K!\u0019\u0005\bY\u0002\u0001\r\u0011\"\u0003n\u0011\u001d\u0011\b\u00011A\u0005\nMDa!\u001e\u0001!B\u0013q\u0007b\u0002<\u0001\u0001\u0004%I!\u0018\u0005\bo\u0002\u0001\r\u0011\"\u0003y\u0011\u0019Q\b\u0001)Q\u0005{!)1\u0010\u0001C\u0005y\"1q\u0010\u0001C\u0005\u0003\u0003Aq!a\u0006\u0001\t\u0013\tI\u0002C\u0004\u0002\"\u0001!I!a\t\t\u000f\u0005%\u0002\u0001\"\u0001\u001e;\"9\u0011q\u0003\u0001\u0005\u0002\u0005-\u0002bBA\u0018\u0001\u0011\u0005\u0011\u0011\u0007\u0005\u0007\u0003o\u0001A\u0011A/\b\u0013\u0005eR$!A\t\u0002\u0005mb\u0001\u0003\u000f\u001e\u0003\u0003E\t!!\u0010\t\rUKB\u0011AA \u0011%\t\t%GI\u0001\n\u0003\t\u0019EA\tPa\u0016t\u0007*Y:i\u0013:$XM\u001d8NCBT!AH\u0010\u0002\tU$\u0018\u000e\u001c\u0006\u0003A\u0005\nAaY8sK*\u0011!eI\u0001\u0006CRd\u0017m\u001d\u0006\u0003I\u0015\nqA\\3uM2L\u0007PC\u0001'\u0003\r\u0019w.\\\u0002\u0001+\tIcgE\u0002\u0001UA\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0007cA\u00193i5\tQ$\u0003\u00024;\tI\u0011J\u001c;fe:l\u0015\r\u001d\t\u0003kYb\u0001\u0001B\u00038\u0001\t\u0007\u0001HA\u0001L#\tI$\u0006\u0005\u0002,u%\u00111\b\f\u0002\b\u001d>$\b.\u001b8h\u0003=Ig.\u001b;jC2\u001c\u0015\r]1dSRL\bCA\u0016?\u0013\tyDFA\u0002J]R\fQa\u00197pG.\u0004\"AQ$\u000e\u0003\rS!\u0001R#\u0002\u0007\u0005\u0004\u0018N\u0003\u0002GG\u0005I1\u000f]3di\u0006$xN]\u0005\u0003\u0011\u000e\u0013Qa\u00117pG.\f!\"\u001a<jI\u0016t7-\u001a\u00133!\rY%\u000b\u000e\b\u0003\u0019B\u0003\"!\u0014\u0017\u000e\u00039S!aT\u0014\u0002\rq\u0012xn\u001c;?\u0013\t\tF&\u0001\u0004Qe\u0016$WMZ\u0005\u0003'R\u0013\u0001\"T1oS\u001a,7\u000f\u001e\u0006\u0003#2\na\u0001P5oSRtDcA,[7R\u0011\u0001,\u0017\t\u0004c\u0001!\u0004\"B%\u0005\u0001\bQ\u0005\"\u0002\u001f\u0005\u0001\u0004i\u0004b\u0002!\u0005!\u0003\u0005\r!Q\u0001\u000eaJLW.Z\"ba\u0006\u001c\u0017\u000e^=\u0016\u0003u\na\u0002\u001d:j[\u0016\u001c\u0015\r]1dSRL\b%\u0001\u0003eCR\fW#A1\u0011\u0007-\u0012G'\u0003\u0002dY\t)\u0011I\u001d:bs\u0006AA-\u0019;b?\u0012*\u0017\u000f\u0006\u0002gSB\u00111fZ\u0005\u0003Q2\u0012A!\u00168ji\"9!\u000eCA\u0001\u0002\u0004\t\u0017a\u0001=%c\u0005)A-\u0019;bA\u0005QA/[7fgR\fW\u000e]:\u0016\u00039\u00042a\u000b2p!\tY\u0003/\u0003\u0002rY\t!Aj\u001c8h\u00039!\u0018.\\3ti\u0006l\u0007o]0%KF$\"A\u001a;\t\u000f)\\\u0011\u0011!a\u0001]\u0006YA/[7fgR\fW\u000e]:!\u0003-\u0019WO\u001d:f]R\u001c\u0016N_3\u0002\u001f\r,(O]3oiNK'0Z0%KF$\"AZ=\t\u000f)t\u0011\u0011!a\u0001{\u0005a1-\u001e:sK:$8+\u001b>fA\u0005!\u0001.Y:i)\tiT\u0010C\u0003\u007f!\u0001\u0007A'A\u0001l\u0003\u0019\u0011Xm]5{KR)a-a\u0001\u0002\b!1\u0011QA\tA\u0002u\n1B\\3x\u0007\u0006\u0004\u0018mY5us\"9\u0011\u0011B\tA\u0002\u0005-\u0011\u0001B6fKB\u0004baKA\u0007_\u0006E\u0011bAA\bY\tIa)\u001e8di&|g.\r\t\u0004W\u0005M\u0011bAA\u000bY\t9!i\\8mK\u0006t\u0017AB5oi\u0016\u0014h\u000eF\u00035\u00037\ti\u0002C\u0003\u007f%\u0001\u0007A\u0007\u0003\u0004\u0002 I\u0001\ra\\\u0001\u0002i\u0006aa.\u001a=u\u0007\u0006\u0004\u0018mY5usR\u0019Q(!\n\t\r\u0005\u001d2\u00031\u0001>\u0003\t\u0019(0\u0001\u0005dCB\f7-\u001b;z)\r!\u0014Q\u0006\u0005\u0006}V\u0001\r\u0001N\u0001\u0007e\u0016$\u0018-\u001b8\u0015\u0007\u0019\f\u0019\u0004C\u0004\u00026Y\u0001\r!a\u0003\u0002\u0003\u0019\fAa]5{K\u0006\tr\n]3o\u0011\u0006\u001c\b.\u00138uKJtW*\u00199\u0011\u0005EJ2CA\r+)\t\tY$A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0005\u0003\u000b\nY&\u0006\u0002\u0002H)\u001a\u0011)!\u0013,\u0005\u0005-\u0003\u0003BA'\u0003/j!!a\u0014\u000b\t\u0005E\u00131K\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0016-\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\nyEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$QaN\u000eC\u0002a\u0002")
public class OpenHashInternMap<K>
implements InternMap<K> {
    private final Clock clock;
    private final Manifest<K> evidence$2;
    private final int primeCapacity;
    private K[] data;
    private long[] timestamps;
    private int currentSize;

    public static <K> Clock $lessinit$greater$default$2() {
        return OpenHashInternMap$.MODULE$.$lessinit$greater$default$2();
    }

    private int primeCapacity() {
        return this.primeCapacity;
    }

    private K[] data() {
        return this.data;
    }

    private void data_$eq(K[] x$1) {
        this.data = x$1;
    }

    private long[] timestamps() {
        return this.timestamps;
    }

    private void timestamps_$eq(long[] x$1) {
        this.timestamps = x$1;
    }

    private int currentSize() {
        return this.currentSize;
    }

    private void currentSize_$eq(int x$1) {
        this.currentSize = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private int hash(K k) {
        void var2_2;
        int h = k.hashCode() % this.data().length;
        return h < 0 ? -h : var2_2;
    }

    private void resize(int newCapacity, Function1<Object, Object> keep) {
        K[] oldData = this.data();
        long[] oldTimestamps = this.timestamps();
        this.currentSize_$eq(0);
        this.data_$eq((Object[])this.evidence$2.newArray(newCapacity));
        this.timestamps_$eq(new long[newCapacity]);
        for (int i = 0; i < oldData.length; ++i) {
            Object object = oldData[i] != null && keep.apply$mcZJ$sp(oldTimestamps[i]) ? this.intern(oldData[i], oldTimestamps[i]) : BoxedUnit.UNIT;
        }
    }

    private K intern(K k, long t) {
        int h;
        for (int i = h = this.hash(k); i < h + this.data().length; ++i) {
            int j = i % this.data().length;
            if (this.data()[j] == null) {
                this.currentSize_$eq(this.currentSize() + 1);
                this.data()[j] = k;
                this.timestamps()[j] = t;
                return k;
            }
            if (!BoxesRunTime.equals(this.data()[j], k)) continue;
            this.timestamps()[j] = t;
            return this.data()[j];
        }
        throw new IllegalStateException("failed to add entry to map");
    }

    private int nextCapacity(int sz) {
        return PrimeFinder.nextPrime(sz);
    }

    public int capacity() {
        return this.data().length;
    }

    @Override
    public K intern(K k) {
        block0: {
            if (this.currentSize() + 1 <= 3 * this.data().length / 4) break block0;
            this.resize(this.nextCapacity(2 * this.data().length), (Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable)x$1 -> true);
        }
        return this.intern(k, this.clock.wallTime());
    }

    @Override
    public void retain(Function1<Object, Object> f) {
        this.resize(this.data().length, f);
    }

    @Override
    public int size() {
        return this.currentSize();
    }

    public OpenHashInternMap(int initialCapacity, Clock clock, Manifest<K> evidence$2) {
        this.clock = clock;
        this.evidence$2 = evidence$2;
        this.primeCapacity = this.nextCapacity(initialCapacity);
        this.data = (Object[])evidence$2.newArray(this.primeCapacity());
        this.timestamps = new long[this.primeCapacity()];
        this.currentSize = 0;
    }
}

