/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.model;

import com.netflix.atlas.core.model.EvalContext$;
import com.netflix.atlas.core.model.StatefulExpr;
import com.netflix.atlas.core.model.TimeSeries;
import com.netflix.atlas.core.model.TimeSeries$;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001\u0002\u0015*\u0001RB\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000b\u0001BK\u0002\u0013\u00051\n\u0003\u0005R\u0001\tE\t\u0015!\u0003M\u0011!\u0011\u0006A!f\u0001\n\u0003Y\u0005\u0002C*\u0001\u0005#\u0005\u000b\u0011\u0002'\t\u0011Q\u0003!Q3A\u0005\u0002UC\u0001\"\u001a\u0001\u0003\u0012\u0003\u0006IA\u0016\u0005\u0006M\u0002!\ta\u001a\u0005\b[\u0002\u0011\r\u0011\"\u0001o\u0011\u0019\u0011\b\u0001)A\u0005_\")1\u000f\u0001C\u0001i\")\u0001\u0010\u0001C\u0001s\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u000e\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011%\t)\u0003AA\u0001\n\u0003\t9\u0003C\u0005\u00022\u0001\t\n\u0011\"\u0001\u00024!I\u0011\u0011\n\u0001\u0012\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003\u0017\u0002\u0011\u0013!C\u0001\u0003gA\u0011\"!\u0014\u0001#\u0003%\t!a\u0014\t\u0013\u0005M\u0003!!A\u0005B\u0005U\u0003\u0002CA2\u0001\u0005\u0005I\u0011\u0001;\t\u0013\u0005\u0015\u0004!!A\u0005\u0002\u0005\u001d\u0004\"CA7\u0001\u0005\u0005I\u0011IA8\u0011%\ti\bAA\u0001\n\u0003\ty\bC\u0005\u0002\n\u0002\t\t\u0011\"\u0011\u0002\f\"I\u0011q\u0012\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0013\u0005\n\u0003'\u0003\u0011\u0011!C!\u0003+C\u0011\"a&\u0001\u0003\u0003%\t%!'\b\u0013\u0005u\u0015&!A\t\u0002\u0005}e\u0001\u0003\u0015*\u0003\u0003E\t!!)\t\r\u0019\u0004C\u0011AA]\u0011%\t\u0019\nIA\u0001\n\u000b\n)\nC\u0005\u0002<\u0002\n\t\u0011\"!\u0002>\"I\u0011q\u0019\u0011\u0012\u0002\u0013\u0005\u0011q\n\u0005\n\u0003\u0013\u0004\u0013\u0011!CA\u0003\u0017D\u0011\"!8!#\u0003%\t!a\u0014\t\u0013\u0005}\u0007%!A\u0005\n\u0005\u0005(aC#wC2\u001cuN\u001c;fqRT!AK\u0016\u0002\u000b5|G-\u001a7\u000b\u00051j\u0013\u0001B2pe\u0016T!AL\u0018\u0002\u000b\u0005$H.Y:\u000b\u0005A\n\u0014a\u00028fi\u001ad\u0017\u000e\u001f\u0006\u0002e\u0005\u00191m\\7\u0004\u0001M!\u0001!N\u001e?!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0019\te.\u001f*fMB\u0011a\u0007P\u0005\u0003{]\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002@\u000f:\u0011\u0001)\u0012\b\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007N\na\u0001\u0010:p_Rt\u0014\"\u0001\u001d\n\u0005\u0019;\u0014a\u00029bG.\fw-Z\u0005\u0003\u0011&\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!AR\u001c\u0002\u000bM$\u0018M\u001d;\u0016\u00031\u0003\"AN'\n\u00059;$\u0001\u0002'p]\u001e\faa\u001d;beR\u0004\u0013aA3oI\u0006!QM\u001c3!\u0003\u0011\u0019H/\u001a9\u0002\u000bM$X\r\u001d\u0011\u0002\u000bM$\u0018\r^3\u0016\u0003Y\u0003BaV._E:\u0011\u0001,\u0017\t\u0003\u0003^J!AW\u001c\u0002\rA\u0013X\rZ3g\u0013\taVLA\u0002NCBT!AW\u001c\u0011\u0005}\u0003W\"A\u0015\n\u0005\u0005L#\u0001D*uCR,g-\u001e7FqB\u0014\bC\u0001\u001cd\u0013\t!wGA\u0002B]f\faa\u001d;bi\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0003iS*\\G\u000e\u0005\u0002`\u0001!)!*\u0003a\u0001\u0019\")\u0001+\u0003a\u0001\u0019\")!+\u0003a\u0001\u0019\"9A+\u0003I\u0001\u0002\u00041\u0016A\u00028p\t\u0006$\u0018-F\u0001p!\ty\u0006/\u0003\u0002rS\tQA+[7f'\u0016\u0014\u0018.Z:\u0002\u000f9|G)\u0019;bA\u0005Q!-\u001e4gKJ\u001c\u0016N_3\u0016\u0003U\u0004\"A\u000e<\n\u0005]<$aA%oi\u0006I\u0001/\u0019:uSRLwN\u001c\u000b\u0004uv|\bcA |Q&\u0011A0\u0013\u0002\u0005\u0019&\u001cH\u000fC\u0003\u007f\u001b\u0001\u0007A*A\u0004p]\u0016\u001cF/\u001a9\t\u000f\u0005\u0005Q\u00021\u0001\u0002\u0004\u0005!QO\\5u!\u0011\t)!a\u0005\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\t\u0001\u0002^3na>\u0014\u0018\r\u001c\u0006\u0005\u0003\u001b\ty!\u0001\u0003uS6,'BAA\t\u0003\u0011Q\u0017M^1\n\t\u0005U\u0011q\u0001\u0002\u000b\u0007\"\u0014xN\\8V]&$\u0018a\u00049beRLG/[8o\u0005fDu.\u001e:\u0016\u0003i\fa\u0002]1si&$\u0018n\u001c8Cs\u0012\u000b\u00170\u0001\u0006xSRDwJ\u001a4tKR$2\u0001[A\u0011\u0011\u0019\t\u0019\u0003\u0005a\u0001\u0019\u00061qN\u001a4tKR\fAaY8qsRI\u0001.!\u000b\u0002,\u00055\u0012q\u0006\u0005\b\u0015F\u0001\n\u00111\u0001M\u0011\u001d\u0001\u0016\u0003%AA\u00021CqAU\t\u0011\u0002\u0003\u0007A\nC\u0004U#A\u0005\t\u0019\u0001,\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0007\u0016\u0004\u0019\u0006]2FAA\u001d!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\rs'\u0001\u0006b]:|G/\u0019;j_:LA!a\u0012\u0002>\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003#R3AVA\u001c\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u000b\t\u0005\u00033\ny&\u0004\u0002\u0002\\)!\u0011QLA\b\u0003\u0011a\u0017M\\4\n\t\u0005\u0005\u00141\f\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019!-!\u001b\t\u0011\u0005-\u0004$!AA\u0002U\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA9!\u0015\t\u0019(!\u001fc\u001b\t\t)HC\u0002\u0002x]\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY(!\u001e\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0003\u000b9\tE\u00027\u0003\u0007K1!!\"8\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u001b\u001b\u0003\u0003\u0005\rAY\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002X\u00055\u0005\u0002CA67\u0005\u0005\t\u0019A;\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!^\u0001\ti>\u001cFO]5oOR\u0011\u0011qK\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0005\u00151\u0014\u0005\t\u0003Wr\u0012\u0011!a\u0001E\u0006YQI^1m\u0007>tG/\u001a=u!\ty\u0006eE\u0003!\u0003G\u000by\u000bE\u0005\u0002&\u0006-F\n\u0014'WQ6\u0011\u0011q\u0015\u0006\u0004\u0003S;\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003[\u000b9KA\tBEN$(/Y2u\rVt7\r^5p]R\u0002B!!-\u000286\u0011\u00111\u0017\u0006\u0005\u0003k\u000by!\u0001\u0002j_&\u0019\u0001*a-\u0015\u0005\u0005}\u0015!B1qa2LH#\u00035\u0002@\u0006\u0005\u00171YAc\u0011\u0015Q5\u00051\u0001M\u0011\u0015\u00016\u00051\u0001M\u0011\u0015\u00116\u00051\u0001M\u0011\u001d!6\u0005%AA\u0002Y\u000bq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti-!7\u0011\u000bY\ny-a5\n\u0007\u0005EwG\u0001\u0004PaRLwN\u001c\t\bm\u0005UG\n\u0014'W\u0013\r\t9n\u000e\u0002\u0007)V\u0004H.\u001a\u001b\t\u0011\u0005mW%!AA\u0002!\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u00111\u001d\t\u0005\u00033\n)/\u0003\u0003\u0002h\u0006m#AB(cU\u0016\u001cG\u000f")
public class EvalContext
implements Product,
Serializable {
    private final long start;
    private final long end;
    private final long step;
    private final Map<StatefulExpr, Object> state;
    private final TimeSeries noData;

    public static Map<StatefulExpr, Object> $lessinit$greater$default$4() {
        return EvalContext$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Object, Object, Object, Map<StatefulExpr, Object>>> unapply(EvalContext evalContext) {
        return EvalContext$.MODULE$.unapply(evalContext);
    }

    public static Map<StatefulExpr, Object> apply$default$4() {
        return EvalContext$.MODULE$.apply$default$4();
    }

    public static EvalContext apply(long l, long l2, long l3, Map<StatefulExpr, Object> map) {
        return EvalContext$.MODULE$.apply(l, l2, l3, map);
    }

    public static Function1<Tuple4<Object, Object, Object, Map<StatefulExpr, Object>>, EvalContext> tupled() {
        return EvalContext$.MODULE$.tupled();
    }

    public static Function1<Object, Function1<Object, Function1<Object, Function1<Map<StatefulExpr, Object>, EvalContext>>>> curried() {
        return EvalContext$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public long step() {
        return this.step;
    }

    public Map<StatefulExpr, Object> state() {
        return this.state;
    }

    public TimeSeries noData() {
        return this.noData;
    }

    public int bufferSize() {
        return (int)((this.end() - this.start()) / this.step()) + 1;
    }

    public List<EvalContext> partition(long oneStep, ChronoUnit unit) {
        Builder builder = List$.MODULE$.newBuilder();
        long t = Instant.ofEpochMilli(this.start()).truncatedTo(unit).toEpochMilli();
        while (t < this.end()) {
            long e = t + oneStep;
            long stime = package$.MODULE$.max(t, this.start());
            long etime = package$.MODULE$.min(e, this.end());
            builder.$plus$eq((Object)new EvalContext(stime, etime, this.step(), EvalContext$.MODULE$.apply$default$4()));
            t = e;
        }
        return (List)builder.result();
    }

    public List<EvalContext> partitionByHour() {
        return this.partition(Duration.ofHours(1L).toMillis(), ChronoUnit.HOURS);
    }

    public List<EvalContext> partitionByDay() {
        return this.partition(Duration.ofDays(1L).toMillis(), ChronoUnit.DAYS);
    }

    public EvalContext withOffset(long offset) {
        long dur = offset / this.step() * this.step();
        return dur < this.step() ? this : new EvalContext(this.start() - dur, this.end() - dur, this.step(), this.state());
    }

    public EvalContext copy(long start, long end, long step, Map<StatefulExpr, Object> state) {
        return new EvalContext(start, end, step, state);
    }

    public long copy$default$1() {
        return this.start();
    }

    public long copy$default$2() {
        return this.end();
    }

    public long copy$default$3() {
        return this.step();
    }

    public Map<StatefulExpr, Object> copy$default$4() {
        return this.state();
    }

    public String productPrefix() {
        return "EvalContext";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToLong((long)this.start());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToLong((long)this.end());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToLong((long)this.step());
                break;
            }
            case 3: {
                object = this.state();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EvalContext;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "start";
                break;
            }
            case 1: {
                string = "end";
                break;
            }
            case 2: {
                string = "step";
                break;
            }
            case 3: {
                string = "state";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.start()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.end()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.step()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.state()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EvalContext)) return false;
        boolean bl = true;
        if (!bl) return false;
        EvalContext evalContext = (EvalContext)x$1;
        if (this.start() != evalContext.start()) return false;
        if (this.end() != evalContext.end()) return false;
        if (this.step() != evalContext.step()) return false;
        Map<StatefulExpr, Object> map = this.state();
        Map<StatefulExpr, Object> map2 = evalContext.state();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!evalContext.canEqual(this)) return false;
        return true;
    }

    public EvalContext(long start, long end, long step, Map<StatefulExpr, Object> state) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.state = state;
        Product.$init$((Product)this);
        Predef$.MODULE$.require(start < end, (Function0 & Serializable)() -> new StringBuilder(44).append("start time must be less than end time (").append(this.start()).append(" >= ").append(this.end()).append(")").toString());
        this.noData = TimeSeries$.MODULE$.noData(step);
    }
}

