/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.index;

import com.netflix.atlas.core.index.QueryIndex;
import com.netflix.atlas.core.model.Query;
import com.netflix.atlas.core.model.Query$;
import com.netflix.atlas.core.model.Query$True$;
import com.netflix.atlas.core.util.SmallHashMap;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.AnyRefMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class QueryIndex$
implements Serializable {
    public static final QueryIndex$ MODULE$ = new QueryIndex$();

    public QueryIndex<Query> apply(List<Query> queries) {
        return this.create(queries.map((Function1 & Serializable)q -> new QueryIndex.Entry<Query>((Query)q, (Query)q)));
    }

    public <T> QueryIndex<T> create(List<QueryIndex.Entry<T>> entries) {
        List annotated = entries.flatMap((Function1 & Serializable)entry -> {
            List qs = Query$.MODULE$.dnfList(entry.query()).flatMap((Function1 & Serializable)q -> Query$.MODULE$.expandInClauses((Query)q, Query$.MODULE$.expandInClauses$default$2()));
            return qs.map((Function1 & Serializable)q -> MODULE$.annotate(new QueryIndex.Entry((Query)q, entry.value())));
        });
        AnyRefMap idxMap = new AnyRefMap();
        return this.createImpl(idxMap, annotated);
    }

    private <T> QueryIndex<T> createImpl(AnyRefMap<Object, QueryIndex<T>> idxMap, List<QueryIndex.AnnotatedEntry<T>> entries) {
        QueryIndex<T> queryIndex;
        Option option = idxMap.get(entries);
        if (option instanceof Some) {
            QueryIndex<T> idx;
            Some some = (Some)option;
            queryIndex = idx = (QueryIndex<T>)some.value();
        } else if (None$.MODULE$.equals(option)) {
            Tuple2 tuple2 = entries.partition((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)QueryIndex$.$anonfun$createImpl$1(x$1)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List children = (List)tuple2._1();
            List leaf = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)children, (Object)leaf);
            Tuple2 tuple23 = tuple22;
            List children2 = (List)tuple23._1();
            List leaf2 = (List)tuple23._2();
            Map trees = (Map)children2.flatMap((Function1 & Serializable)x$3 -> x$3.toList()).groupBy((Function1 & Serializable)x$4 -> (Query.Equal)x$4._1()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Query.Equal q = (Query.Equal)tuple2._1();
                List ts = (List)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)q), MODULE$.createImpl(idxMap, ts.map((Function1 & Serializable)x$5 -> (QueryIndex.AnnotatedEntry)x$5._2())));
                return tuple22;
            });
            QueryIndex<T> idx = new QueryIndex<T>(this.smallMap(trees), (QueryIndex.Entry[])leaf2.map((Function1 & Serializable)x$6 -> x$6.entry()).toArray(ClassTag$.MODULE$.apply(QueryIndex.Entry.class)));
            idxMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entries), idx));
            queryIndex = idx;
        } else {
            throw new MatchError((Object)option);
        }
        return queryIndex;
    }

    private <T> Map<Query.Equal, QueryIndex<T>> smallMap(Map<Query.Equal, QueryIndex<T>> m) {
        Map<Query.Equal, QueryIndex<T>> map;
        if (m.size() <= 4) {
            map = m;
        } else {
            int size = m.size() * 2;
            SmallHashMap.Builder<Query.Equal, QueryIndex<T>> builder = new SmallHashMap.Builder<Query.Equal, QueryIndex<T>>(size);
            builder.addAll(m);
            SmallHashMap<Query.Equal, QueryIndex<T>> sm = builder.result();
            map = sm;
        }
        return map;
    }

    private List<Query> conjunctionList(Query query) {
        List list;
        Query query2 = query;
        if (query2 instanceof Query.And) {
            Query.And and = (Query.And)query2;
            Query q1 = and.q1();
            Query q2 = and.q2();
            List<Query> list2 = this.conjunctionList(q1);
            list = this.conjunctionList(q2).$colon$colon$colon(list2);
        } else {
            list = (List)new .colon.colon((Object)query2, (List)Nil$.MODULE$);
        }
        return list;
    }

    private <T> QueryIndex.AnnotatedEntry<T> annotate(QueryIndex.Entry<T> entry) {
        List distinct = (List)this.conjunctionList(entry.query()).distinct();
        List filters = distinct.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Query, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Query.Equal) {
                    Query.Equal equal = (Query.Equal)A1;
                    object = equal;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Query x1) {
                Query query = x1;
                boolean bl = query instanceof Query.Equal;
                return bl;
            }
        });
        List remainder = distinct.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Query, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = !(A1 instanceof Query.Equal) ? A1 : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Query x2) {
                Query query = x2;
                boolean bl = !(query instanceof Query.Equal);
                return bl;
            }
        });
        Query$True$ remainderQ = remainder.isEmpty() ? Query$True$.MODULE$ : (Query)remainder.reduce((Function2 & Serializable)(a, b) -> new Query.And((Query)a, (Query)b));
        return new QueryIndex.AnnotatedEntry<T>(new QueryIndex.Entry<T>(remainderQ, entry.value()), (Set<Query.Equal>)filters.toSet());
    }

    public <T> QueryIndex<T> apply(Map<Query.Equal, QueryIndex<T>> indexes, QueryIndex.Entry<T>[] entries) {
        return new QueryIndex<T>(indexes, entries);
    }

    public <T> Option<Tuple2<Map<Query.Equal, QueryIndex<T>>, QueryIndex.Entry<T>[]>> unapply(QueryIndex<T> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.indexes(), x$0.entries()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(QueryIndex$.class);
    }

    public static final /* synthetic */ boolean $anonfun$createImpl$1(QueryIndex.AnnotatedEntry x$1) {
        return x$1.filters().nonEmpty();
    }

    private QueryIndex$() {
    }
}

