/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.index;

import com.netflix.atlas.core.index.BatchUpdateTagIndex$;
import com.netflix.atlas.core.index.MutableTagIndex;
import com.netflix.atlas.core.index.TagIndex;
import com.netflix.atlas.core.index.TagQuery;
import com.netflix.atlas.core.index.TagQuery$;
import com.netflix.atlas.core.model.Query;
import com.netflix.atlas.core.model.Tag;
import com.netflix.atlas.core.model.TaggedItem;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.patterns.LongTaskTimer;
import com.netflix.spectator.api.patterns.PolledMeter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Mv!\u0002\u000f\u001e\u0011\u0003Ac!\u0002\u0016\u001e\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004\"\u0002\u001b\u0002\t\u0003)d\u0001\u0002\u0016\u001e\u0001eB\u0001\u0002\u0014\u0003\u0003\u0002\u0003\u0006I!\u0014\u0005\t+\u0012\u0011\t\u0011)A\u0005-\"Aq\f\u0002B\u0002B\u0003-\u0001\rC\u00033\t\u0011\u0005a\rC\u0004m\t\t\u0007I\u0011B7\t\ri$\u0001\u0015!\u0003o\u0011\u001dYHA1A\u0005\nqDq!!\u0001\u0005A\u0003%Q\u0010C\u0005\u0002\u0004\u0011\u0011\r\u0011\"\u0003\u0002\u0006!A\u0011q\u0002\u0003!\u0002\u0013\t9\u0001C\u0005\u0002\u0012\u0011\u0011\r\u0011\"\u0003\u0002\u0014!A\u0011\u0011\u0005\u0003!\u0002\u0013\t)\u0002C\u0004\u0002$\u0011!\t!!\n\t\u000f\u00055B\u0001\"\u0001\u00020!9\u0011q\u0007\u0003\u0005\u0002\u0005e\u0002bBA\u001c\t\u0011\u0005\u0011\u0011\t\u0005\b\u0003?\"A\u0011AA1\u0011\u001d\ty\u0006\u0002C\u0001\u0003OBq!a\u001b\u0005\t\u0003\ti\u0007C\u0004\u0002\u0002\u0012!\t!a!\t\u000f\u0005eE\u0001\"\u0001\u0002\u001c\"9\u0011q\u0014\u0003\u0005\u0002\u0005\u0005\u0006bBAS\t\u0011\u0005\u0011qF\u0001\u0014\u0005\u0006$8\r[+qI\u0006$X\rV1h\u0013:$W\r\u001f\u0006\u0003=}\tQ!\u001b8eKbT!\u0001I\u0011\u0002\t\r|'/\u001a\u0006\u0003E\r\nQ!\u0019;mCNT!\u0001J\u0013\u0002\u000f9,GO\u001a7jq*\ta%A\u0002d_6\u001c\u0001\u0001\u0005\u0002*\u00035\tQDA\nCCR\u001c\u0007.\u00169eCR,G+Y4J]\u0012,\u0007p\u0005\u0002\u0002YA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0015\u0002\u001f9,wOU8be&tw-\u00138eKb,2ANAU)\r9\u0014\u0011\u0017\u000b\u0004q\u0005-\u0006\u0003B\u0015\u0005\u0003O+\"A\u000f!\u0014\u0007\u0011a3\bE\u0002*yyJ!!P\u000f\u0003\u001f5+H/\u00192mKR\u000bw-\u00138eKb\u0004\"a\u0010!\r\u0001\u0011)\u0011\t\u0002b\u0001\u0005\n\tA+\u0005\u0002D\rB\u0011Q\u0006R\u0005\u0003\u000b:\u0012qAT8uQ&tw\r\u0005\u0002H\u00156\t\u0001J\u0003\u0002J?\u0005)Qn\u001c3fY&\u00111\n\u0013\u0002\u000b)\u0006<w-\u001a3Ji\u0016l\u0017\u0001\u0003:fO&\u001cHO]=\u0011\u00059\u001bV\"A(\u000b\u0005A\u000b\u0016aA1qS*\u0011!kI\u0001\ngB,7\r^1u_JL!\u0001V(\u0003\u0011I+w-[:uef\f\u0001B\\3x\u0013:$W\r\u001f\t\u0005[]KF,\u0003\u0002Y]\tIa)\u001e8di&|g.\r\t\u0004[is\u0014BA./\u0005\u0015\t%O]1z!\rISLP\u0005\u0003=v\u0011\u0001\u0002V1h\u0013:$W\r_\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004cA1e}5\t!M\u0003\u0002d]\u00059!/\u001a4mK\u000e$\u0018BA3c\u0005!\u0019E.Y:t)\u0006<GcA4kWR\u0011\u0001.\u001b\t\u0004S\u0011q\u0004\"B0\t\u0001\b\u0001\u0007\"\u0002'\t\u0001\u0004i\u0005\"B+\t\u0001\u00041\u0016\u0001D2veJ,g\u000e^%oI\u0016DX#\u00018\u0011\u0007=DH,D\u0001q\u0015\t\t(/\u0001\u0004bi>l\u0017n\u0019\u0006\u0003gR\f!bY8oGV\u0014(/\u001a8u\u0015\t)h/\u0001\u0003vi&d'\"A<\u0002\t)\fg/Y\u0005\u0003sB\u0014q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-Z\u0001\u000eGV\u0014(/\u001a8u\u0013:$W\r\u001f\u0011\u0002\u001f1\f7\u000f\u001e*fEVLG\u000e\u001a+j[\u0016,\u0012! \t\u0003_zL!a 9\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\tmCN$(+\u001a2vS2$G+[7fA\u0005q\u0001/\u001a8eS:<W\u000b\u001d3bi\u0016\u001cXCAA\u0004!\u0015\tI!a\u0003?\u001b\u0005\u0011\u0018bAA\u0007e\n\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vK\u0006y\u0001/\u001a8eS:<W\u000b\u001d3bi\u0016\u001c\b%\u0001\u0007sK\n,\u0018\u000e\u001c3US6,'/\u0006\u0002\u0002\u0016A!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001c=\u000b\u0001\u0002]1ui\u0016\u0014hn]\u0005\u0005\u0003?\tIBA\u0007M_:<G+Y:l)&lWM]\u0001\u000ee\u0016\u0014W/\u001b7e)&lWM\u001d\u0011\u0002\u0013\t,\u0018\u000e\u001c3US6,WCAA\u0014!\ri\u0013\u0011F\u0005\u0004\u0003Wq#\u0001\u0002'p]\u001e\f!B\\;n!\u0016tG-\u001b8h+\t\t\t\u0004E\u0002.\u0003gI1!!\u000e/\u0005\rIe\u000e^\u0001\re\u0016\u0014W/\u001b7e\u0013:$W\r\u001f\u000b\u0003\u0003w\u00012!LA\u001f\u0013\r\tyD\f\u0002\u0005+:LG\u000f\u0006\u0003\u0002<\u0005\r\u0003bBA#)\u0001\u0007\u0011qI\u0001\u0006SR,Wn\u001d\t\u0006\u0003\u0013\nIF\u0010\b\u0005\u0003\u0017\n)F\u0004\u0003\u0002N\u0005MSBAA(\u0015\r\t\tfJ\u0001\u0007yI|w\u000e\u001e \n\u0003=J1!a\u0016/\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0017\u0002^\t!A*[:u\u0015\r\t9FL\u0001\u0007kB$\u0017\r^3\u0015\t\u0005m\u00121\r\u0005\u0007\u0003K*\u0002\u0019\u0001 \u0002\t%$X-\u001c\u000b\u0005\u0003w\tI\u0007C\u0004\u0002FY\u0001\r!a\u0012\u0002\u0011\u0019Lg\u000e\u001a+bON$B!a\u001c\u0002xA1\u0011\u0011JA-\u0003c\u00022aRA:\u0013\r\t)\b\u0013\u0002\u0004)\u0006<\u0007bBA=/\u0001\u0007\u00111P\u0001\u0006cV,'/\u001f\t\u0004S\u0005u\u0014bAA@;\tAA+Y4Rk\u0016\u0014\u00180\u0001\u0005gS:$7*Z=t)\u0011\t))a&\u0011\r\u0005%\u0013\u0011LAD!\u0011\tI)!%\u000f\t\u0005-\u0015Q\u0012\t\u0004\u0003\u001br\u0013bAAH]\u00051\u0001K]3eK\u001aLA!a%\u0002\u0016\n11\u000b\u001e:j]\u001eT1!a$/\u0011\u001d\tI\b\u0007a\u0001\u0003w\n!BZ5oIZ\u000bG.^3t)\u0011\t))!(\t\u000f\u0005e\u0014\u00041\u0001\u0002|\u0005Ia-\u001b8e\u0013R,Wn\u001d\u000b\u0005\u0003\u000f\n\u0019\u000bC\u0004\u0002zi\u0001\r!a\u001f\u0002\tML'0\u001a\t\u0004\u007f\u0005%F!B!\u0004\u0005\u0004\u0011\u0005\"CAW\u0007\u0005\u0005\t9AAX\u0003))g/\u001b3f]\u000e,G%\r\t\u0005C\u0012\f9\u000bC\u0003M\u0007\u0001\u0007Q\n")
public class BatchUpdateTagIndex<T extends TaggedItem>
implements MutableTagIndex<T> {
    private final Function1<T[], TagIndex<T>> newIndex;
    private final ClassTag<T> evidence$2;
    private final AtomicReference<TagIndex<T>> currentIndex;
    private final AtomicLong lastRebuildTime;
    private final LinkedBlockingQueue<T> pendingUpdates;
    private final LongTaskTimer rebuildTimer;

    public static <T extends TaggedItem> BatchUpdateTagIndex<T> newRoaringIndex(Registry registry, ClassTag<T> classTag) {
        return BatchUpdateTagIndex$.MODULE$.newRoaringIndex(registry, classTag);
    }

    private AtomicReference<TagIndex<T>> currentIndex() {
        return this.currentIndex;
    }

    private AtomicLong lastRebuildTime() {
        return this.lastRebuildTime;
    }

    private LinkedBlockingQueue<T> pendingUpdates() {
        return this.pendingUpdates;
    }

    private LongTaskTimer rebuildTimer() {
        return this.rebuildTimer;
    }

    public long buildTime() {
        return this.lastRebuildTime().get();
    }

    public int numPending() {
        return this.pendingUpdates().size();
    }

    public void rebuildIndex() {
        long timerId = this.rebuildTimer().start();
        try {
            int size = this.pendingUpdates().size();
            ArrayList<TaggedItem> updates = new ArrayList<TaggedItem>(size);
            this.pendingUpdates().drainTo(updates, size);
            HashMap items = new HashMap();
            updates.forEach(i -> items.put(i.id(), i));
            List matches = this.currentIndex().get().findItems(new TagQuery((Option<Query>)None$.MODULE$, TagQuery$.MODULE$.apply$default$2(), TagQuery$.MODULE$.apply$default$3(), TagQuery$.MODULE$.apply$default$4())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BatchUpdateTagIndex.$anonfun$rebuildIndex$2(x$1)));
            matches.foreach((Function1 & Serializable)i -> items.put(i.id(), i));
            this.rebuildIndex(((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(items.values()).asScala()).toList());
        }
        finally {
            this.rebuildTimer().stop(timerId);
        }
    }

    public void rebuildIndex(List<T> items) {
        this.currentIndex().set((TagIndex<T>)this.newIndex.apply(items.toArray(this.evidence$2)));
        this.lastRebuildTime().set(System.currentTimeMillis());
    }

    public void update(T item) {
        this.pendingUpdates().add(item);
    }

    @Override
    public void update(List<T> items) {
        items.foreach((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)BatchUpdateTagIndex.$anonfun$update$1(this, i)));
    }

    @Override
    public List<Tag> findTags(TagQuery query) {
        return this.currentIndex().get().findTags(query);
    }

    @Override
    public List<String> findKeys(TagQuery query) {
        return this.currentIndex().get().findKeys(query);
    }

    @Override
    public List<String> findValues(TagQuery query) {
        return this.currentIndex().get().findValues(query);
    }

    @Override
    public List<T> findItems(TagQuery query) {
        return this.currentIndex().get().findItems(query);
    }

    @Override
    public int size() {
        return this.currentIndex().get().size();
    }

    public static final /* synthetic */ boolean $anonfun$rebuildIndex$2(TaggedItem x$1) {
        return !x$1.isExpired();
    }

    public static final /* synthetic */ boolean $anonfun$update$1(BatchUpdateTagIndex $this, TaggedItem i) {
        return $this.pendingUpdates().add(i);
    }

    public BatchUpdateTagIndex(Registry registry, Function1<T[], TagIndex<T>> newIndex, ClassTag<T> evidence$2) {
        this.newIndex = newIndex;
        this.evidence$2 = evidence$2;
        this.currentIndex = new AtomicReference<Object>(newIndex.apply(Array$.MODULE$.empty(evidence$2)));
        this.lastRebuildTime = new AtomicLong(0L);
        this.pendingUpdates = (LinkedBlockingQueue)((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("atlas.index.pendingUpdates")).monitorSize(new LinkedBlockingQueue());
        this.rebuildTimer = LongTaskTimer.get((Registry)registry, (Id)registry.createId("atlas.index.rebuildTime"));
    }
}

