/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cytodynamics.nucleus;

import com.linkedin.cytodynamics.nucleus.LogAdapter;
import com.linkedin.cytodynamics.nucleus.Logger;
import org.slf4j.LoggerFactory;

class SLF4jLogAdapter
implements LogAdapter {
    SLF4jLogAdapter() {
    }

    static boolean isAvailable() {
        try {
            Class<?> ignored = Class.forName("org.slf4j.Logger");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public Logger getLogger(String loggerName) {
        return new SLF4JLogger(LoggerFactory.getLogger((String)loggerName));
    }

    static class SLF4JLogger
    implements Logger {
        private org.slf4j.Logger impl;

        @Override
        public void info(String message) {
            this.impl.info(message);
        }

        @Override
        public void warn(String message) {
            this.impl.warn(message);
        }

        @Override
        public void error(String message) {
            this.impl.error(message);
        }

        public SLF4JLogger(org.slf4j.Logger impl) {
            this.impl = impl;
        }
    }
}

