/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cytodynamics.nucleus;

import com.linkedin.cytodynamics.exception.InvalidBuilderParametersException;
import com.linkedin.cytodynamics.exception.OriginValidationException;
import com.linkedin.cytodynamics.nucleus.DelegateRelationship;
import com.linkedin.cytodynamics.nucleus.IsolatingClassLoader;
import com.linkedin.cytodynamics.nucleus.OriginRestriction;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public final class LoaderBuilder {
    private final List<URI> classpath = new ArrayList<URI>();
    private OriginRestriction originRestriction = null;
    private DelegateRelationship parentRelationship = null;
    private final List<DelegateRelationship> fallbackDelegates = new ArrayList<DelegateRelationship>();

    private LoaderBuilder() {
    }

    public static LoaderBuilder anIsolatingLoader() {
        return new LoaderBuilder();
    }

    public LoaderBuilder withClasspath(List<URI> classpath) {
        this.classpath.addAll(classpath);
        return this;
    }

    public LoaderBuilder withOriginRestriction(OriginRestriction originRestriction) {
        this.originRestriction = originRestriction;
        return this;
    }

    public LoaderBuilder withParentRelationship(DelegateRelationship parentRelationship) {
        this.parentRelationship = parentRelationship;
        return this;
    }

    public LoaderBuilder addFallbackDelegate(DelegateRelationship fallbackDelegate) {
        this.fallbackDelegates.add(fallbackDelegate);
        return this;
    }

    public ClassLoader build() {
        URL[] classpathUrls = this.validateAndGetClassPathUrls();
        if (this.parentRelationship == null) {
            throw new InvalidBuilderParametersException("No parent relationship set; please use withParentRelationship() to set one");
        }
        return new IsolatingClassLoader(classpathUrls, this.parentRelationship, this.fallbackDelegates);
    }

    private URL[] validateAndGetClassPathUrls() {
        if (this.originRestriction == null) {
            throw new InvalidBuilderParametersException("No origin restriction set, use OriginRestriction.allowByDefault() if no restriction is desired");
        }
        URL[] classpathUrls = new URL[this.classpath.size()];
        for (int i = 0; i < classpathUrls.length; ++i) {
            URL url = LoaderBuilder.toURL(this.classpath.get(i));
            if (!this.originRestriction.isAllowed(url)) {
                throw new OriginValidationException("Loading classes from " + url + " is forbidden by the origin restriction. Aborting.");
            }
            classpathUrls[i] = url;
        }
        return classpathUrls;
    }

    private static URL toURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new InvalidBuilderParametersException("Unable to convert URI " + uri + " to a URL", e);
        }
    }
}

