/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.tools.rewrite;

import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.lib.UIUtils;
import com.xk72.charles.gui.settings.SettingsException;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.tools.rewrite.DTlZ;
import com.xk72.charles.tools.rewrite.RewriteRule;
import com.xk72.charles.tools.rewrite.danJ;
import com.xk72.charles.tools.rewrite.gGjq;
import com.xk72.charles.tools.rewrite.iLkA;
import com.xk72.charles.tools.rewrite.oJXB;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

class RewriteRulePanel
extends SettingsPanel {
    private final JCheckBox whereRequest;
    private final JCheckBox whereResponse;
    private final JRadioButton replaceFirst;
    private final JRadioButton replaceAll;
    private final JCheckBox regexHeader;
    private final JCheckBox regexValue;
    private final JCheckBox matchWholeValue;
    private final JCheckBox caseSensitive;
    private final JTextField matchHeader;
    private final JTextField matchValue;
    private final JTextField newHeader;
    private final JTextField newValue;
    private final JComboBox<String> ruleType;
    private RewriteRule rule;
    private final JTextArea matchHelp;

    public RewriteRulePanel() {
        super("Rewrite Action");
        String[] stringArray;
        this.setHelp(this.ctx.getBundle().getString("tools.Rewrite.editor.help"));
        this.ruleType = new JComboBox();
        for (String string : stringArray = RewriteRule.getRuleTypeNames()) {
            this.ruleType.addItem(string);
        }
        this.whereRequest = new JCheckBox("Request");
        this.whereResponse = new JCheckBox("Response");
        JLabel jLabel = new JLabel("Name:");
        this.matchHeader = new JTextField();
        this.matchValue = new JTextField();
        this.regexHeader = new JCheckBox("Regex");
        this.regexValue = new JCheckBox("Regex");
        this.matchWholeValue = new JCheckBox("Match whole value");
        this.caseSensitive = new JCheckBox("Case sensitive");
        this.matchHelp = FormUtils.gJOp("");
        this.matchHelp.setForeground(Color.red);
        this.matchHelp.setVisible(false);
        JLabel jLabel2 = new JLabel("Name:");
        this.newHeader = new JTextField();
        this.newValue = new JTextField();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.replaceFirst = new JRadioButton("Replace first");
        this.replaceAll = new JRadioButton("Replace all");
        buttonGroup.add(this.replaceFirst);
        buttonGroup.add(this.replaceAll);
        this.replaceAll.setSelected(true);
        this.matchHeader.getDocument().addDocumentListener(new iLkA(this));
        this.matchValue.getDocument().addDocumentListener(new danJ(this));
        this.regexHeader.addItemListener(new oJXB(this));
        this.regexValue.addItemListener(new gGjq(this));
        JPanel jPanel = new JPanel(FormUtils.fUWl());
        jPanel.add((Component)new JLabel("Type:"), "label");
        jPanel.add(this.ruleType);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill, ins " + UIUtils.AmNw()));
        FormUtils.AmNw(jPanel2, "Where");
        jPanel2.add(this.whereRequest);
        jPanel2.add(this.whereResponse);
        jPanel.add((Component)jPanel2, "span,grow");
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("wrap,fill,ins " + UIUtils.AmNw() + ", hidemode 3", "[label][fill,grow][pref:pref]"));
        FormUtils.AmNw(jPanel3, "Match");
        jPanel3.add((Component)FormUtils.aXgD("Enter text to match or leave blank to match all."), "left,span,grow");
        jPanel3.add(jLabel);
        jPanel3.add(this.matchHeader);
        jPanel3.add(this.regexHeader);
        jPanel3.add(new JLabel("Value:"));
        jPanel3.add(this.matchValue);
        jPanel3.add(this.regexValue);
        jPanel3.add((Component)this.matchWholeValue, "skip 1,split 2,span");
        jPanel3.add(this.caseSensitive);
        jPanel3.add((Component)this.matchHelp, "left,span,grow");
        jPanel.add((Component)jPanel3, "span,grow");
        JPanel jPanel4 = new JPanel(FormUtils.Dlah("ins " + UIUtils.AmNw()));
        FormUtils.AmNw(jPanel4, "Replace");
        jPanel4.add(jLabel2);
        jPanel4.add(this.newHeader);
        jPanel4.add(new JLabel("Value:"));
        jPanel4.add(this.newValue);
        jPanel4.add((Component)this.replaceFirst, "skip 1,split 2,span");
        jPanel4.add(this.replaceAll);
        jPanel4.add((Component)FormUtils.aXgD("Enter new values or leave blank for no change. If using regex matches you may enter references to groups, eg. $1"), "left,span,grow");
        jPanel.add((Component)jPanel4, "span,grow");
        this.add(jPanel);
        this.ruleType.addItemListener(new DTlZ(this, jPanel2, jPanel3, jPanel4, jLabel, jLabel2));
    }

    private void AmNw() {
        if (this.regexHeader.isSelected()) {
            try {
                Pattern.compile(this.matchHeader.getText());
                this.AmNw(null);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.AmNw(patternSyntaxException.getMessage());
            }
        } else {
            this.AmNw(null);
        }
    }

    private void MOou() {
        if (this.regexValue.isSelected()) {
            try {
                Pattern.compile(this.matchValue.getText());
                this.AmNw(null);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.AmNw(patternSyntaxException.getMessage());
            }
        } else {
            this.AmNw(null);
        }
    }

    private void AmNw(String string) {
        Dialog dialog;
        boolean bl = this.matchHelp.isVisible();
        boolean bl2 = string != null;
        this.matchHelp.setText(string);
        this.matchHelp.setVisible(bl2);
        if ((bl || bl2) && (dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this.matchHelp)) != null) {
            Dimension dimension = dialog.getPreferredSize();
            dimension.width = Math.max(dimension.width, dialog.getWidth());
            dialog.setPreferredSize(dimension);
            dialog.pack();
            dialog.setPreferredSize(null);
        }
    }

    @Override
    public boolean preSave() {
        if (RewriteRule.ruleNameToType((String)this.ruleType.getSelectedItem()) == -1) {
            throw new SettingsException("Type", "Please choose the rule type");
        }
        if (this.regexHeader.isSelected()) {
            try {
                Pattern.compile(this.matchHeader.getText());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new SettingsException("Match Header", "Invalid regular expression");
            }
        }
        if (this.regexValue.isSelected()) {
            try {
                Pattern.compile(this.matchValue.getText());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new SettingsException("Match Value", "Invalid regular expression");
            }
        }
        return super.preSave();
    }

    @Override
    public boolean save() {
        this.rule.setRuleType(RewriteRule.ruleNameToType((String)this.ruleType.getSelectedItem()));
        this.rule.setMatchRequest(this.whereRequest.isEnabled() && this.whereRequest.isSelected());
        this.rule.setMatchResponse(this.whereResponse.isEnabled() && this.whereResponse.isSelected());
        this.rule.setMatchHeader(this.matchHeader.isEnabled() ? this.matchHeader.getText() : null);
        this.rule.setMatchValue(this.matchValue.isEnabled() ? this.matchValue.getText() : null);
        this.rule.setNewHeader(this.newHeader.isEnabled() ? this.newHeader.getText() : null);
        this.rule.setNewValue(this.newValue.isEnabled() ? this.newValue.getText() : null);
        this.rule.setMatchHeaderRegex(this.regexHeader.isEnabled() && this.regexHeader.isSelected());
        this.rule.setMatchValueRegex(this.regexValue.isEnabled() && this.regexValue.isSelected());
        this.rule.setMatchWholeValue(this.matchWholeValue.isEnabled() && this.matchWholeValue.isSelected());
        this.rule.setCaseSensitive(this.caseSensitive.isEnabled() && this.caseSensitive.isSelected());
        int n = this.replaceFirst.isEnabled() && this.replaceFirst.isSelected() ? 1 : 2;
        this.rule.setReplaceType(n);
        return true;
    }

    public void setRule(RewriteRule rewriteRule) {
        this.rule = rewriteRule;
        this.ruleType.setSelectedItem(RewriteRule.ruleTypeToName(rewriteRule.getRuleType()));
        this.whereRequest.setSelected(rewriteRule.isMatchRequest());
        this.whereResponse.setSelected(rewriteRule.isMatchResponse());
        this.matchHeader.setText(rewriteRule.getMatchHeader());
        this.matchValue.setText(rewriteRule.getMatchValue());
        this.newHeader.setText(rewriteRule.getNewHeader());
        this.newValue.setText(rewriteRule.getNewValue());
        this.regexHeader.setSelected(rewriteRule.isMatchHeaderRegex());
        this.regexValue.setSelected(rewriteRule.isMatchValueRegex());
        this.matchWholeValue.setSelected(rewriteRule.isMatchWholeValue());
        this.caseSensitive.setSelected(rewriteRule.isCaseSensitive());
        this.replaceAll.setSelected(rewriteRule.getReplaceType() == 2);
        this.replaceFirst.setSelected(rewriteRule.getReplaceType() == 1);
    }

    public RewriteRule getRule() {
        return this.rule;
    }

    private void AmNw(JPanel jPanel, boolean bl) {
        Component[] componentArray;
        jPanel.setEnabled(bl);
        for (Component component : componentArray = jPanel.getComponents()) {
            component.setEnabled(bl);
            if (!(component instanceof JPanel)) continue;
            this.AmNw((JPanel)component, bl);
        }
    }
}

