/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.ssl;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.ssl.SSLCertificateStore;
import com.xk72.charles.store.AMvX;
import com.xk72.charles.store.CharlesPasswordStoreException;
import com.xk72.charles.store.iLkA;
import com.xk72.vaDV.FzFK;
import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class avKp {
    private static final Logger AmNw = Logger.getLogger("com.xk72.charles.ssl.PKCS12CertificateLoader");
    private transient AMvX MOou = new AMvX();
    private final iLkA aXgD = CharlesContext.getInstance().getPasswordStore();

    private char[] AmNw(String string, File file, String string2, boolean bl, Dialog dialog) {
        char[] cArray;
        String string3 = file.getAbsolutePath();
        try {
            cArray = this.MOou.AmNw(string3);
        }
        catch (CharlesPasswordStoreException charlesPasswordStoreException) {
            cArray = null;
        }
        if (cArray == null) {
            try {
                cArray = this.aXgD.AmNw(string3);
            }
            catch (CharlesPasswordStoreException charlesPasswordStoreException) {
                AmNw.log(Level.WARNING, "Failed to access password store", charlesPasswordStoreException);
            }
        }
        if (cArray == null) {
            cArray = this.AmNw(string, file, string2, false, false, bl, dialog);
        }
        return cArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<FzFK> AmNw(File file, String string, String string2, boolean bl, Dialog dialog) {
        if (!file.exists()) {
            CharlesContext.getInstance().error("Certificate Loader", "The certificate file doesn't exist: " + file);
            return null;
        }
        try {
            char[] cArray = this.AmNw(string, file, string2, bl, dialog);
            if (cArray == null) return null;
            while (true) {
                char[] cArray2 = (char[])(cArray.length != 0 ? cArray : null);
                try {
                    List<FzFK> list = SSLCertificateStore.AmNw(file, cArray2);
                    if (!list.isEmpty()) return list;
                    CharlesContext.getInstance().error("Certificate Loader", "No appropriate certificates with keys were found in file: " + file);
                    return null;
                }
                catch (IOException iOException) {
                    if (iOException.getCause() == null) throw iOException;
                    if (!(iOException.getCause() instanceof GeneralSecurityException)) {
                        if (!(iOException.getCause() instanceof ArithmeticException)) throw iOException;
                    }
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    // empty catch block
                }
                cArray = this.AmNw(string, file, string2, true, false, bl, dialog);
                if (cArray == null) return null;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.AmNw(file, noSuchAlgorithmException);
            return null;
        }
        catch (CertificateException certificateException) {
            this.AmNw(file, certificateException);
            return null;
        }
        catch (IOException iOException) {
            this.AmNw(file, iOException);
            return null;
        }
        catch (KeyStoreException keyStoreException) {
            this.AmNw(file, keyStoreException);
        }
        return null;
    }

    private void AmNw(File file, Throwable throwable) {
        CharlesContext.getInstance().error("Certificate Loader", "Failed to load certificate from file: " + file, throwable);
    }

    protected char[] AmNw(String string, File file, String string2, boolean bl, boolean bl2, boolean bl3, Dialog dialog) {
        AmNw.warning("Cannot ask for passwords");
        return null;
    }

    protected void AmNw(File file, char[] cArray, boolean bl) {
        String string = file.getAbsolutePath();
        try {
            this.MOou.AmNw(string, cArray);
        }
        catch (CharlesPasswordStoreException charlesPasswordStoreException) {
            AmNw.log(Level.WARNING, "Failed to remember password", charlesPasswordStoreException);
        }
        if (bl) {
            try {
                this.aXgD.AmNw(string, cArray);
            }
            catch (CharlesPasswordStoreException charlesPasswordStoreException) {
                AmNw.log(Level.WARNING, "Failed to store password", charlesPasswordStoreException);
            }
        }
    }
}

