/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.config.ProxyConfiguration;
import com.xk72.charles.gui.lib.EnableAwareJLabel;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.settings.KYWQ;
import com.xk72.charles.gui.settings.ProxySettingsPanel;
import com.xk72.charles.gui.settings.ProxySettingsPanel$AbstractIntegrationPanel;
import com.xk72.charles.gui.settings.SSUB;
import com.xk72.charles.gui.settings.SettingsException;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.gui.settings.zdrH;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

class ProxySettingsPanel$ProxiesPanel
extends SettingsPanel {
    private final JCheckBox enableSOCKSProxy;
    private final JCheckBox dynamicHTTPPort;
    private final JCheckBox dynamicSOCKSPort;
    private final JCheckBox socksTransparentHTTPProxying;
    private final JCheckBox defaultSocksTransparentHTTPProxyPorts;
    private final JCheckBox transparentProxy;
    private final JCheckBox supportsH2;
    private final JTextField httpProxyPort;
    private final JTextField socksProxyPort;
    private final JTextField socksTransparentHTTPProxyPorts;
    private boolean initedStaticHTTPPort;
    private boolean initedStaticSOCKSPort;
    final /* synthetic */ ProxySettingsPanel this$0;

    public ProxySettingsPanel$ProxiesPanel(ProxySettingsPanel proxySettingsPanel) {
        this.this$0 = proxySettingsPanel;
        super(CharlesContext.getInstance().getBundle().getString("settings.proxy.proxies.name"));
        this.enableSOCKSProxy = new JCheckBox("Enable SOCKS proxy");
        this.dynamicHTTPPort = new JCheckBox("Use a dynamic port");
        this.dynamicSOCKSPort = new JCheckBox("Use a dynamic port");
        this.socksTransparentHTTPProxying = new JCheckBox("Enable HTTP proxying over SOCKS");
        this.defaultSocksTransparentHTTPProxyPorts = new JCheckBox("Include default HTTP ports (80, 443, 8080, 8443)");
        this.transparentProxy = new JCheckBox("Enable transparent HTTP proxying");
        this.supportsH2 = new JCheckBox("Support HTTP/2");
        this.httpProxyPort = new JTextField(4);
        this.socksProxyPort = new JTextField(4);
        this.socksTransparentHTTPProxyPorts = new JTextField(20);
        this.setHelp(CharlesContext.getInstance().getBundle().getString("settings.proxy.proxies.help"));
        this.AmNw(this.ctx.getConfiguration().getProxyConfiguration());
        this.enableSOCKSProxy.addItemListener(proxySettingsPanel);
        this.socksTransparentHTTPProxying.addItemListener(proxySettingsPanel);
        JButton jButton = new JButton("Restore Defaults");
        JButton jButton2 = new JButton("HTTP Proxy Mode");
        JButton jButton3 = new JButton("SOCKS Proxy Mode");
        jButton.addActionListener(new KYWQ(this, proxySettingsPanel));
        jButton2.addActionListener(new SSUB(this, proxySettingsPanel));
        jButton3.addActionListener(new zdrH(this, proxySettingsPanel));
        JPanel jPanel = new JPanel(FormUtils.rnqJ());
        FormUtils.AmNw(jPanel, "HTTP Proxy");
        jPanel.add((Component)new EnableAwareJLabel("Port:", this.httpProxyPort), "label, grow 0, split 3");
        jPanel.add(this.httpProxyPort);
        jPanel.add((Component)this.dynamicHTTPPort, "grow 0");
        jPanel.add((Component)this.supportsH2, "grow 0, split 2");
        jPanel.add((Component)this.transparentProxy, "span");
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(FormUtils.rnqJ());
        FormUtils.AmNw(jPanel2, "SOCKS Proxy");
        jPanel2.add(this.enableSOCKSProxy);
        jPanel2.add((Component)new EnableAwareJLabel("Port:", this.socksProxyPort), "label, grow 0, split 3");
        jPanel2.add(this.socksProxyPort);
        jPanel2.add((Component)this.dynamicSOCKSPort, "grow 0");
        jPanel2.add(this.socksTransparentHTTPProxying);
        jPanel2.add((Component)this.defaultSocksTransparentHTTPProxyPorts, "gap i");
        jPanel2.add((Component)new EnableAwareJLabel("Ports:", this.socksTransparentHTTPProxyPorts), "gap i, label, grow 0, split 2");
        jPanel2.add(this.socksTransparentHTTPProxyPorts);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("center, ins 0"));
        jPanel3.add((Component)jButton, "grow 0, split 3, wmin button");
        jPanel3.add((Component)jButton2, "grow 0, wmin button");
        jPanel3.add((Component)jButton3, "grow 0, wmin button");
        this.add(jPanel3);
    }

    private void AmNw(ProxyConfiguration proxyConfiguration) {
        this.transparentProxy.setSelected(proxyConfiguration.isTransparentProxy());
        this.supportsH2.setSelected(proxyConfiguration.isSupportsH2());
        this.enableSOCKSProxy.setSelected(proxyConfiguration.isEnableSOCKSProxy());
        this.initedStaticHTTPPort = this.AmNw(this.httpProxyPort, proxyConfiguration.getPort(), this.ctx.getProxyManager().gJOp(), this.dynamicHTTPPort, proxyConfiguration.isDynamicHTTPPort());
        this.initedStaticSOCKSPort = this.AmNw(this.socksProxyPort, proxyConfiguration.getSOCKSPort(), this.ctx.getProxyManager().OBgP(), this.dynamicSOCKSPort, proxyConfiguration.isDynamicSOCKSPort());
        this.socksTransparentHTTPProxying.setSelected(proxyConfiguration.isEnableSOCKSTransparentHTTPProxying());
        this.defaultSocksTransparentHTTPProxyPorts.setSelected(proxyConfiguration.isDefaultSOCKSTransparentHTTPProxyPorts());
        StringBuilder stringBuilder = new StringBuilder();
        if (proxyConfiguration.getSocksTransparentHTTPProxyPorts() != null) {
            for (int n : proxyConfiguration.getSocksTransparentHTTPProxyPorts()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(n);
            }
        }
        if (proxyConfiguration.getSocksTransparentHTTPProxyPortRanges() != null) {
            int[] nArray = proxyConfiguration.getSocksTransparentHTTPProxyPortRanges();
            for (int i = 1; i < nArray.length; i += 2) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(nArray[i - 1]);
                stringBuilder.append("-");
                stringBuilder.append(nArray[i]);
            }
        }
        this.socksTransparentHTTPProxyPorts.setText(stringBuilder.toString());
    }

    private void AmNw(ProxySettingsPanel$AbstractIntegrationPanel proxySettingsPanel$AbstractIntegrationPanel) {
        proxySettingsPanel$AbstractIntegrationPanel.useHTTPProxy.setSelected(true);
        proxySettingsPanel$AbstractIntegrationPanel.useSOCKSProxy.setSelected(false);
    }

    private void MOou(ProxySettingsPanel$AbstractIntegrationPanel proxySettingsPanel$AbstractIntegrationPanel) {
        proxySettingsPanel$AbstractIntegrationPanel.useHTTPProxy.setSelected(false);
        proxySettingsPanel$AbstractIntegrationPanel.useSOCKSProxy.setSelected(true);
    }

    public void updateForm() {
        this.httpProxyPort.setEnabled(!this.dynamicHTTPPort.isSelected());
        this.dynamicSOCKSPort.setEnabled(this.enableSOCKSProxy.isSelected());
        this.socksProxyPort.setEnabled(this.enableSOCKSProxy.isSelected() && !this.dynamicSOCKSPort.isSelected());
        this.socksTransparentHTTPProxying.setEnabled(this.enableSOCKSProxy.isSelected());
        this.defaultSocksTransparentHTTPProxyPorts.setEnabled(this.enableSOCKSProxy.isSelected() && this.socksTransparentHTTPProxying.isSelected());
        this.socksTransparentHTTPProxyPorts.setEnabled(this.enableSOCKSProxy.isSelected() && this.socksTransparentHTTPProxying.isSelected());
        ProxyConfiguration proxyConfiguration = this.ctx.getConfiguration().getProxyConfiguration();
        this.initedStaticHTTPPort = this.MOou(this.httpProxyPort, proxyConfiguration.getPort(), this.ctx.getProxyManager().gJOp(), this.dynamicHTTPPort, this.initedStaticHTTPPort);
        this.initedStaticSOCKSPort = this.MOou(this.socksProxyPort, proxyConfiguration.getSOCKSPort(), this.ctx.getProxyManager().OBgP(), this.dynamicSOCKSPort, this.initedStaticSOCKSPort);
    }

    private boolean AmNw(JTextField jTextField, int n, int n2, JCheckBox jCheckBox, boolean bl) {
        jCheckBox.setSelected(bl);
        jCheckBox.addActionListener(this.this$0);
        if (bl) {
            if (n2 != -1) {
                jTextField.setText("" + n2);
            }
            return false;
        }
        jTextField.setText("" + n);
        return true;
    }

    private boolean MOou(JTextField jTextField, int n, int n2, JCheckBox jCheckBox, boolean bl) {
        if (jCheckBox.isSelected()) {
            if (n2 != -1) {
                jTextField.setText("" + n2);
            }
            return false;
        }
        if (!bl) {
            jTextField.setText("" + n);
            return true;
        }
        return true;
    }

    @Override
    public boolean preSave() {
        this.prefToInt("HTTP Proxy Port", this.httpProxyPort.getText());
        this.prefToInt("SOCKS Proxy Port", this.socksProxyPort.getText());
        try {
            this.AmNw(this.socksTransparentHTTPProxyPorts.getText());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SettingsException("SOCKS Transparent HTTP proxying ports", "Please check the list of ports, one of them is invalid:\n" + numberFormatException.getMessage());
        }
        return true;
    }

    @Override
    public boolean save() {
        ProxyConfiguration proxyConfiguration = this.ctx.getConfiguration().getProxyConfiguration();
        proxyConfiguration.setTransparentProxy(this.transparentProxy.isSelected());
        proxyConfiguration.setSupportsH2(this.supportsH2.isSelected());
        proxyConfiguration.setEnableSOCKSProxy(this.enableSOCKSProxy.isSelected());
        proxyConfiguration.setDynamicHTTPPort(this.dynamicHTTPPort.isSelected());
        proxyConfiguration.setDynamicSOCKSPort(this.dynamicSOCKSPort.isSelected());
        proxyConfiguration.setPort(this.prefToIntSafe(this.httpProxyPort.getText()));
        proxyConfiguration.setSOCKSPort(this.prefToIntSafe(this.socksProxyPort.getText()));
        proxyConfiguration.setEnableSOCKSTransparentHTTPProxying(this.socksTransparentHTTPProxying.isSelected());
        proxyConfiguration.setDefaultSOCKSTransparentHTTPProxyPorts(this.defaultSocksTransparentHTTPProxyPorts.isSelected());
        int[][] nArray = this.AmNw(this.socksTransparentHTTPProxyPorts.getText());
        proxyConfiguration.setSocksTransparentHTTPProxyPorts(nArray[0]);
        proxyConfiguration.setSocksTransparentHTTPProxyPortRanges(nArray[1]);
        return this.this$0.MOou();
    }

    private int[][] AmNw(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string.replaceAll("\\s*\\-\\s*", "-"), ", \t\r\n");
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            int n4 = ((String)object).indexOf(45);
            if (n4 < 0) {
                nArray[n2++] = Integer.parseInt((String)object);
                continue;
            }
            int n5 = Integer.parseInt(((String)object).substring(0, n4));
            int n6 = Integer.parseInt(((String)object).substring(n4 + 1));
            nArray2[n3++] = Math.min(n5, n6);
            nArray2[n3++] = Math.max(n5, n6);
        }
        object = new int[2][];
        object[0] = Arrays.copyOf(nArray, n2);
        object[1] = Arrays.copyOf(nArray2, n3);
        return object;
    }
}

