/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.gui.lib.BetterTextArea;
import com.xk72.charles.gui.lib.UIUtils;
import com.xk72.charles.gui.settings.ImportCertificateHelper;
import com.xk72.charles.gui.settings.ImportCertificateHelper$ImportPemPanel$ErrorType;
import com.xk72.charles.gui.settings.SettingsException;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.gui.settings.kxBo;
import com.xk72.charles.gui.settings.pssm;
import com.xk72.vaDV.FzFK;
import java.awt.Component;
import java.awt.GridLayout;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ImportCertificateHelper$ImportPemPanel
extends SettingsPanel {
    private final BetterTextArea privateKey = new BetterTextArea();
    private final JLabel keyError = new JLabel();
    private final BetterTextArea certChain = new BetterTextArea();
    private final JLabel certError = new JLabel();
    private Certificate[] certificates;
    private Key key;

    public ImportCertificateHelper$ImportPemPanel() {
        super("Certificate With Private Key");
        this.AmNw(this.privateKey, "PEM Encoded Private Key");
        this.privateKey.getDocument().addDocumentListener(new pssm(this));
        this.add((Component)this.keyError, "hidemode 0");
        this.AmNw(this.certChain, "PEM Encoded Certificates");
        this.certChain.getDocument().addDocumentListener(new kxBo(this));
        this.add((Component)this.certError, "hidemode 0");
    }

    private void AmNw(BetterTextArea betterTextArea, String string) {
        betterTextArea.setEditable(true);
        betterTextArea.setLineWrap(false);
        betterTextArea.setFont(UIUtils.MOou());
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.add(new JScrollPane(betterTextArea));
        UIUtils.AmNw(jPanel, string);
        this.add((Component)jPanel, "width 760lp, height 240lp, pushy, growy");
    }

    private void AmNw(ImportCertificateHelper$ImportPemPanel$ErrorType importCertificateHelper$ImportPemPanel$ErrorType) {
        this.AmNw(importCertificateHelper$ImportPemPanel$ErrorType, "");
    }

    private void AmNw(ImportCertificateHelper$ImportPemPanel$ErrorType importCertificateHelper$ImportPemPanel$ErrorType, String string) {
        switch (importCertificateHelper$ImportPemPanel$ErrorType) {
            case MOou: {
                this.certError.setText(string);
                break;
            }
            case AmNw: {
                this.keyError.setText(string);
                break;
            }
        }
    }

    protected void checkPrivateKey() {
        this.key = null;
        this.AmNw(ImportCertificateHelper$ImportPemPanel$ErrorType.AmNw);
        String string = this.privateKey.getText();
        if (string != null && !string.isEmpty()) {
            Certificate[] certificateArray = this.certificates;
            if (certificateArray != null && certificateArray.length > 0) {
                PublicKey publicKey = certificateArray[0].getPublicKey();
                try {
                    PrivateKey privateKey = ImportCertificateHelper.AmNw(string, publicKey.getAlgorithm());
                    try {
                        this.key = null;
                        if (ImportCertificateHelper.AmNw(publicKey, privateKey)) {
                            this.key = privateKey;
                        } else {
                            this.AmNw(ImportCertificateHelper$ImportPemPanel$ErrorType.AmNw, "Private key does not match public key from primary certificate");
                        }
                    }
                    catch (Exception exception) {
                        this.AmNw(ImportCertificateHelper$ImportPemPanel$ErrorType.AmNw, "Unexpected error validating private key");
                    }
                }
                catch (Exception exception) {
                    this.AmNw(ImportCertificateHelper$ImportPemPanel$ErrorType.AmNw, "Unable to parse private key");
                }
            } else {
                this.AmNw(ImportCertificateHelper$ImportPemPanel$ErrorType.AmNw, "Cannot validate private key without certificate");
            }
        }
    }

    private void AmNw(Certificate[] certificateArray) {
        this.certificates = certificateArray;
        try {
            this.AmNw(ImportCertificateHelper$ImportPemPanel$ErrorType.MOou);
            if (certificateArray != null && !ImportCertificateHelper.AmNw(certificateArray)) {
                this.AmNw(ImportCertificateHelper$ImportPemPanel$ErrorType.MOou, "Invalid certificate chain");
            }
        }
        catch (Exception exception) {
            this.AmNw(ImportCertificateHelper$ImportPemPanel$ErrorType.MOou, "Unexpected error validating certificate chain");
        }
    }

    public FzFK getCertificate() {
        Certificate[] certificateArray = this.certificates;
        if (certificateArray != null && this.key != null) {
            return new FzFK(null, certificateArray[0], this.key, certificateArray);
        }
        return null;
    }

    @Override
    public boolean preSave() {
        String string = this.keyError.getText();
        if (string != null && !string.isEmpty()) {
            throw new SettingsException("Error with private key\n\t- " + string);
        }
        string = this.certError.getText();
        if (string != null && !string.isEmpty()) {
            throw new SettingsException("Error with certificate chain\n\t- " + string);
        }
        if (this.certificates != null && this.key == null) {
            throw new SettingsException("You must supply a private key");
        }
        return true;
    }

    @Override
    public boolean save() {
        return true;
    }
}

