/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.session.popups;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.config.LocationPatternConfiguration;
import com.xk72.charles.gui.find.AdvancedFindDialog;
import com.xk72.charles.gui.lib.actions.CollapsePathAction;
import com.xk72.charles.gui.lib.actions.ExpandPathAction;
import com.xk72.charles.gui.session.AGGK;
import com.xk72.charles.gui.session.actions.ClearAction;
import com.xk72.charles.gui.session.actions.ClearOthersAction;
import com.xk72.charles.gui.session.actions.ClearOthersSequenceAction;
import com.xk72.charles.gui.session.popups.AMvX;
import com.xk72.charles.gui.session.popups.FzFK;
import com.xk72.charles.gui.session.popups.VUqf;
import com.xk72.charles.gui.session.popups.avKp;
import com.xk72.charles.gui.session.popups.danJ;
import com.xk72.charles.gui.session.popups.iLkA;
import com.xk72.charles.gui.session.trees.MhBt;
import com.xk72.charles.gui.session.trees.XDSj;
import com.xk72.charles.gui.session.trees.gGjq;
import com.xk72.charles.model.Host;
import com.xk72.charles.model.ModelNode;
import com.xk72.charles.model.ModelNodeComparator;
import com.xk72.charles.ssl.CkGq;
import com.xk72.charles.tools.LocationSelectingTool;
import com.xk72.charles.tools.LocationUsingTool;
import com.xk72.charles.tools.lib.CharlesTool;
import com.xk72.net.Location;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public abstract class AbstractModelNodePopupMenu
extends JPopupMenu {
    protected ModelNode[] nodes;
    protected com.xk72.charles.gui.navigator.FzFK<?> navigator;
    private final AGGK focusManager;
    protected final AdvancedFindDialog findDialog;

    public AbstractModelNodePopupMenu(ModelNode modelNode, com.xk72.charles.gui.navigator.FzFK<?> fzFK, AGGK aGGK, AdvancedFindDialog advancedFindDialog) {
        this(new ModelNode[]{modelNode}, fzFK, aGGK, advancedFindDialog);
    }

    public AbstractModelNodePopupMenu(ModelNode[] modelNodeArray, com.xk72.charles.gui.navigator.FzFK<?> fzFK, AGGK aGGK, AdvancedFindDialog advancedFindDialog) {
        this.nodes = modelNodeArray;
        this.navigator = fzFK;
        this.focusManager = aGGK;
        this.findDialog = advancedFindDialog;
    }

    public void show(MouseEvent mouseEvent) {
        Component component;
        if (this.getComponentCount() != 0) {
            this.removeAll();
        }
        this.prepare(mouseEvent);
        while (this.getComponentCount() > 0 && (component = this.getComponent(this.getComponentCount() - 1)) instanceof JPopupMenu.Separator) {
            this.remove(component);
        }
        if (this.getComponentCount() != 0) {
            this.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected abstract void prepare(MouseEvent var1);

    protected boolean addFocus() {
        Host[] hostArray;
        if (this.focusManager != null && (hostArray = this.AmNw()) != null) {
            boolean bl = true;
            for (Host host : hostArray) {
                bl = bl && this.focusManager.AmNw(host);
            }
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Focus");
            jCheckBoxMenuItem.setSelected(bl);
            jCheckBoxMenuItem.addItemListener(new FzFK(this, hostArray));
            this.add(jCheckBoxMenuItem);
            return true;
        }
        return false;
    }

    private Host[] AmNw() {
        HashSet<Host> hashSet = new HashSet<Host>();
        for (ModelNode modelNode : this.nodes) {
            Host host = this.AmNw(modelNode);
            if (host == null) continue;
            hashSet.add(host);
        }
        return hashSet.isEmpty() ? null : hashSet.toArray(new Host[hashSet.size()]);
    }

    private Host AmNw(ModelNode modelNode) {
        if (modelNode == null) {
            return null;
        }
        if (modelNode instanceof Host) {
            return (Host)modelNode;
        }
        return this.AmNw(modelNode.getParent());
    }

    protected boolean addReorder() {
        if (this.navigator != null && this.navigator.AmNw() instanceof XDSj) {
            TreePath[] treePathArray;
            JTree jTree = (JTree)this.navigator.aXgD();
            boolean bl = false;
            ModelNode modelNode = this.nodes.length != 0 ? this.nodes[0].getParent() : null;
            for (int i = 1; i < this.nodes.length; ++i) {
                if (this.nodes[i].getParent() == modelNode) continue;
                modelNode = null;
                break;
            }
            if (modelNode != null) {
                ModelNode modelNode2 = modelNode;
                XDSj xDSj = (XDSj)this.navigator.AmNw();
                Comparator<ModelNode> comparator = xDSj.AmNw(modelNode2);
                JMenu jMenu = new JMenu("Sort By");
                for (ModelNodeComparator modelNodeComparator : ModelNodeComparator.values()) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(modelNodeComparator.getName());
                    jCheckBoxMenuItem.setSelected(comparator == modelNodeComparator.getComparator());
                    jCheckBoxMenuItem.addItemListener(new VUqf(this, xDSj, modelNode2, modelNodeComparator));
                    jMenu.add(jCheckBoxMenuItem);
                }
                this.add(jMenu);
                bl = true;
            }
            if ((treePathArray = jTree.getSelectionPaths()) != null && ExpandPathAction.AmNw(jTree, treePathArray)) {
                this.add(new ExpandPathAction(jTree, treePathArray));
                this.add(new CollapsePathAction(jTree, treePathArray));
                bl = true;
            }
            return bl;
        }
        return false;
    }

    protected void addIgnore() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Ignore");
        jCheckBoxMenuItem.setSelected(this.isIgnored());
        jCheckBoxMenuItem.addItemListener(new avKp(this));
        this.add(jCheckBoxMenuItem);
    }

    protected void addClear() {
        this.add(new ClearAction(this.nodes));
    }

    protected void addClearOthers() {
        if (this.navigator instanceof com.xk72.charles.gui.session.tables.FzFK || this.navigator instanceof gGjq) {
            this.add(new ClearOthersSequenceAction(this.nodes));
        } else if (this.navigator instanceof MhBt) {
            this.add(new ClearOthersAction(this.nodes));
        }
    }

    protected abstract Location toLocation();

    protected Collection<Location> toLocations() {
        Location location = this.toLocation();
        if (location != null) {
            return Collections.singleton(location);
        }
        return Collections.emptyList();
    }

    protected boolean isIgnored() {
        LocationPatternConfiguration locationPatternConfiguration = CharlesContext.getInstance().getConfiguration().getRecordingConfiguration().getIgnoreHosts();
        for (Location location : this.getIgnoreKey()) {
            if (!com.xk72.net.avKp.AmNw(location, locationPatternConfiguration.getLocationPatterns())) continue;
            return true;
        }
        return false;
    }

    protected Collection<Location> getIgnoreKey() {
        return this.toLocations();
    }

    protected boolean isSelectedLocation(LocationSelectingTool locationSelectingTool) {
        return locationSelectingTool.isSelectedLocation(this.toLocation());
    }

    protected void selectLocation(LocationSelectingTool locationSelectingTool) {
        locationSelectingTool.selectLocation(this.toLocation());
    }

    protected void deselectLocation(LocationSelectingTool locationSelectingTool) {
        locationSelectingTool.deselectLocation(this.toLocation());
    }

    protected void useLocation(LocationUsingTool locationUsingTool) {
        locationUsingTool.useLocation(this.toLocation());
    }

    protected boolean isUsingLocation(LocationUsingTool locationUsingTool) {
        return locationUsingTool.isUsingLocation(this.toLocation());
    }

    protected void addSelectingTools() {
        List<CharlesTool> list = CharlesContext.getInstance().getAllTools();
        for (CharlesTool charlesTool : list) {
            if (!(charlesTool instanceof LocationSelectingTool)) continue;
            LocationSelectingTool locationSelectingTool = (LocationSelectingTool)((Object)charlesTool);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(locationSelectingTool.getName());
            jCheckBoxMenuItem.setSelected(this.isSelectedLocation(locationSelectingTool));
            jCheckBoxMenuItem.addItemListener(new AMvX(this, locationSelectingTool));
            this.add(jCheckBoxMenuItem);
        }
    }

    protected void addSSLProxyingSelector() {
        if (this.nodes.length > 0) {
            CkGq ckGq = new CkGq();
            Location location = this.toLocation();
            boolean bl = ckGq.isSelectedLocation(location);
            JMenuItem jMenuItem = new JMenuItem(bl ? "SSL Proxying: Enabled" : "SSL Proxying: Disabled");
            jMenuItem.setEnabled(false);
            this.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem(bl ? "Disable SSL Proxying" : "Enable SSL Proxying");
            jMenuItem2.addActionListener(new iLkA(this, ckGq, location, jMenuItem2, jMenuItem));
            this.add(jMenuItem2);
            jMenuItem2.setEnabled(CharlesContext.getInstance().getConfiguration().getProxyConfiguration().isDecryptSSL());
        }
    }

    protected void addUsingTools() {
        List<CharlesTool> list = CharlesContext.getInstance().getAllTools();
        for (CharlesTool charlesTool : list) {
            if (!(charlesTool instanceof LocationUsingTool)) continue;
            this.addLocationUsingTool((LocationUsingTool)((Object)charlesTool));
        }
    }

    protected void addLocationUsingTool(LocationUsingTool locationUsingTool) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(locationUsingTool.getName() + "\u2026");
        jCheckBoxMenuItem.setSelected(this.isUsingLocation(locationUsingTool));
        jCheckBoxMenuItem.addItemListener(new danJ(this, locationUsingTool));
        this.add(jCheckBoxMenuItem);
    }
}

