/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.LoggerUtil;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRLogger;
import org.xhtmlrenderer.util.XRRuntimeException;

public class JDKXRLogger
implements XRLogger {
    private static boolean initPending = true;

    public void log(String where, Level level, String msg) {
        if (initPending) {
            JDKXRLogger.init();
        }
        JDKXRLogger.getLogger(where).log(level, msg);
    }

    public void log(String where, Level level, String msg, Throwable th) {
        if (initPending) {
            JDKXRLogger.init();
        }
        JDKXRLogger.getLogger(where).log(level, msg, th);
    }

    public void setLevel(String logger, Level level) {
        JDKXRLogger.getLogger(logger).setLevel(level);
    }

    private static Logger getLogger(String log) {
        return Logger.getLogger(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Class clazz = JDKXRLogger.class;
        synchronized (clazz) {
            if (!initPending) {
                return;
            }
            initPending = false;
            try {
                Properties props = JDKXRLogger.retrieveLoggingProperties();
                if (!XRLog.isLoggingEnabled()) {
                    Configuration.setConfigLogger(Logger.getLogger(XRLog.CONFIG));
                    return;
                }
                JDKXRLogger.initializeJDKLogManager(props);
                Configuration.setConfigLogger(Logger.getLogger(XRLog.CONFIG));
            }
            catch (SecurityException props) {
            }
            catch (FileNotFoundException e) {
                throw new XRRuntimeException("Could not initialize logs. " + e.getLocalizedMessage(), e);
            }
            catch (IOException e) {
                throw new XRRuntimeException("Could not initialize logs. " + e.getLocalizedMessage(), e);
            }
        }
    }

    private static Properties retrieveLoggingProperties() {
        String prefix = "xr.util-logging.";
        Iterator iter = Configuration.keysByPrefix(prefix);
        Properties props = new Properties();
        while (iter.hasNext()) {
            String fullkey = (String)iter.next();
            String lmkey = fullkey.substring(prefix.length());
            String value = Configuration.valueFor(fullkey);
            props.setProperty(lmkey, value);
        }
        return props;
    }

    private static void initializeJDKLogManager(Properties fsLoggingProperties) throws IOException {
        List loggers = JDKXRLogger.retrieveLoggers();
        JDKXRLogger.configureLoggerHandlerForwarding(fsLoggingProperties, loggers);
        Enumeration<Object> keys = fsLoggingProperties.keys();
        Map handlers = new HashMap();
        HashMap<String, String> handlerFormatterMap = new HashMap<String, String>();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String prop = fsLoggingProperties.getProperty(key);
            if (key.endsWith("level")) {
                JDKXRLogger.configureLogLevel(key.substring(0, key.lastIndexOf(".")), prop);
                continue;
            }
            if (key.endsWith("handlers")) {
                handlers = JDKXRLogger.configureLogHandlers(loggers, prop);
                continue;
            }
            if (!key.endsWith("formatter")) continue;
            String k2 = key.substring(0, key.length() - ".formatter".length());
            handlerFormatterMap.put(k2, prop);
        }
        Iterator it = handlerFormatterMap.keySet().iterator();
        while (it.hasNext()) {
            String handlerClassName = (String)it.next();
            String formatterClassName = (String)handlerFormatterMap.get(handlerClassName);
            JDKXRLogger.assignFormatter(handlers, handlerClassName, formatterClassName);
        }
    }

    private static void configureLoggerHandlerForwarding(Properties fsLoggingProperties, List loggers) {
        String val = fsLoggingProperties.getProperty("use-parent-handler");
        boolean flag = val == null ? false : Boolean.valueOf(val);
        Iterator it = loggers.iterator();
        while (it.hasNext()) {
            Logger logger = (Logger)it.next();
            logger.setUseParentHandlers(flag);
        }
    }

    private static void assignFormatter(Map handlers, String handlerClassName, String formatterClassName) {
        Handler handler = (Handler)handlers.get(handlerClassName);
        if (handler != null) {
            try {
                Class<?> fclass = Class.forName(formatterClassName);
                Formatter f = (Formatter)fclass.newInstance();
                handler.setFormatter(f);
            }
            catch (ClassNotFoundException e) {
                throw new XRRuntimeException("Could not initialize logging properties; Formatter class not found: " + formatterClassName);
            }
            catch (IllegalAccessException e) {
                throw new XRRuntimeException("Could not initialize logging properties; Can't instantiate Formatter class (IllegalAccessException): " + formatterClassName);
            }
            catch (InstantiationException e) {
                throw new XRRuntimeException("Could not initialize logging properties; Can't instantiate Formatter class (InstantiationException): " + formatterClassName);
            }
        }
    }

    private static List retrieveLoggers() {
        List loggerNames = XRLog.listRegisteredLoggers();
        ArrayList<Logger> loggers = new ArrayList<Logger>(loggerNames.size());
        Iterator it = loggerNames.iterator();
        while (it.hasNext()) {
            String ln = (String)it.next();
            loggers.add(Logger.getLogger(ln));
        }
        return loggers;
    }

    private static Map configureLogHandlers(List loggers, String handlerClassList) {
        Handler handler;
        String[] names = handlerClassList.split(" ");
        HashMap<String, Handler> handlers = new HashMap<String, Handler>(names.length);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            try {
                Class<?> handlerClass = Class.forName(name);
                handler = (Handler)handlerClass.newInstance();
                handlers.put(name, handler);
                String hl = Configuration.valueFor("xr.util-logging." + name + ".level", "INFO");
                handler.setLevel(LoggerUtil.parseLogLevel(hl, Level.INFO));
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new XRRuntimeException("Could not initialize logging properties; Handler class not found: " + name);
            }
            catch (IllegalAccessException e) {
                throw new XRRuntimeException("Could not initialize logging properties; Can't instantiate Handler class (IllegalAccessException): " + name);
            }
            catch (InstantiationException e) {
                throw new XRRuntimeException("Could not initialize logging properties; Can't instantiate Handler class (InstantiationException): " + name);
            }
        }
        Iterator iterator = loggers.iterator();
        while (iterator.hasNext()) {
            Logger logger = (Logger)iterator.next();
            Iterator ith = handlers.values().iterator();
            while (ith.hasNext()) {
                handler = (Handler)ith.next();
                logger.addHandler(handler);
            }
        }
        return handlers;
    }

    private static void configureLogLevel(String loggerName, String levelValue) {
        Level level = LoggerUtil.parseLogLevel(levelValue, Level.OFF);
        Logger logger = Logger.getLogger(loggerName);
        logger.setLevel(level);
    }
}

