/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text.xml;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.bounce.text.FoldingMargin;
import org.bounce.text.xml.XMLScanner;
import org.bounce.text.xml.XMLViewUtilities;

public class XMLFoldingMargin
extends FoldingMargin {
    private static final long serialVersionUID = 8489615051963807472L;
    private XMLScanner scanner = null;

    public XMLFoldingMargin(JTextComponent editor) throws IOException {
        super(editor);
        this.initScanner(editor.getDocument());
        editor.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Object prop = event.getNewValue();
                if (prop instanceof Document) {
                    try {
                        XMLFoldingMargin.this.initScanner((Document)prop);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void initScanner(Document document) throws IOException {
        this.scanner = new XMLScanner(document);
    }

    @Override
    protected int getFoldClosingLine(int start, int end) {
        Element element = this.editor.getDocument().getDefaultRootElement().getElement(start);
        int tagStart = this.getStartTagLocation(element.getStartOffset(), element.getEndOffset());
        if (tagStart != -1) {
            Element endElement = this.editor.getDocument().getDefaultRootElement().getElement(end);
            int tagEnd = this.getEndTagLocation(tagStart, endElement.getEndOffset());
            if (tagStart >= element.getStartOffset() && tagStart < element.getEndOffset() && tagEnd > element.getEndOffset()) {
                return this.editor.getDocument().getDefaultRootElement().getElementIndex(tagEnd);
            }
        }
        return start;
    }

    private int getStartTagLocation(int offset, int end) {
        this.scanner.setValid(false);
        XMLViewUtilities.updateScanner(this.scanner, this.editor.getDocument(), offset, end);
        try {
            this.scanner.getNextTag();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.scanner.getEventType() == 1) {
            return this.scanner.getStartOffset();
        }
        return -1;
    }

    private int getEndTagLocation(int startTagLocation, int endOffset) {
        this.scanner.setValid(false);
        XMLViewUtilities.updateScanner(this.scanner, this.editor.getDocument(), startTagLocation, endOffset);
        int startTags = 1;
        do {
            int event = -1;
            try {
                event = this.scanner.getNextTag();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (event == 1) {
                ++startTags;
                continue;
            }
            if (event != 2) continue;
            --startTags;
        } while (startTags > 0 && this.scanner.getEndOffset() < endOffset && this.scanner.token != null);
        if (startTags == 0) {
            return this.scanner.getStartOffset();
        }
        return endOffset;
    }
}

