/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.model;

import com.xk72.charles.model.Host;
import com.xk72.charles.model.ModelNode;
import com.xk72.net.Location;
import java.net.URL;

public class Path
extends ModelNode {
    private static final long serialVersionUID = 7188669661629736221L;
    private String pathName;

    public synchronized Path getOrConstructPathByName(String string) {
        if (this.children != null) {
            for (ModelNode modelNode : this.children) {
                Path path;
                if (!(modelNode instanceof Path) || !(path = (Path)modelNode).getPathName().equals(string)) continue;
                return path;
            }
        }
        Path path = new Path();
        path.setPathName(string);
        this.addChild(path);
        return path;
    }

    public Host getHost() {
        Path path;
        for (path = this; !(path instanceof Host) && path != null; path = (Path)path.getParent()) {
        }
        return (Host)path;
    }

    public String getFullPathName() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Path path = this; !(path instanceof Host) && path != null; path = (Path)path.getParent()) {
            stringBuffer.insert(0, '/');
            stringBuffer.insert(0, path.getPathName());
        }
        stringBuffer.insert(0, '/');
        return stringBuffer.toString();
    }

    @Override
    public boolean removeChild(ModelNode modelNode) {
        boolean bl = super.removeChild(modelNode);
        if (bl && this.isEmpty()) {
            this.remove();
        }
        return bl;
    }

    @Override
    public String toString() {
        return this.pathName;
    }

    public String getPathName() {
        return this.pathName;
    }

    public void setPathName(String string) {
        this.pathName = string;
    }

    public URL toURL() {
        Host host = this.getHost();
        if (host != null) {
            URL uRL = host.toURL();
            if (uRL != null) {
                return new URL(uRL, this.getFullPathName());
            }
            return null;
        }
        return null;
    }

    @Override
    public Location toLocation() {
        Host host = this.getHost();
        if (host != null) {
            return new Location(host.getProtocol(), host.getHostName(), host.getActualPort(), this.getFullPathName() + "*");
        }
        return null;
    }
}

