/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.config.UserInterfaceConfiguration;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.settings.SettingsPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;

public class ViewersSettingsPanel
extends SettingsPanel {
    private final JCheckBox bShowLineNumbers = new JCheckBox("Show line numbers");
    private final JCheckBox bLineWrap = new JCheckBox("Line wrap");
    private final JRadioButton rSessionNavStructureHorizontal = new JRadioButton("Tall");
    private final JRadioButton rSessionNavStructureVertical = new JRadioButton("Wide");
    private final JRadioButton rSessionNavSequenceVertical = new JRadioButton("Wide");
    private final JCheckBox bCombineHeadersAndBodyViewers = new JCheckBox("Combine header and body viewers");
    private final JCheckBox bCombineRequestAndResponse = new JCheckBox("Combine request and response");
    private final JComboBox<String> cTime;
    private final JComboBox<String> cSpeed;
    private final JRadioButton rSessionNavSequenceHorizontal = new JRadioButton("Tall");

    public ViewersSettingsPanel() {
        super("Viewers");
        UserInterfaceConfiguration userInterfaceConfiguration = this.ctx.getConfiguration().getUserInterfaceConfiguration();
        this.bShowLineNumbers.setSelected(userInterfaceConfiguration.isShowLineNumbers());
        this.bLineWrap.setSelected(userInterfaceConfiguration.isLineWrap());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rSessionNavStructureHorizontal);
        buttonGroup.add(this.rSessionNavStructureVertical);
        this.rSessionNavStructureHorizontal.setSelected(userInterfaceConfiguration.getSessionNavStructureLayout() == 0);
        this.rSessionNavStructureVertical.setSelected(userInterfaceConfiguration.getSessionNavStructureLayout() == 1);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.rSessionNavSequenceHorizontal);
        buttonGroup2.add(this.rSessionNavSequenceVertical);
        this.rSessionNavSequenceHorizontal.setSelected(userInterfaceConfiguration.getSessionNavSequenceLayout() == 0);
        this.rSessionNavSequenceVertical.setSelected(userInterfaceConfiguration.getSessionNavSequenceLayout() == 1);
        this.bCombineHeadersAndBodyViewers.setSelected(userInterfaceConfiguration.isCombineHeadersAndBody());
        this.bCombineRequestAndResponse.setSelected(userInterfaceConfiguration.isCombineRequestAndResponse());
        this.cSpeed = new JComboBox();
        this.cSpeed.addItem("bytes / second");
        this.cSpeed.addItem("bits / second");
        this.cSpeed.setSelectedIndex(userInterfaceConfiguration.getUnitsSpeed());
        this.cTime = new JComboBox();
        this.cTime.addItem("minutes and seconds");
        this.cTime.addItem("milliseconds");
        this.cTime.setSelectedIndex(userInterfaceConfiguration.getUnitsTime());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("wrap, fillx, ins 0", "[label][fill][fill,grow]", "[]u[]"));
        jPanel.add((Component)this.bCombineHeadersAndBodyViewers, "skip, span");
        jPanel.add((Component)this.bCombineRequestAndResponse, "skip, span");
        jPanel.add(new JLabel("Structure view layout:"));
        jPanel.add(this.rSessionNavStructureHorizontal);
        jPanel.add(this.rSessionNavStructureVertical);
        jPanel.add(new JLabel("Sequence view layout:"));
        jPanel.add(this.rSessionNavSequenceHorizontal);
        jPanel.add(this.rSessionNavSequenceVertical);
        FormUtils.AmNw(jPanel);
        jPanel.add((Component)this.bShowLineNumbers, "skip, span");
        jPanel.add((Component)this.bLineWrap, "skip, span");
        FormUtils.AmNw(jPanel);
        jPanel.add(new JLabel("Speed:"));
        jPanel.add(this.cSpeed, "span");
        jPanel.add(new JLabel("Time:"));
        jPanel.add(this.cTime, "span");
        this.add(jPanel);
    }

    public static void main(String[] stringArray) {
        new ViewersSettingsPanel().test();
    }

    @Override
    public boolean save() {
        UserInterfaceConfiguration userInterfaceConfiguration = this.ctx.getConfiguration().getUserInterfaceConfiguration();
        userInterfaceConfiguration.setShowLineNumbers(this.bShowLineNumbers.isSelected());
        userInterfaceConfiguration.setLineWrap(this.bLineWrap.isSelected());
        userInterfaceConfiguration.setSessionNavStructureLayout(this.rSessionNavStructureHorizontal.isSelected() ? 0 : 1);
        userInterfaceConfiguration.setSessionNavSequenceLayout(this.rSessionNavSequenceHorizontal.isSelected() ? 0 : 1);
        userInterfaceConfiguration.setCombineHeadersAndBody(this.bCombineHeadersAndBodyViewers.isSelected());
        userInterfaceConfiguration.setCombineRequestAndResponse(this.bCombineRequestAndResponse.isSelected());
        userInterfaceConfiguration.setUnitsSpeed(this.cSpeed.getSelectedIndex());
        userInterfaceConfiguration.setUnitsTime(this.cTime.getSelectedIndex());
        return true;
    }
}

