/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.config.LocationPatternConfiguration;
import com.xk72.charles.config.ProxyConfiguration;
import com.xk72.charles.gui.lib.EnableAwareJPanel;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.lib.LocationsTableHelper;
import com.xk72.charles.gui.lib.LocationsTableHelper$Mode;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.tools.gui.avKp;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;

class SSLProxyingPanel
extends SettingsPanel {
    private final avKp modePanel;
    private final LocationsTableHelper locations;
    private final LocationsTableHelper exclude;

    public SSLProxyingPanel() {
        super(CharlesContext.getInstance().getBundle().getString("settings.proxy.ssl.name"));
        this.setHelp(this.ctx.getBundle().getString("settings.proxy.ssl.help"));
        ProxyConfiguration proxyConfiguration = this.ctx.getConfiguration().getProxyConfiguration();
        this.modePanel = new avKp("SSL Proxying", 1);
        this.locations = new LocationsTableHelper(proxyConfiguration.getSSLLocations().getLocationPatterns(), LocationsTableHelper$Mode.aXgD);
        this.exclude = new LocationsTableHelper(proxyConfiguration.getSSLExcludeLocations().getLocationPatterns(), LocationsTableHelper$Mode.aXgD);
        EnableAwareJPanel enableAwareJPanel = new EnableAwareJPanel((LayoutManager)new MigLayout("wrap,fill,ins 0", "[][]", "[][fill,grow]"));
        enableAwareJPanel.add(new JLabel("Include"));
        enableAwareJPanel.add(new JLabel("Exclude"));
        this.locations.AmNw(enableAwareJPanel);
        this.exclude.AmNw(enableAwareJPanel);
        this.modePanel.AmNw(this.locations);
        this.modePanel.AmNw(this.exclude);
        this.modePanel.AmNw(enableAwareJPanel, false);
        this.configure(proxyConfiguration);
        this.add(FormUtils.aXgD(this.ctx.getBundle().getString("settings.proxy.ssl.blurb")));
        this.add(this.modePanel.AmNw());
        this.add((Component)enableAwareJPanel, "grow, push");
    }

    void configure(ProxyConfiguration proxyConfiguration) {
        this.modePanel.AmNw(proxyConfiguration.isDecryptSSL());
    }

    @Override
    public boolean save() {
        ProxyConfiguration proxyConfiguration = this.ctx.getConfiguration().getProxyConfiguration();
        proxyConfiguration.setDecryptSSL(this.modePanel.MOou());
        proxyConfiguration.setSSLLocations(new LocationPatternConfiguration(this.locations.OBgP().getRows()));
        proxyConfiguration.setSSLExcludeLocations(new LocationPatternConfiguration(this.exclude.OBgP().getRows()));
        CharlesContext.getInstance().getProxyManager().fJhh();
        return true;
    }

    public void updateForm() {
    }
}

