/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.config.GistIntegrationConfiguration;
import com.xk72.charles.gui.lib.EnableAwareJLabel;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.settings.DTlZ;
import com.xk72.charles.gui.settings.GistIntegrationSettingsPanel$2;
import com.xk72.charles.gui.settings.GistIntegrationSettingsPanel$3;
import com.xk72.charles.gui.settings.ImportExportPanel;
import com.xk72.charles.gui.settings.SettingsException;
import com.xk72.charles.gui.settings.SettingsPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class GistIntegrationSettingsPanel
extends SettingsPanel
implements ImportExportPanel<GistIntegrationConfiguration> {
    private static final Logger AmNw = Logger.getLogger("com.xk72.charles.gui.settings.GistIntegrationSettingsPanel");
    private static final URI MOou;
    private static final String aXgD = "You have a saved authorisation token for your current GitHub server.  This token will not be valid for other GitHub installations.";
    private static final String rnqJ = "You need to manually generate a personal access token from your enterprise GitHub account. You can then copy and paste that token below to allow Charles to publish gists on your behalf.";
    private final JCheckBox openGist = new JCheckBox("Open Gist after publishing");
    private final JRadioButton secret = new JRadioButton("Secret", true);
    private final JRadioButton pub = new JRadioButton("Public", false);
    private final JTextField publishLimit = new JTextField(7);
    private final JComponent tokenMessage = FormUtils.aXgD("Charles is authorized to publish to your GitHub account.");
    private final JComponent requestTokenMessage = FormUtils.aXgD("You must authorize Charles to publish Gists using your GitHub account. This will open GitHub.com where you can grant Charles access to publish with your account.");
    private final JButton requestToken;
    private final JButton clearToken;
    private final JLabel token = new JLabel();
    private final JCheckBox enterpriseGitHub = new JCheckBox("Use GitHub Enterprise");
    private final JTextField enterpriseURL = new JTextField(20);

    public GistIntegrationSettingsPanel() {
        super("Publish");
        JPanel jPanel = new JPanel(FormUtils.fUWl());
        JPanel jPanel2 = new JPanel(FormUtils.aXgD());
        jPanel.add((Component)jPanel2, "span, growx");
        FormUtils.AmNw(jPanel);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.secret);
        buttonGroup.add(this.pub);
        jPanel.add(new JLabel("Publish as:"));
        jPanel.add((Component)this.secret, "split 2, grow 0");
        jPanel.add(this.pub);
        jPanel.add(new JLabel("Publish limit (MB):"));
        jPanel.add((Component)this.publishLimit, "grow 0");
        jPanel.add((Component)this.openGist, "skip");
        jPanel.add((Component)this.enterpriseGitHub, "skip");
        this.enterpriseURL.setEnabled(this.enterpriseGitHub.isSelected());
        this.enterpriseGitHub.addItemListener(new DTlZ(this));
        jPanel.add(new EnableAwareJLabel("GitHub location:", this.enterpriseURL));
        jPanel.add(this.enterpriseURL);
        Font font = this.token.getFont();
        Font font2 = font.deriveFont(font.getSize2D() - 2.0f);
        this.token.setFont(font2);
        jPanel2.add((Component)this.tokenMessage, "split 2,hidemode 3,left,width 500lp!");
        this.clearToken = new JButton(new GistIntegrationSettingsPanel$2(this, "Deauthorize"));
        jPanel2.add((Component)this.clearToken, "hidemode 3, wmin button, growx 0");
        jPanel2.add((Component)this.requestTokenMessage, "hidemode 3,left, width 500lp!");
        this.requestToken = new JButton(new GistIntegrationSettingsPanel$3(this, "Authorize", font2));
        jPanel2.add((Component)this.requestToken, "hidemode 3, grow 0, wmin button");
        this.add(jPanel);
        GistIntegrationConfiguration gistIntegrationConfiguration = this.ctx.getConfiguration().getGistIntegrationConfiguration();
        this.setImportedConfiguration(gistIntegrationConfiguration);
    }

    private void AmNw(String string) {
        if (string == null || string.isEmpty()) {
            this.AmNw();
        } else {
            this.token.setText(string);
            this.tokenMessage.setVisible(true);
            this.token.setVisible(true);
            this.clearToken.setVisible(true);
            this.requestTokenMessage.setVisible(false);
            this.requestToken.setVisible(false);
            this.revalidate();
            Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this);
            if (dialog != null) {
                dialog.pack();
            }
        }
    }

    private void AmNw() {
        this.token.setText("");
        this.tokenMessage.setVisible(false);
        this.token.setVisible(false);
        this.clearToken.setVisible(false);
        this.requestTokenMessage.setVisible(true);
        this.requestToken.setVisible(true);
        this.revalidate();
        Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this);
        if (dialog != null) {
            dialog.pack();
        }
    }

    @Override
    public GistIntegrationConfiguration getExportConfiguration() {
        GistIntegrationConfiguration gistIntegrationConfiguration = new GistIntegrationConfiguration();
        this.AmNw(gistIntegrationConfiguration);
        return gistIntegrationConfiguration;
    }

    @Override
    public void setImportedConfiguration(GistIntegrationConfiguration gistIntegrationConfiguration) {
        this.openGist.setSelected(gistIntegrationConfiguration.isOpenGist());
        if (gistIntegrationConfiguration.isSecret()) {
            this.secret.setSelected(true);
        } else {
            this.pub.setSelected(true);
        }
        this.publishLimit.setText(String.valueOf(gistIntegrationConfiguration.getPublishLimit()));
        this.AmNw(GistIntegrationSettingsPanel.MOou(gistIntegrationConfiguration.getAuthToken()));
        this.enterpriseGitHub.setSelected(gistIntegrationConfiguration.isEnterpriseGitHub());
        this.enterpriseURL.setText(GistIntegrationSettingsPanel.MOou(gistIntegrationConfiguration.getEnterpriseURL()));
    }

    @Override
    public boolean preSave() {
        String string = "Publish Limit";
        int n = this.prefToInt("Publish Limit", this.publishLimit.getText());
        if (n < 0) {
            throw new SettingsException("Publish Limit", "Please enter a non-negative number.");
        }
        if (this.enterpriseGitHub.isSelected()) {
            String string2 = GistIntegrationSettingsPanel.aXgD(this.enterpriseURL.getText());
            if (string2 == null) {
                throw new SettingsException("GitHub Location", "Please enter a location for your installation e.g. https://api.github.com");
            }
            try {
                URI uRI = GistIntegrationConfiguration.parseURL(string2);
                String string3 = uRI.getPath();
                if (string3 != null && !string3.equals("/") && string3.length() > 0) {
                    throw new SettingsException("GitHub Location", "Please enter a valid location e.g. https://api.github.com");
                }
                String string4 = uRI.getQuery();
                if (string4 != null && string4.length() > 0) {
                    throw new SettingsException("GitHub Location", "Please enter a valid location e.g. https://api.github.com");
                }
                String string5 = uRI.getFragment();
                if (string5 != null && string5.length() > 0) {
                    throw new SettingsException("GitHub Location", "Please enter a valid location e.g. https://api.github.com");
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                AmNw.log(Level.WARNING, "Error parsing URI: " + uRISyntaxException.getMessage(), uRISyntaxException);
                throw new SettingsException("GitHub Location", "Please enter a valid location e.g. https://api.github.com");
            }
        }
        return super.preSave();
    }

    public void saveAuth() {
        GistIntegrationConfiguration gistIntegrationConfiguration = this.ctx.getConfiguration().getGistIntegrationConfiguration();
        gistIntegrationConfiguration.setAuthToken(GistIntegrationSettingsPanel.aXgD(this.token.getText()));
        this.ctx.saveConfig();
    }

    @Override
    public boolean save() {
        GistIntegrationConfiguration gistIntegrationConfiguration = this.ctx.getConfiguration().getGistIntegrationConfiguration();
        this.AmNw(gistIntegrationConfiguration);
        return true;
    }

    private void AmNw(GistIntegrationConfiguration gistIntegrationConfiguration) {
        gistIntegrationConfiguration.setOpenGist(this.openGist.isSelected());
        gistIntegrationConfiguration.setSecret(this.secret.isSelected());
        gistIntegrationConfiguration.setPublishLimit(this.prefToIntSafe(this.publishLimit.getText()));
        gistIntegrationConfiguration.setAuthToken(GistIntegrationSettingsPanel.aXgD(this.token.getText()));
        gistIntegrationConfiguration.setEnterpriseGitHub(this.enterpriseGitHub.isSelected());
        gistIntegrationConfiguration.setEnterpriseURL(GistIntegrationSettingsPanel.aXgD(this.enterpriseURL.getText()));
    }

    private static String MOou(String string) {
        return string == null ? "" : string;
    }

    private static String aXgD(String string) {
        return string == null || string.length() == 0 ? null : string;
    }

    static {
        try {
            MOou = new URI("https://www.charlesproxy.com/github/auth.do");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }
}

