/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.navigator;

import com.xk72.charles.gui.navigator.FzFK;
import com.xk72.charles.gui.navigator.MhBt;
import com.xk72.charles.model.Ahdq;
import com.xk72.charles.model.ModelNode;
import com.xk72.charles.model.Session;
import com.xk72.charles.model.Transaction;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class NavigatorTransferHandler
extends TransferHandler {
    private static final Logger AmNw = Logger.getLogger("com.xk72.charles.gui.navigator.NavigatorTransferHandler");
    private static final DataFlavor MOou = new DataFlavor(Transaction.class, "Transaction");
    private final TransferHandler delegate;
    private final Session session;

    public NavigatorTransferHandler(TransferHandler transferHandler, Session session) {
        this.delegate = transferHandler;
        this.session = session;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (transferSupport.isDataFlavorSupported(MOou)) {
            return true;
        }
        return this.delegate != null && this.delegate.canImport(transferSupport);
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        Transferable transferable;
        Object object;
        if (this.delegate != null && (this.delegate.getSourceActions(jComponent) & 1) != 0) {
            object = new Clipboard("dummy");
            this.delegate.exportToClipboard(jComponent, (Clipboard)object, 1);
            transferable = ((Clipboard)object).getContents(null);
        } else {
            transferable = null;
        }
        object = this.AmNw(jComponent);
        return new MhBt(this, transferable, (List)object);
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n == 2) {
            try {
                List list = (List)transferable.getTransferData(MOou);
                for (Transaction transaction : list) {
                    transaction.remove();
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                AmNw.log(Level.WARNING, "Error exporting transaction data", unsupportedFlavorException);
            }
            catch (IOException iOException) {
                AmNw.log(Level.WARNING, "Error exporting transaction data", iOException);
            }
        }
    }

    private List<Transaction> AmNw(JComponent jComponent) {
        ModelNode[] modelNodeArray;
        FzFK fzFK = FzFK.AmNw(jComponent);
        if (fzFK != null && (modelNodeArray = (ModelNode[])fzFK.rnqJ()) != null) {
            Ahdq ahdq = new Ahdq();
            ahdq.AmNw(modelNodeArray);
            List<Transaction> list = ahdq.AmNw();
            Iterator<Transaction> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (this.AmNw(iterator.next())) continue;
                iterator.remove();
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        try {
            if (transferSupport.isDataFlavorSupported(MOou)) {
                List list = (List)transferSupport.getTransferable().getTransferData(MOou);
                for (Transaction transaction : list) {
                    Transaction transaction2 = (Transaction)transaction.clone();
                    this.session.addTransaction(transaction2);
                }
                return true;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            AmNw.log(Level.WARNING, "Error importing transaction data", unsupportedFlavorException);
        }
        catch (IOException iOException) {
            AmNw.log(Level.WARNING, "Error importing transaction data", iOException);
        }
        return false;
    }

    private boolean AmNw(Transaction transaction) {
        switch (transaction.getStatus()) {
            case fJhh: 
            case zLvx: 
            case ooyJ: {
                return true;
            }
        }
        return false;
    }
}

