/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.lib;

import com.xk72.charles.gui.lib.TableMap;
import com.xk72.charles.gui.lib.UKyo;
import com.xk72.charles.gui.lib.eWMa;
import com.xk72.charles.gui.lib.vBKw;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class TableSorter
extends TableMap {
    private static final Logger AmNw = Logger.getLogger("com.xk72.charles.gui.lib.TableSorter");
    private int[] indexes;
    private final Vector<Integer> sortingColumns = new Vector();
    private boolean ascending = true;
    private int compares;

    public TableSorter() {
        this.indexes = new int[0];
    }

    public TableSorter(TableModel tableModel) {
        this.setModel(tableModel);
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.reallocateIndexes();
    }

    public int compareRowsByColumn(int n, int n2, int n3) {
        String string;
        Class<?> clazz;
        Object object;
        Object object2;
        TableModel tableModel = this.model;
        if (tableModel instanceof UKyo) {
            object2 = ((UKyo)((Object)tableModel)).getComparableValueAt(n, n3);
            object = ((UKyo)((Object)tableModel)).getComparableValueAt(n2, n3);
            clazz = ((UKyo)((Object)tableModel)).getComparableColumnClass(n3);
        } else {
            object2 = tableModel.getValueAt(n, n3);
            object = tableModel.getValueAt(n2, n3);
            clazz = tableModel.getColumnClass(n3);
        }
        if (object2 == null && object == null) {
            return 0;
        }
        if (object2 == null) {
            return -1;
        }
        if (object == null) {
            return 1;
        }
        if (clazz.getSuperclass() == Number.class) {
            Number number;
            double d;
            Number number2 = (Number)object2;
            double d2 = number2.doubleValue();
            if (d2 < (d = (number = (Number)object).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        if (clazz == Date.class) {
            Date date;
            long l;
            Date date2 = (Date)object2;
            long l2 = date2.getTime();
            if (l2 < (l = (date = (Date)object).getTime())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
        if (clazz == String.class) {
            String string2 = (String)object2;
            String string3 = (String)object;
            int n4 = this.AmNw(string2, string3);
            if (n4 == 0) {
                n4 = string2.compareTo(string3);
            }
            if (n4 < 0) {
                return -1;
            }
            if (n4 > 0) {
                return 1;
            }
            return 0;
        }
        if (clazz == Boolean.class) {
            Boolean bl;
            boolean bl2;
            Boolean bl3 = (Boolean)object2;
            boolean bl4 = bl3;
            if (bl4 == (bl2 = (bl = (Boolean)object).booleanValue())) {
                return 0;
            }
            if (bl4) {
                return 1;
            }
            return -1;
        }
        String string4 = object2.toString();
        int n5 = string4.compareTo(string = object.toString());
        if (n5 < 0) {
            return -1;
        }
        if (n5 > 0) {
            return 1;
        }
        return 0;
    }

    private int AmNw(String string, String string2) {
        Double d;
        Double d2 = this.AmNw(string);
        if (d2 != null && (d = this.AmNw(string2)) != null) {
            return d2.compareTo(d);
        }
        return 0;
    }

    private Double AmNw(String string) {
        int n;
        for (int i = n = string.length(); i > 0; --i) {
            try {
                return Double.parseDouble(string.substring(0, i));
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
        }
        return null;
    }

    public int compare(int n, int n2) {
        ++this.compares;
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            Integer n3 = this.sortingColumns.elementAt(i);
            int n4 = this.compareRowsByColumn(n, n2, n3);
            if (n4 == 0) continue;
            return this.ascending ? n4 : -n4;
        }
        return 0;
    }

    public void reallocateIndexes() {
        int n = this.model.getRowCount();
        this.indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.indexes[i] = i;
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (AmNw.isLoggable(Level.FINER)) {
            AmNw.finer("Sorter: tableChanged");
        }
        this.reallocateIndexes();
        super.tableChanged(tableModelEvent);
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount() && AmNw.isLoggable(Level.WARNING)) {
            AmNw.warning("Sorter not informed of a change in model.");
        }
    }

    public void sort(Object object) {
        this.checkModel();
        this.compares = 0;
        int n = this.indexes.length;
        if (this.model instanceof vBKw) {
            n -= ((vBKw)this.model).getFooterRows();
        }
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, n);
        if (AmNw.isLoggable(Level.FINER)) {
            AmNw.finer("Compares: " + this.compares);
        }
    }

    public void n2sort() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.compare(this.indexes[i], this.indexes[j]) != -1) continue;
                this.swap(i, j);
            }
        }
    }

    public void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            for (int i = n; i < n2; ++i) {
                nArray2[i] = nArray[i];
            }
            return;
        }
        for (int i = n; i < n2; ++i) {
            nArray2[i] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
        }
    }

    public void swap(int n, int n2) {
        int n3 = this.indexes[n];
        this.indexes[n] = this.indexes[n2];
        this.indexes[n2] = n3;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n < 0) {
            return null;
        }
        this.checkModel();
        if (n < this.indexes.length) {
            return this.model.getValueAt(this.indexes[n], n2);
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.checkModel();
        if (n < this.indexes.length) {
            this.model.setValueAt(object, this.indexes[n], n2);
        }
    }

    public void sortByColumn(int n) {
        this.sortByColumn(n, true);
    }

    public void sortByColumn(int n, boolean bl) {
        this.ascending = bl;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(n);
        this.sort(this);
        super.tableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        TableSorter tableSorter = this;
        JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        eWMa eWMa2 = new eWMa(this, jTable2, tableSorter);
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(eWMa2);
    }
}

