/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

import * as msRest from "@azure/ms-rest-js";
import { TokenCredential } from "@azure/core-auth";
import * as Models from "./models";
import * as Mappers from "./models/mappers";
import * as operations from "./operations";
import { SubscriptionClientContext } from "./subscriptionClientContext";


class SubscriptionClient extends SubscriptionClientContext {
  // Operation groups
  subscriptions: operations.Subscriptions;
  tenants: operations.Tenants;
  subscription: operations.SubscriptionOperations;
  operations: operations.Operations;
  alias: operations.Alias;

  /**
   * Initializes a new instance of the SubscriptionClient class.
   * @param credentials Credentials needed for the client to connect to Azure. Credentials
   * implementing the TokenCredential interface from the @azure/identity package are recommended. For
   * more information about these credentials, see
   * {@link https://www.npmjs.com/package/@azure/identity}. Credentials implementing the
   * ServiceClientCredentials interface from the older packages @azure/ms-rest-nodeauth and
   * @azure/ms-rest-browserauth are also supported.
   * @param [options] The parameter options
   */
  constructor(credentials: msRest.ServiceClientCredentials | TokenCredential, options?: Models.SubscriptionClientOptions) {
    super(credentials, options);
    this.subscriptions = new operations.Subscriptions(this);
    this.tenants = new operations.Tenants(this);
    this.subscription = new operations.SubscriptionOperations(this);
    this.operations = new operations.Operations(this);
    this.alias = new operations.Alias(this);
  }
}

// Operation Specifications

export {
  SubscriptionClient,
  SubscriptionClientContext,
  Models as SubscriptionModels,
  Mappers as SubscriptionMappers
};
export * from "./operations";
