/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
import { __assign } from "tslib";
import * as msRest from "@azure/ms-rest-js";
import * as Mappers from "../models/aliasMappers";
import * as Parameters from "../models/parameters";
/** Class representing a Alias. */
var Alias = /** @class */ (function () {
    /**
     * Create a Alias.
     * @param {SubscriptionClientContext} client Reference to the service client.
     */
    function Alias(client) {
        this.client = client;
    }
    /**
     * Create Alias Subscription.
     * @param aliasName Alias Name
     * @param body
     * @param [options] The optional parameters
     * @returns Promise<Models.AliasCreateResponse>
     */
    Alias.prototype.create = function (aliasName, body, options) {
        return this.beginCreate(aliasName, body, options)
            .then(function (lroPoller) { return lroPoller.pollUntilFinished(); });
    };
    Alias.prototype.get = function (aliasName, options, callback) {
        return this.client.sendOperationRequest({
            aliasName: aliasName,
            options: options
        }, getOperationSpec, callback);
    };
    Alias.prototype.deleteMethod = function (aliasName, options, callback) {
        return this.client.sendOperationRequest({
            aliasName: aliasName,
            options: options
        }, deleteMethodOperationSpec, callback);
    };
    Alias.prototype.list = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, listOperationSpec, callback);
    };
    /**
     * Create Alias Subscription.
     * @param aliasName Alias Name
     * @param body
     * @param [options] The optional parameters
     * @returns Promise<msRestAzure.LROPoller>
     */
    Alias.prototype.beginCreate = function (aliasName, body, options) {
        return this.client.sendLRORequest({
            aliasName: aliasName,
            body: body,
            options: options
        }, beginCreateOperationSpec, options);
    };
    return Alias;
}());
export { Alias };
// Operation Specifications
var serializer = new msRest.Serializer(Mappers);
var getOperationSpec = {
    httpMethod: "GET",
    path: "providers/Microsoft.Subscription/aliases/{aliasName}",
    urlParameters: [
        Parameters.aliasName
    ],
    queryParameters: [
        Parameters.apiVersion1
    ],
    headerParameters: [
        Parameters.acceptLanguage
    ],
    responses: {
        200: {
            bodyMapper: Mappers.PutAliasResponse
        },
        default: {
            bodyMapper: Mappers.ErrorResponseBody
        }
    },
    serializer: serializer
};
var deleteMethodOperationSpec = {
    httpMethod: "DELETE",
    path: "providers/Microsoft.Subscription/aliases/{aliasName}",
    urlParameters: [
        Parameters.aliasName
    ],
    queryParameters: [
        Parameters.apiVersion1
    ],
    headerParameters: [
        Parameters.acceptLanguage
    ],
    responses: {
        200: {},
        204: {},
        default: {
            bodyMapper: Mappers.ErrorResponseBody
        }
    },
    serializer: serializer
};
var listOperationSpec = {
    httpMethod: "GET",
    path: "providers/Microsoft.Subscription/aliases",
    queryParameters: [
        Parameters.apiVersion1
    ],
    headerParameters: [
        Parameters.acceptLanguage
    ],
    responses: {
        200: {
            bodyMapper: Mappers.PutAliasListResult
        },
        default: {
            bodyMapper: Mappers.ErrorResponseBody
        }
    },
    serializer: serializer
};
var beginCreateOperationSpec = {
    httpMethod: "PUT",
    path: "providers/Microsoft.Subscription/aliases/{aliasName}",
    urlParameters: [
        Parameters.aliasName
    ],
    queryParameters: [
        Parameters.apiVersion1
    ],
    headerParameters: [
        Parameters.acceptLanguage
    ],
    requestBody: {
        parameterPath: "body",
        mapper: __assign(__assign({}, Mappers.PutAliasRequest), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.PutAliasResponse
        },
        201: {
            bodyMapper: Mappers.PutAliasResponse
        },
        default: {
            bodyMapper: Mappers.ErrorResponseBody
        }
    },
    serializer: serializer
};
//# sourceMappingURL=alias.js.map