# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ApiCollection(Resource):  # pylint: disable=too-many-instance-attributes
    """An API collection as represented by Microsoft Defender for APIs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Gets the provisioning state of the API collection. Known values are:
     "Succeeded", "Failed", "Canceled", and "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.security.v2023_11_15.models.ProvisioningState
    :ivar display_name: The display name of the API collection.
    :vartype display_name: str
    :ivar discovered_via: The resource Id of the resource from where this API collection was
     discovered.
    :vartype discovered_via: str
    :ivar base_url: The base URI for this API collection. All endpoints of this API collection
     extend this base URI.
    :vartype base_url: str
    :ivar number_of_api_endpoints: The number of API endpoints discovered in this API collection.
    :vartype number_of_api_endpoints: int
    :ivar number_of_inactive_api_endpoints: The number of API endpoints in this API collection that
     have not received any API traffic in the last 30 days.
    :vartype number_of_inactive_api_endpoints: int
    :ivar number_of_unauthenticated_api_endpoints: The number of API endpoints in this API
     collection that are unauthenticated.
    :vartype number_of_unauthenticated_api_endpoints: int
    :ivar number_of_external_api_endpoints: The number of API endpoints in this API collection for
     which API traffic from the internet was observed.
    :vartype number_of_external_api_endpoints: int
    :ivar number_of_api_endpoints_with_sensitive_data_exposed: The number of API endpoints in this
     API collection which are exposing sensitive data in their requests and/or responses.
    :vartype number_of_api_endpoints_with_sensitive_data_exposed: int
    :ivar sensitivity_label: The highest priority sensitivity label from Microsoft Purview in this
     API collection.
    :vartype sensitivity_label: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "display_name": {"readonly": True},
        "discovered_via": {"readonly": True},
        "base_url": {"readonly": True},
        "number_of_api_endpoints": {"readonly": True},
        "number_of_inactive_api_endpoints": {"readonly": True},
        "number_of_unauthenticated_api_endpoints": {"readonly": True},
        "number_of_external_api_endpoints": {"readonly": True},
        "number_of_api_endpoints_with_sensitive_data_exposed": {"readonly": True},
        "sensitivity_label": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "discovered_via": {"key": "properties.discoveredVia", "type": "str"},
        "base_url": {"key": "properties.baseUrl", "type": "str"},
        "number_of_api_endpoints": {"key": "properties.numberOfApiEndpoints", "type": "int"},
        "number_of_inactive_api_endpoints": {"key": "properties.numberOfInactiveApiEndpoints", "type": "int"},
        "number_of_unauthenticated_api_endpoints": {
            "key": "properties.numberOfUnauthenticatedApiEndpoints",
            "type": "int",
        },
        "number_of_external_api_endpoints": {"key": "properties.numberOfExternalApiEndpoints", "type": "int"},
        "number_of_api_endpoints_with_sensitive_data_exposed": {
            "key": "properties.numberOfApiEndpointsWithSensitiveDataExposed",
            "type": "int",
        },
        "sensitivity_label": {"key": "properties.sensitivityLabel", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.display_name = None
        self.discovered_via = None
        self.base_url = None
        self.number_of_api_endpoints = None
        self.number_of_inactive_api_endpoints = None
        self.number_of_unauthenticated_api_endpoints = None
        self.number_of_external_api_endpoints = None
        self.number_of_api_endpoints_with_sensitive_data_exposed = None
        self.sensitivity_label = None


class ApiCollectionList(_serialization.Model):
    """Page of a list of API collections as represented by Microsoft Defender for APIs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: API collections in this page.
    :vartype value: list[~azure.mgmt.security.v2023_11_15.models.ApiCollection]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ApiCollection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2023_11_15.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.security.v2023_11_15.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.security.v2023_11_15.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.security.v2023_11_15.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error
