/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder$;
import org.apache.spark.sql.execution.streaming.TWSMetricsUtils$;
import org.apache.spark.sql.execution.streaming.ValueStateImpl$;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.streaming.ValueState;
import org.slf4j.Logger;
import scala.Function0;
import scala.StringContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001B\n\u0015\u0001\u0005B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003T\u0011!a\u0006A!A!\u0002\u0013i\u0006\"\u00024\u0001\t\u00039\u0007bB8\u0001\u0005\u0004%I\u0001\u001d\u0005\u0007i\u0002\u0001\u000b\u0011B9\t\u000bU\u0004A\u0011\u0002<\t\u000bi\u0004A\u0011I>\t\r}\u0004A\u0011IA\u0001\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bAa!a\u0003\u0001\t\u00032x!CA\u0007)\u0005\u0005\t\u0012AA\b\r!\u0019B#!A\t\u0002\u0005E\u0001B\u00024\u0010\t\u0003\t\u0019\u0003C\u0005\u0002&=\t\n\u0011\"\u0001\u0002(!I\u0011\u0011I\b\u0002\u0002\u0013%\u00111\t\u0002\u000f-\u0006dW/Z*uCR,\u0017*\u001c9m\u0015\t)b#A\u0005tiJ,\u0017-\\5oO*\u0011q\u0003G\u0001\nKb,7-\u001e;j_:T!!\u0007\u000e\u0002\u0007M\fHN\u0003\u0002\u001c9\u0005)1\u000f]1sW*\u0011QDH\u0001\u0007CB\f7\r[3\u000b\u0003}\t1a\u001c:h\u0007\u0001)\"A\t\u0019\u0014\t\u0001\u0019\u0013&\u000f\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0007)bc&D\u0001,\u0015\t)\u0002$\u0003\u0002.W\tQa+\u00197vKN#\u0018\r^3\u0011\u0005=\u0002D\u0002\u0001\u0003\u0006c\u0001\u0011\rA\r\u0002\u0002'F\u00111G\u000e\t\u0003IQJ!!N\u0013\u0003\u000f9{G\u000f[5oOB\u0011AeN\u0005\u0003q\u0015\u00121!\u00118z!\tQT(D\u0001<\u0015\ta$$\u0001\u0005j]R,'O\\1m\u0013\tq4HA\u0004M_\u001e<\u0017N\\4\u0002\u000bM$xN]3\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r#\u0012!B:uCR,\u0017BA#C\u0005)\u0019F/\u0019;f'R|'/Z\u0001\ngR\fG/\u001a(b[\u0016\u0004\"\u0001S(\u000f\u0005%k\u0005C\u0001&&\u001b\u0005Y%B\u0001'!\u0003\u0019a$o\\8u}%\u0011a*J\u0001\u0007!J,G-\u001a4\n\u0005A\u000b&AB*ue&twM\u0003\u0002OK\u0005Q1.Z=FqB\u0014XI\\2\u0011\u0007QKf'D\u0001V\u0015\t1v+\u0001\u0005f]\u000e|G-\u001a:t\u0015\tA\u0006$\u0001\u0005dCR\fG._:u\u0013\tQVKA\tFqB\u0014Xm]:j_:,enY8eKJ\f!B^1m\u000b:\u001cw\u000eZ3s\u0003\u001diW\r\u001e:jGN\u0004B\u0001\u00130HA&\u0011q,\u0015\u0002\u0004\u001b\u0006\u0004\bCA1e\u001b\u0005\u0011'BA2\u0017\u0003\u0019iW\r\u001e:jG&\u0011QM\u0019\u0002\n'FcU*\u001a;sS\u000e\fa\u0001P5oSRtDC\u00025kW2lg\u000eE\u0002j\u00019j\u0011\u0001\u0006\u0005\u0006\u007f\u0019\u0001\r\u0001\u0011\u0005\u0006\r\u001a\u0001\ra\u0012\u0005\u0006%\u001a\u0001\ra\u0015\u0005\u00067\u001a\u0001\ra\u0015\u0005\b9\u001a\u0001\n\u00111\u0001^\u0003E\u0019H/\u0019;f)f\u0004Xm]#oG>$WM]\u000b\u0002cB\u0019\u0011N\u001d\u001c\n\u0005M$\"!E*uCR,G+\u001f9fg\u0016s7m\u001c3fe\u0006\u00112\u000f^1uKRK\b/Z:F]\u000e|G-\u001a:!\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0002oB\u0011A\u0005_\u0005\u0003s\u0016\u0012A!\u00168ji\u00061Q\r_5tiN$\u0012\u0001 \t\u0003IuL!A`\u0013\u0003\u000f\t{w\u000e\\3b]\u0006\u0019q-\u001a;\u0015\u00039\na!\u001e9eCR,GcA<\u0002\b!1\u0011\u0011\u0002\u0007A\u00029\n\u0001B\\3x'R\fG/Z\u0001\u0006G2,\u0017M]\u0001\u000f-\u0006dW/Z*uCR,\u0017*\u001c9m!\tIwb\u0005\u0003\u0010G\u0005M\u0001\u0003BA\u000b\u0003?i!!a\u0006\u000b\t\u0005e\u00111D\u0001\u0003S>T!!!\b\u0002\t)\fg/Y\u0005\u0005\u0003C\t9B\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002\u0010\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*B!!\u000b\u0002@U\u0011\u00111\u0006\u0016\u0004;\u000652FAA\u0018!\u0011\t\t$a\u000f\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005eR%\u0001\u0006b]:|G/\u0019;j_:LA!!\u0010\u00024\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000bE\n\"\u0019\u0001\u001a\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005\u0015\u0003\u0003BA$\u0003\u001bj!!!\u0013\u000b\t\u0005-\u00131D\u0001\u0005Y\u0006tw-\u0003\u0003\u0002P\u0005%#AB(cU\u0016\u001cG\u000f")
public class ValueStateImpl<S>
implements ValueState<S>,
Logging {
    private final StateStore store;
    private final String stateName;
    private final ExpressionEncoder<Object> keyExprEnc;
    private final ExpressionEncoder<Object> valEncoder;
    private final scala.collection.immutable.Map<String, SQLMetric> metrics;
    private final StateTypesEncoder<Object> stateTypesEncoder;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <S> scala.collection.immutable.Map<String, SQLMetric> $lessinit$greater$default$5() {
        return ValueStateImpl$.MODULE$.$lessinit$greater$default$5();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StateTypesEncoder<Object> stateTypesEncoder() {
        return this.stateTypesEncoder;
    }

    private void initialize() {
        this.store.createColFamilyIfAbsent(this.stateName, this.keyExprEnc.schema(), this.valEncoder.schema(), new NoPrefixKeyStateEncoderSpec(this.keyExprEnc.schema()), this.store.createColFamilyIfAbsent$default$5(), this.store.createColFamilyIfAbsent$default$6());
    }

    public boolean exists() {
        return this.get() != null;
    }

    public S get() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
        if (retRow != null) {
            return (S)this.stateTypesEncoder().decodeValue(retRow);
        }
        return null;
    }

    public void update(S newState) {
        UnsafeRow encodedValue = this.stateTypesEncoder().encodeValue(newState);
        this.store.put(this.stateTypesEncoder().encodeGroupingKey(), encodedValue, this.stateName);
        TWSMetricsUtils$.MODULE$.incrementMetric(this.metrics, "numUpdatedStateRows", TWSMetricsUtils$.MODULE$.incrementMetric$default$3());
    }

    public void clear() {
        this.store.remove(this.stateTypesEncoder().encodeGroupingKey(), this.stateName);
        TWSMetricsUtils$.MODULE$.incrementMetric(this.metrics, "numRemovedStateRows", TWSMetricsUtils$.MODULE$.incrementMetric$default$3());
    }

    public ValueStateImpl(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, ExpressionEncoder<Object> valEncoder, scala.collection.immutable.Map<String, SQLMetric> metrics) {
        this.store = store;
        this.stateName = stateName;
        this.keyExprEnc = keyExprEnc;
        this.valEncoder = valEncoder;
        this.metrics = metrics;
        Logging.$init$((Logging)this);
        this.stateTypesEncoder = StateTypesEncoder$.MODULE$.apply(keyExprEnc, valEncoder, stateName, StateTypesEncoder$.MODULE$.apply$default$4());
        this.initialize();
    }
}

