/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringSplit$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.types.StringTypeBinaryLcase$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, regex, limit) - Splits `str` around occurrences that match `regex` and returns an array with a length of at most `limit`", arguments="\n    Arguments:\n      * str - a string expression to split.\n      * regex - a string representing a regular expression. The regex string should be a\n        Java regular expression.\n      * limit - an integer expression which controls the number of times the regex is applied.\n          * limit > 0: The resulting array's length will not be more than `limit`,\n            and the resulting array's last entry will contain all input\n            beyond the last matched regex.\n          * limit <= 0: `regex` will be applied as many times as possible, and\n            the resulting array can be of any size.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]');\n       [\"one\",\"two\",\"three\",\"\"]\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]', -1);\n       [\"one\",\"two\",\"three\",\"\"]\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]', 2);\n       [\"one\",\"twoBthreeC\"]\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u001db\u0001\u0002\u0014(\u0001RB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005V\u0001\tE\t\u0015!\u0003Q\u0011!1\u0006A!f\u0001\n\u0003y\u0005\u0002C,\u0001\u0005#\u0005\u000b\u0011\u0002)\t\u000ba\u0003A\u0011A-\t\u000by\u0003A\u0011I0\t\u000b\r\u0004A\u0011\t3\t\u000b-\u0004A\u0011\t7\t\u000bM\u0004A\u0011I(\t\u000bQ\u0004A\u0011I(\t\u000bU\u0004A\u0011I(\t\u0011Y\u0004\u0001R1A\u0005\u0006]DQ\u0001\u0017\u0001\u0005\u0002mDaa \u0001\u0005B\u0005\u0005\u0001bBA\t\u0001\u0011\u0005\u00131\u0003\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u001d\t\u0019\u0005\u0001C)\u0003\u000bB\u0011\"a\u0015\u0001\u0003\u0003%\t!!\u0016\t\u0013\u0005u\u0003!%A\u0005\u0002\u0005}\u0003\"CA;\u0001E\u0005I\u0011AA0\u0011%\t9\bAI\u0001\n\u0003\ty\u0006C\u0005\u0002z\u0001\t\t\u0011\"\u0011\u0002|!A\u00111\u0012\u0001\u0002\u0002\u0013\u0005q\u000fC\u0005\u0002\u000e\u0002\t\t\u0011\"\u0001\u0002\u0010\"I\u0011Q\u0013\u0001\u0002\u0002\u0013\u0005\u0013q\u0013\u0005\n\u0003K\u0003\u0011\u0011!C\u0001\u0003OC\u0011\"a+\u0001\u0003\u0003%\t%!,\t\u0013\u0005E\u0006!!A\u0005B\u0005Mv!CAoO\u0005\u0005\t\u0012AAp\r!1s%!A\t\u0002\u0005\u0005\bB\u0002-!\t\u0003\tI\u0010C\u0005\u0002|\u0002\n\t\u0011\"\u0012\u0002~\"I\u0011q \u0011\u0002\u0002\u0013\u0005%\u0011\u0001\u0005\n\u0005\u0013\u0001\u0013\u0011!CA\u0005\u0017A\u0011B!\b!\u0003\u0003%IAa\b\u0003\u0017M#(/\u001b8h'Bd\u0017\u000e\u001e\u0006\u0003Q%\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011!fK\u0001\tG\u0006$\u0018\r\\=ti*\u0011A&L\u0001\u0004gFd'B\u0001\u00180\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\u0004\u0001M)\u0001!N\u001d=\u0005B\u0011agN\u0007\u0002O%\u0011\u0001h\n\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001c;\u0013\tYtE\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u001d\u0001&o\u001c3vGR\u0004\"aQ&\u000f\u0005\u0011KeBA#I\u001b\u00051%BA$4\u0003\u0019a$o\\8u}%\tq(\u0003\u0002K}\u00059\u0001/Y2lC\u001e,\u0017B\u0001'N\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tQe(A\u0002tiJ,\u0012\u0001\u0015\t\u0003mEK!AU\u0014\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0003tiJ\u0004\u0013!\u0002:fO\u0016D\u0018A\u0002:fO\u0016D\b%A\u0003mS6LG/\u0001\u0004mS6LG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\ti[F,\u0018\t\u0003m\u0001AQAT\u0004A\u0002ACQ\u0001V\u0004A\u0002ACQAV\u0004A\u0002A\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001a!\ti\u0014-\u0003\u0002c}\t9!i\\8mK\u0006t\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\u0015\u0004\"AZ5\u000e\u0003\u001dT!\u0001[\u0016\u0002\u000bQL\b/Z:\n\u0005)<'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001n!\r\u0019e\u000e]\u0005\u0003_6\u00131aU3r!\t1\u0017/\u0003\u0002sO\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002\u0017\r|G\u000e\\1uS>t\u0017\nZ\u000b\u0002qB\u0011Q(_\u0005\u0003uz\u00121!\u00138u)\rQFP \u0005\u0006{>\u0001\r\u0001U\u0001\u0004Kb\u0004\b\"\u0002+\u0010\u0001\u0004\u0001\u0016\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003CA\u0002\u0003\u0013\ti!a\u0004\u0011\u0007u\n)!C\u0002\u0002\by\u00121!\u00118z\u0011\u001d\tY\u0001\u0005a\u0001\u0003\u0007\taa\u001d;sS:<\u0007B\u0002+\u0011\u0001\u0004\t\u0019\u0001\u0003\u0004W!\u0001\u0007\u00111A\u0001\nI><UM\\\"pI\u0016$b!!\u0006\u0002\"\u0005-\u0002\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005mq%A\u0004d_\u0012,w-\u001a8\n\t\u0005}\u0011\u0011\u0004\u0002\t\u000bb\u0004(oQ8eK\"9\u00111E\tA\u0002\u0005\u0015\u0012aA2uqB!\u0011qCA\u0014\u0013\u0011\tI#!\u0007\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011QF\tA\u0002\u0005U\u0011AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003g\u0001B!!\u000e\u0002>9!\u0011qGA\u001d!\t)e(C\u0002\u0002<y\na\u0001\u0015:fI\u00164\u0017\u0002BA \u0003\u0003\u0012aa\u0015;sS:<'bAA\u001e}\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\b5\u0006\u001d\u00131JA(\u0011\u0019\tIe\u0005a\u0001!\u0006Aa.Z<GSJ\u001cH\u000f\u0003\u0004\u0002NM\u0001\r\u0001U\u0001\n]\u0016<8+Z2p]\u0012Da!!\u0015\u0014\u0001\u0004\u0001\u0016\u0001\u00038foRC\u0017N\u001d3\u0002\t\r|\u0007/\u001f\u000b\b5\u0006]\u0013\u0011LA.\u0011\u001dqE\u0003%AA\u0002ACq\u0001\u0016\u000b\u0011\u0002\u0003\u0007\u0001\u000bC\u0004W)A\u0005\t\u0019\u0001)\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\r\u0016\u0004!\u0006\r4FAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=d(\u0001\u0006b]:|G/\u0019;j_:LA!a\u001d\u0002j\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002~A!\u0011qPAE\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015\u0001\u00027b]\u001eT!!a\"\u0002\t)\fg/Y\u0005\u0005\u0003\u007f\t\t)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\r\u0011\u0011\u0013\u0005\t\u0003'S\u0012\u0011!a\u0001q\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!'\u0011\r\u0005m\u0015\u0011UA\u0002\u001b\t\tiJC\u0002\u0002 z\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019+!(\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004A\u0006%\u0006\"CAJ9\u0005\u0005\t\u0019AA\u0002\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005u\u0014q\u0016\u0005\t\u0003'k\u0012\u0011!a\u0001q\u00061Q-];bYN$2\u0001YA[\u0011%\t\u0019JHA\u0001\u0002\u0004\t\u0019\u0001K\f\u0001\u0003s\u000by,!1\u0002F\u0006\u001d\u00171ZAg\u0003#\f\u0019.a6\u0002ZB\u0019a'a/\n\u0007\u0005uvEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\r\u0017!!\u0003`\rVs5i\u0018\u0015tiJd\u0003E]3hKbd\u0003\u0005\\5nSRL\u0003%\f\u0011Ta2LGo\u001d\u0011agR\u0014\b\rI1s_VtG\rI8dGV\u0014(/\u001a8dKN\u0004C\u000f[1uA5\fGo\u00195!AJ,w-\u001a=aA\u0005tG\r\t:fiV\u0014hn\u001d\u0011b]\u0002\n'O]1zA]LG\u000f\u001b\u0011bA1,gn\u001a;iA=4\u0007%\u0019;![>\u001cH\u000f\t1mS6LG\u000fY\u0001\nCJ<W/\\3oiN\f#!!3\u0002\t\u0003T\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:\u0004Co\u001c\u0011ta2LGO\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!e\u0016<W\r\u001f\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004#/\u001a9sKN,g\u000e^5oO\u0002\n\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]:\u0002C\u000b[3!e\u0016<W\r\u001f\u0011tiJLgn\u001a\u0011tQ>,H\u000e\u001a\u0011cK\u0002\n'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t&bm\u0006\u0004#/Z4vY\u0006\u0014\b%\u001a=qe\u0016\u001c8/[8o])\u0001\u0003\u0005\t\u0011!A)\u0002C.[7ji\u0002j\u0003%\u00198!S:$XmZ3sA\u0015D\bO]3tg&|g\u000eI<iS\u000eD\u0007eY8oiJ|Gn\u001d\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011uS6,7\u000f\t;iK\u0002\u0012XmZ3yA%\u001c\b%\u00199qY&,GM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001R\u0003\u0005\\5nSR\u0004c\b\t\u0019;AQCW\r\t:fgVdG/\u001b8hA\u0005\u0014(/Y=(g\u0002bWM\\4uQ\u0002:\u0018\u000e\u001c7!]>$\bEY3![>\u0014X\r\t;iC:\u0004\u0003\r\\5nSR\u0004GF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013M\u001c3!i\",\u0007E]3tk2$\u0018N\\4!CJ\u0014\u0018-_\u0014tA1\f7\u000f\u001e\u0011f]R\u0014\u0018\u0010I<jY2\u00043m\u001c8uC&t\u0007%\u00197mA%t\u0007/\u001e;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t2fs>tG\r\t;iK\u0002b\u0017m\u001d;![\u0006$8\r[3eAI,w-\u001a=/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003E\u000b\u0011mS6LG\u000f\t\u001f>AAR\u0004\u0005\u0019:fO\u0016D\b\rI<jY2\u0004#-\u001a\u0011baBd\u0017.\u001a3!CN\u0004S.\u00198zAQLW.Z:!CN\u0004\u0003o\\:tS\ndW\r\f\u0011b]\u0012T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AQDW\r\t:fgVdG/\u001b8hA\u0005\u0014(/Y=!G\u0006t\u0007EY3!_\u001a\u0004\u0013M\\=!g&TXM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002P\u0006\u0011)B\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(_:,\u0017\t^<p\u0005RD'/Z3DO1\u0002seW!C\u0007v;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\E=tWM\t\u0017#i^|'\u0005\f\u0012uQJ,WM\t\u0017#EuS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ8oK\u0006#xo\u001c\"uQJ,WmQ\u0014-A\u001dZ\u0016IQ\"^O1\u0002S&M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0013sN\\3#Y\t\"xo\u001c\u0012-EQD'/Z3#Y\t\u0012SL\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(_:,\u0017\t^<p\u0005RD'/Z3DO1\u0002seW!C\u0007v;C\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001Z&e\u001c8fE1\u0012Co^8Ci\"\u0014X-Z\"#;*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002V\u0006)\u0011GL\u001b/a\u0005)qM]8va\u0006\u0012\u00111\\\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\f'R\u0014\u0018N\\4Ta2LG\u000f\u0005\u00027AM)\u0001%a9\u0002pBA\u0011Q]Av!B\u0003&,\u0004\u0002\u0002h*\u0019\u0011\u0011\u001e \u0002\u000fI,h\u000e^5nK&!\u0011Q^At\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0003c\f90\u0004\u0002\u0002t*!\u0011Q_AC\u0003\tIw.C\u0002M\u0003g$\"!a8\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!! \u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fi\u0013\u0019A!\u0002\u0003\b!)aj\ta\u0001!\")Ak\ta\u0001!\")ak\ta\u0001!\u00069QO\\1qa2LH\u0003\u0002B\u0007\u00053\u0001R!\u0010B\b\u0005'I1A!\u0005?\u0005\u0019y\u0005\u000f^5p]B1QH!\u0006Q!BK1Aa\u0006?\u0005\u0019!V\u000f\u001d7fg!A!1\u0004\u0013\u0002\u0002\u0003\u0007!,A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\t\u0011\t\u0005}$1E\u0005\u0005\u0005K\t\tI\u0001\u0004PE*,7\r\u001e")
public class StringSplit
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private int collationId;
    private final Expression str;
    private final Expression regex;
    private final Expression limit;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringSplit x$0) {
        return StringSplit$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringSplit> tupled() {
        return StringSplit$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringSplit>>> curried() {
        return StringSplit$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression regex() {
        return this.regex;
    }

    public Expression limit() {
        return this.limit;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public DataType dataType() {
        return new ArrayType(this.str().dataType(), false);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeBinaryLcase$.MODULE$, (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.str();
    }

    @Override
    public Expression second() {
        return this.regex();
    }

    @Override
    public Expression third() {
        return this.limit();
    }

    private int collationId$lzycompute() {
        StringSplit stringSplit = this;
        synchronized (stringSplit) {
            if (!this.bitmap$0) {
                this.collationId = ((StringType)this.str().dataType()).collationId();
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Object nullSafeEval(Object string, Object regex, Object limit) {
        UTF8String pattern = CollationSupport.collationAwareRegex((UTF8String)((UTF8String)regex), (int)this.collationId());
        UTF8String[] strings = ((UTF8String)string).split(pattern, BoxesRunTime.unboxToInt((Object)limit));
        return new GenericArrayData(strings);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String arrayClass = GenericArrayData.class.getName();
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(str, regex, limit) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(ev.value() + " = new " + arrayClass + "(" + str + ".split(\n         |CollationSupport.collationAwareRegex(" + regex + ", " + this.collationId() + ")," + limit + "));")));
    }

    @Override
    public String prettyName() {
        return "split";
    }

    @Override
    public StringSplit withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringSplit copy(Expression str, Expression regex, Expression limit) {
        return new StringSplit(str, regex, limit);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.regex();
    }

    public Expression copy$default$3() {
        return this.limit();
    }

    @Override
    public String productPrefix() {
        return "StringSplit";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.regex();
            }
            case 2: {
                return this.limit();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringSplit;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "str";
            }
            case 1: {
                return "regex";
            }
            case 2: {
                return "limit";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringSplit)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringSplit stringSplit = (StringSplit)x$1;
        Expression expression = this.str();
        Expression expression2 = stringSplit.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regex();
        Expression expression4 = stringSplit.regex();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.limit();
        Expression expression6 = stringSplit.limit();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringSplit.canEqual(this)) return false;
        return true;
    }

    public StringSplit(Expression str, Expression regex, Expression limit) {
        this.str = str;
        this.regex = regex;
        this.limit = limit;
        ExpectsInputTypes.$init$(this);
    }

    public StringSplit(Expression exp, Expression regex) {
        this(exp, regex, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)-1)));
    }
}

