/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.guava.collect;

import java.util.ListIterator;
import org.sparkproject.connect.errorprone_annotations.CanIgnoreReturnValue;
import org.sparkproject.connect.guava.annotations.GwtCompatible;
import org.sparkproject.connect.guava.collect.ElementTypesAreNonnullByDefault;
import org.sparkproject.connect.guava.collect.ForwardingIterator;
import org.sparkproject.connect.guava.collect.ParametricNullness;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingListIterator<E>
extends ForwardingIterator<E>
implements ListIterator<E> {
    protected ForwardingListIterator() {
    }

    @Override
    protected abstract ListIterator<E> delegate();

    @Override
    public void add(@ParametricNullness E element) {
        this.delegate().add(element);
    }

    @Override
    public boolean hasPrevious() {
        return this.delegate().hasPrevious();
    }

    @Override
    public int nextIndex() {
        return this.delegate().nextIndex();
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public E previous() {
        return this.delegate().previous();
    }

    @Override
    public int previousIndex() {
        return this.delegate().previousIndex();
    }

    @Override
    public void set(@ParametricNullness E element) {
        this.delegate().set(element);
    }
}

