/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.CholeskySolver;
import org.apache.spark.ml.optim.QuasiNewtonSolver;
import org.apache.spark.ml.optim.SingularMatrixException;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquares$Auto$;
import org.apache.spark.ml.optim.WeightedLeastSquares$QuasiNewton$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.ml.util.OptionalInstrumentation;
import org.apache.spark.ml.util.OptionalInstrumentation$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.MavenUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\rd!B:u\u0001Yt\bBCA\u0013\u0001\t\u0015\r\u0011\"\u0001\u0002(!Q\u0011q\u0006\u0001\u0003\u0002\u0003\u0006I!!\u000b\t\u0015\u0005E\u0002A!b\u0001\n\u0003\t\u0019\u0004\u0003\u0006\u0002<\u0001\u0011\t\u0011)A\u0005\u0003kA!\"!\u0010\u0001\u0005\u000b\u0007I\u0011AA\u001a\u0011)\ty\u0004\u0001B\u0001B\u0003%\u0011Q\u0007\u0005\u000b\u0003\u0003\u0002!Q1A\u0005\u0002\u0005\u001d\u0002BCA\"\u0001\t\u0005\t\u0015!\u0003\u0002*!Q\u0011Q\t\u0001\u0003\u0006\u0004%\t!a\n\t\u0015\u0005\u001d\u0003A!A!\u0002\u0013\tI\u0003\u0003\u0006\u0002J\u0001\u0011)\u0019!C\u0001\u0003\u0017B!B!@\u0001\u0005\u0003\u0005\u000b\u0011BA'\u0011)\u0011y\u0010\u0001BC\u0002\u0013\u0005\u0011Q\u000e\u0005\u000b\u0007\u0003\u0001!\u0011!Q\u0001\n\u0005=\u0004BCB\u0002\u0001\t\u0015\r\u0011\"\u0001\u00024!Q1Q\u0001\u0001\u0003\u0002\u0003\u0006I!!\u000e\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0004\b!911\u0004\u0001\u0005\u0002\ru\u0001\"CB%\u0001E\u0005I\u0011AB&\u0011%\u0019y\u0005AI\u0001\n\u0003\u0011\u0019\u0010C\u0004\u0004R\u0001!Iaa\u0015\t\u000f\rm\u0003\u0001\"\u0003\u0004^\u001dA\u00111\u000b;\t\u0002Y\f)FB\u0004ti\"\u0005a/a\u0016\t\u000f\u0005\u001d\u0004\u0004\"\u0001\u0002j!I\u00111\u000e\rC\u0002\u0013\u0005\u0011Q\u000e\u0005\t\u0003kB\u0002\u0015!\u0003\u0002p\u0019I\u0011q\u000f\r\u0011\u0002G\u0005\u0012\u0011P\u0004\b\u0003oD\u0002\u0012QAG\r\u001d\ti\b\u0007EA\u0003\u007fBq!a\u001a\u001f\t\u0003\tY\tC\u0005\u0002\u0010z\t\t\u0011\"\u0011\u0002\u0012\"I\u0011q\u0014\u0010\u0002\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0003Cs\u0012\u0011!C\u0001\u0003GC\u0011\"a,\u001f\u0003\u0003%\t%!-\t\u0013\u0005}f$!A\u0005\u0002\u0005\u0005\u0007\"CAc=\u0005\u0005I\u0011IAd\u0011%\tIMHA\u0001\n\u0003\nY\rC\u0005\u0002Nz\t\t\u0011\"\u0003\u0002P\u001e9\u0011\u0011 \r\t\u0002\u0006ugaBAl1!\u0005\u0015\u0011\u001c\u0005\b\u0003OJC\u0011AAn\u0011%\ty)KA\u0001\n\u0003\n\t\nC\u0005\u0002 &\n\t\u0011\"\u0001\u0002n!I\u0011\u0011U\u0015\u0002\u0002\u0013\u0005\u0011q\u001c\u0005\n\u0003_K\u0013\u0011!C!\u0003cC\u0011\"a0*\u0003\u0003%\t!a9\t\u0013\u0005\u0015\u0017&!A\u0005B\u0005\u001d\u0007\"CAeS\u0005\u0005I\u0011IAf\u0011%\ti-KA\u0001\n\u0013\tymB\u0004\u0002|bA\t)!<\u0007\u000f\u0005\u001d\b\u0004#!\u0002j\"9\u0011q\r\u001b\u0005\u0002\u0005-\b\"CAHi\u0005\u0005I\u0011IAI\u0011%\ty\nNA\u0001\n\u0003\ti\u0007C\u0005\u0002\"R\n\t\u0011\"\u0001\u0002p\"I\u0011q\u0016\u001b\u0002\u0002\u0013\u0005\u0013\u0011\u0017\u0005\n\u0003\u007f#\u0014\u0011!C\u0001\u0003gD\u0011\"!25\u0003\u0003%\t%a2\t\u0013\u0005%G'!A\u0005B\u0005-\u0007\"CAgi\u0005\u0005I\u0011BAh\u0011%\ti\u0010\u0007b\u0001\n\u0003\ty\u0010\u0003\u0005\u0003\u000ea\u0001\u000b\u0011\u0002B\u0001\r\u0019\u0011y\u0001\u0007\u0003\u0003\u0012!9\u0011q\r!\u0005\u0002\tM\u0001\"\u0003B\f\u0001\u0002\u0007I\u0011AA\u0014\u0011%\u0011I\u0002\u0011a\u0001\n\u0003\u0011Y\u0002\u0003\u0005\u0003&\u0001\u0003\u000b\u0015BA\u0015\u0011-\u00119\u0003\u0011a\u0001\u0002\u0004%\t!!\u001c\t\u0017\t%\u0002\t1AA\u0002\u0013\u0005!1\u0006\u0005\f\u0005_\u0001\u0005\u0019!A!B\u0013\ty\u0007C\u0006\u00032\u0001\u0003\r\u00111A\u0005\u0002\tM\u0002b\u0003B\u001e\u0001\u0002\u0007\t\u0019!C\u0001\u0005{A1B!\u0011A\u0001\u0004\u0005\t\u0015)\u0003\u00036!Y!1\t!A\u0002\u0003\u0007I\u0011AA7\u0011-\u0011)\u0005\u0011a\u0001\u0002\u0004%\tAa\u0012\t\u0017\t-\u0003\t1A\u0001B\u0003&\u0011q\u000e\u0005\f\u0005\u001b\u0002\u0005\u0019!a\u0001\n\u0003\t\u0019\u0004C\u0006\u0003P\u0001\u0003\r\u00111A\u0005\u0002\tE\u0003b\u0003B+\u0001\u0002\u0007\t\u0011)Q\u0005\u0003kA1Ba\u0016A\u0001\u0004\u0005\r\u0011\"\u0003\u00024!Y!\u0011\f!A\u0002\u0003\u0007I\u0011\u0002B.\u0011-\u0011y\u0006\u0011a\u0001\u0002\u0003\u0006K!!\u000e\t\u0017\t\u0005\u0004\t1AA\u0002\u0013%\u00111\u0007\u0005\f\u0005G\u0002\u0005\u0019!a\u0001\n\u0013\u0011)\u0007C\u0006\u0003j\u0001\u0003\r\u0011!Q!\n\u0005U\u0002b\u0003B6\u0001\u0002\u0007\t\u0019!C\u0005\u0003gA1B!\u001cA\u0001\u0004\u0005\r\u0011\"\u0003\u0003p!Y!1\u000f!A\u0002\u0003\u0005\u000b\u0015BA\u001b\u0011-\u0011)\b\u0011a\u0001\u0002\u0004%IAa\u001e\t\u0017\t\u0015\u0005\t1AA\u0002\u0013%!q\u0011\u0005\f\u0005\u0017\u0003\u0005\u0019!A!B\u0013\u0011I\bC\u0006\u0003\u000e\u0002\u0003\r\u00111A\u0005\n\t]\u0004b\u0003BH\u0001\u0002\u0007\t\u0019!C\u0005\u0005#C1B!&A\u0001\u0004\u0005\t\u0015)\u0003\u0003z!Y!q\u0013!A\u0002\u0003\u0007I\u0011\u0002B<\u0011-\u0011I\n\u0011a\u0001\u0002\u0004%IAa'\t\u0017\t}\u0005\t1A\u0001B\u0003&!\u0011\u0010\u0005\b\u0005C\u0003E\u0011\u0002BR\u0011\u001d\u00119\u000b\u0011C\u0001\u0005SCqA!0A\t\u0003\u0011y\fC\u0004\u0003F\u0002#\tAa2\t\u000f\t%\u0007\t\"\u0001\u0003x!9!1\u001a!\u0005\u0002\u0005M\u0002b\u0002Bg\u0001\u0012\u0005\u00111\u0007\u0005\b\u0005\u001f\u0004E\u0011AA\u001a\u0011\u001d\u0011\t\u000e\u0011C\u0001\u0005oBqAa5A\t\u0003\u00119\bC\u0004\u0003V\u0002#\tAa\u001e\t\u000f\t]\u0007\t\"\u0001\u0003x!I!\u0011\u001c\r\u0012\u0002\u0013\u0005!1\u001c\u0005\n\u0005cD\u0012\u0013!C\u0001\u0005gD\u0011Ba>\u0019#\u0003%\tA!?\t\u0013\u00055\u0007$!A\u0005\n\u0005='\u0001F,fS\u001eDG/\u001a3MK\u0006\u001cHoU9vCJ,7O\u0003\u0002vm\u0006)q\u000e\u001d;j[*\u0011q\u000f_\u0001\u0003[2T!!\u001f>\u0002\u000bM\u0004\u0018M]6\u000b\u0005md\u0018AB1qC\u000eDWMC\u0001~\u0003\ry'oZ\n\u0005\u0001}\fY\u0001\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\t\t)!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\n\u0005\r!AB!osJ+g\r\u0005\u0003\u0002\u000e\u0005}a\u0002BA\b\u00037qA!!\u0005\u0002\u001a5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0004=e>|GOP\u0002\u0001\u0013\t\t)!\u0003\u0003\u0002\u001e\u0005\r\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003C\t\u0019C\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0003\u0002\u001e\u0005\r\u0011\u0001\u00044ji&sG/\u001a:dKB$XCAA\u0015!\u0011\t\t!a\u000b\n\t\u00055\u00121\u0001\u0002\b\u0005>|G.Z1o\u000351\u0017\u000e^%oi\u0016\u00148-\u001a9uA\u0005A!/Z4QCJ\fW.\u0006\u0002\u00026A!\u0011\u0011AA\u001c\u0013\u0011\tI$a\u0001\u0003\r\u0011{WO\u00197f\u0003%\u0011Xm\u001a)be\u0006l\u0007%A\bfY\u0006\u001cH/[2OKR\u0004\u0016M]1n\u0003A)G.Y:uS\u000etU\r\u001e)be\u0006l\u0007%A\nti\u0006tG-\u0019:eSj,g)Z1ukJ,7/\u0001\u000bti\u0006tG-\u0019:eSj,g)Z1ukJ,7\u000fI\u0001\u0011gR\fg\u000eZ1sI&TX\rT1cK2\f\u0011c\u001d;b]\u0012\f'\u000fZ5{K2\u000b'-\u001a7!\u0003)\u0019x\u000e\u001c<feRK\b/Z\u000b\u0003\u0003\u001b\u00022!a\u0014\u001d\u001d\r\t\tfF\u0007\u0002i\u0006!r+Z5hQR,G\rT3bgR\u001c\u0016/^1sKN\u00042!!\u0015\u0019'\u0011Ar0!\u0017\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005\u0011\u0011n\u001c\u0006\u0003\u0003G\nAA[1wC&!\u0011\u0011EA/\u0003\u0019a\u0014N\\5u}Q\u0011\u0011QK\u0001\u0011\u001b\u0006CvLT+N?\u001a+\u0015\tV+S\u000bN+\"!a\u001c\u0011\t\u0005\u0005\u0011\u0011O\u0005\u0005\u0003g\n\u0019AA\u0002J]R\f\u0011#T!Y?:+Vj\u0018$F\u0003R+&+R*!\u0005\u0019\u0019v\u000e\u001c<feN\u0011Ad`\u0015\u00059yICG\u0001\u0003BkR|7\u0003\u0003\u0010\u0000\u0003\u0003\u000b))a\u0003\u0011\u0007\u0005\rE$D\u0001\u0019!\u0011\t\t!a\"\n\t\u0005%\u00151\u0001\u0002\b!J|G-^2u)\t\ti\tE\u0002\u0002\u0004z\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAJ!\u0011\t)*a'\u000e\u0005\u0005]%\u0002BAM\u0003C\nA\u0001\\1oO&!\u0011QTAL\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAS\u0003W\u0003B!!\u0001\u0002(&!\u0011\u0011VA\u0002\u0005\r\te.\u001f\u0005\n\u0003[\u0013\u0013\u0011!a\u0001\u0003_\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAZ!\u0019\t),a/\u0002&6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000b\u0019!\u0001\u0006d_2dWm\u0019;j_:LA!!0\u00028\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI#a1\t\u0013\u00055F%!AA\u0002\u0005\u0015\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005=\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\u0015\u0001D<sSR,'+\u001a9mC\u000e,GCAAi!\u0011\t)*a5\n\t\u0005U\u0017q\u0013\u0002\u0007\u001f\nTWm\u0019;\u0003\u0011\rCw\u000e\\3tWf\u001c\u0002\"K@\u0002\u0002\u0006\u0015\u00151\u0002\u000b\u0003\u0003;\u00042!a!*)\u0011\t)+!9\t\u0013\u00055V&!AA\u0002\u0005=D\u0003BA\u0015\u0003KD\u0011\"!,0\u0003\u0003\u0005\r!!*\u0003\u0017E+\u0018m]5OK^$xN\\\n\ti}\f\t)!\"\u0002\fQ\u0011\u0011Q\u001e\t\u0004\u0003\u0007#D\u0003BAS\u0003cD\u0011\"!,9\u0003\u0003\u0005\r!a\u001c\u0015\t\u0005%\u0012Q\u001f\u0005\n\u0003[S\u0014\u0011!a\u0001\u0003K\u000bA!Q;u_\u0006A1\t[8mKN\\\u00170A\u0006Rk\u0006\u001c\u0018NT3xi>t\u0017\u0001E:vaB|'\u000f^3e'>dg/\u001a:t+\t\u0011\t\u0001\u0005\u0004\u0002\u0002\t\r!qA\u0005\u0005\u0005\u000b\t\u0019AA\u0003BeJ\f\u0017P\u0005\u0005\u0003\n\u0005\u0015\u0015\u0011QA-\r\u0019\u0011Y\u0001\u0007\u0001\u0003\b\taAH]3gS:,W.\u001a8u}\u0005\t2/\u001e9q_J$X\rZ*pYZ,'o\u001d\u0011\u0003\u0015\u0005;wM]3hCR|'o\u0005\u0003A\u007f\u0006-AC\u0001B\u000b!\r\t\u0019\tQ\u0001\fS:LG/[1mSj,G-A\bj]&$\u0018.\u00197ju\u0016$w\fJ3r)\u0011\u0011iBa\t\u0011\t\u0005\u0005!qD\u0005\u0005\u0005C\t\u0019A\u0001\u0003V]&$\b\"CAW\u0007\u0006\u0005\t\u0019AA\u0015\u00031Ig.\u001b;jC2L'0\u001a3!\u0003\u0005Y\u0017!B6`I\u0015\fH\u0003\u0002B\u000f\u0005[A\u0011\"!,G\u0003\u0003\u0005\r!a\u001c\u0002\u0005-\u0004\u0013!B2pk:$XC\u0001B\u001b!\u0011\t\tAa\u000e\n\t\te\u00121\u0001\u0002\u0005\u0019>tw-A\u0005d_VtGo\u0018\u0013fcR!!Q\u0004B \u0011%\ti+SA\u0001\u0002\u0004\u0011)$\u0001\u0004d_VtG\u000fI\u0001\u0005iJL7*\u0001\u0005ue&\\u\fJ3r)\u0011\u0011iB!\u0013\t\u0013\u00055F*!AA\u0002\u0005=\u0014!\u0002;sS.\u0003\u0013\u0001B<Tk6\f\u0001b^*v[~#S-\u001d\u000b\u0005\u0005;\u0011\u0019\u0006C\u0005\u0002.>\u000b\t\u00111\u0001\u00026\u0005)qoU;nA\u0005)qo^*v[\u0006Iqo^*v[~#S-\u001d\u000b\u0005\u0005;\u0011i\u0006C\u0005\u0002.J\u000b\t\u00111\u0001\u00026\u00051qo^*v[\u0002\nAAY*v[\u0006A!mU;n?\u0012*\u0017\u000f\u0006\u0003\u0003\u001e\t\u001d\u0004\"CAW+\u0006\u0005\t\u0019AA\u001b\u0003\u0015\u00117+^7!\u0003\u0015\u0011'mU;n\u0003%\u0011'mU;n?\u0012*\u0017\u000f\u0006\u0003\u0003\u001e\tE\u0004\"CAW1\u0006\u0005\t\u0019AA\u001b\u0003\u0019\u0011'mU;nA\u0005!\u0011mU;n+\t\u0011I\b\u0005\u0003\u0003|\t\u0005UB\u0001B?\u0015\r\u0011yH^\u0001\u0007Y&t\u0017\r\\4\n\t\t\r%Q\u0010\u0002\f\t\u0016t7/\u001a,fGR|'/\u0001\u0005b'Vlw\fJ3r)\u0011\u0011iB!#\t\u0013\u000556,!AA\u0002\te\u0014!B1Tk6\u0004\u0013!B1c'Vl\u0017!C1c'Vlw\fJ3r)\u0011\u0011iBa%\t\u0013\u00055f,!AA\u0002\te\u0014AB1c'Vl\u0007%A\u0003bCN+X.A\u0005bCN+Xn\u0018\u0013fcR!!Q\u0004BO\u0011%\ti+YA\u0001\u0002\u0004\u0011I(\u0001\u0004bCN+X\u000eI\u0001\u0005S:LG\u000f\u0006\u0003\u0003\u001e\t\u0015\u0006b\u0002B\u0014G\u0002\u0007\u0011qN\u0001\u0004C\u0012$G\u0003\u0002BV\u0005[k\u0011\u0001\u0011\u0005\b\u0005_#\u0007\u0019\u0001BY\u0003!Ign\u001d;b]\u000e,\u0007\u0003\u0002BZ\u0005sk!A!.\u000b\u0007\t]f/A\u0004gK\u0006$XO]3\n\t\tm&Q\u0017\u0002\t\u0013:\u001cH/\u00198dK\u0006)Q.\u001a:hKR!!1\u0016Ba\u0011\u001d\u0011\u0019-\u001aa\u0001\u0005+\tQa\u001c;iKJ\f\u0001B^1mS\u0012\fG/\u001a\u000b\u0003\u0005;\tA!\u0019\"be\u0006!!MQ1s\u0003\u0015\u0011'MQ1s\u0003\u0011\u00117\u000b\u001e3\u0002\u000b\u0005\u0014')\u0019:\u0002\u000b\u0005\f')\u0019:\u0002\t\u0005\u001cF\u000fZ\u0001\u0005CZ\u000b'/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0003\u0005;TC!!\u0014\u0003`.\u0012!\u0011\u001d\t\u0005\u0005G\u0014i/\u0004\u0002\u0003f*!!q\u001dBu\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003l\u0006\r\u0011AC1o]>$\u0018\r^5p]&!!q\u001eBs\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\tU(\u0006BA8\u0005?\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012BTC\u0001B~U\u0011\t)Da8\u0002\u0017M|GN^3s)f\u0004X\rI\u0001\b[\u0006D\u0018\n^3s\u0003!i\u0017\r_%uKJ\u0004\u0013a\u0001;pY\u0006!Ao\u001c7!)I\u0019Iaa\u0003\u0004\u000e\r=1\u0011CB\n\u0007+\u00199b!\u0007\u0011\u0007\u0005E\u0003\u0001C\u0004\u0002&E\u0001\r!!\u000b\t\u000f\u0005E\u0012\u00031\u0001\u00026!9\u0011QH\tA\u0002\u0005U\u0002bBA!#\u0001\u0007\u0011\u0011\u0006\u0005\b\u0003\u000b\n\u0002\u0019AA\u0015\u0011%\tI%\u0005I\u0001\u0002\u0004\ti\u0005C\u0005\u0003\u0000F\u0001\n\u00111\u0001\u0002p!I11A\t\u0011\u0002\u0003\u0007\u0011QG\u0001\u0004M&$H\u0003CB\u0010\u0007K\u0019)d!\u0012\u0011\t\u0005E3\u0011E\u0005\u0004\u0007G!(!G,fS\u001eDG/\u001a3MK\u0006\u001cHoU9vCJ,7/T8eK2Dqaa\n\u0013\u0001\u0004\u0019I#A\u0005j]N$\u0018M\\2fgB111FB\u0019\u0005ck!a!\f\u000b\u0007\r=\u00020A\u0002sI\u0012LAaa\r\u0004.\t\u0019!\u000b\u0012#\t\u0013\r]\"\u0003%AA\u0002\re\u0012!B5ogR\u0014\b\u0003BB\u001e\u0007\u0003j!a!\u0010\u000b\u0007\r}b/\u0001\u0003vi&d\u0017\u0002BB\"\u0007{\u0011qc\u00149uS>t\u0017\r\\%ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\t\u0013\r\u001d#\u0003%AA\u0002\u0005=\u0014!\u00023faRD\u0017!\u00044ji\u0012\"WMZ1vYR$#'\u0006\u0002\u0004N)\"1\u0011\bBp\u000351\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%g\u00051q-\u001a;Bi\u0006#bA!\u001f\u0004V\re\u0003b\u0002Bj+\u0001\u00071q\u000b\t\u0007\u0003\u0003\u0011\u0019!!\u000e\t\u000f\t%W\u00031\u0001\u0004X\u00051q-\u001a;Bi\n#bA!\u001f\u0004`\r\u0005\u0004b\u0002Bi-\u0001\u00071q\u000b\u0005\b\u0005\u00174\u0002\u0019AA\u001b\u0001")
public class WeightedLeastSquares
implements Serializable {
    private final boolean fitIntercept;
    private final double regParam;
    private final double elasticNetParam;
    private final boolean standardizeFeatures;
    private final boolean standardizeLabel;
    private final Solver solverType;
    private final int maxIter;
    private final double tol;

    public static double $lessinit$greater$default$8() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8();
    }

    public static int $lessinit$greater$default$7() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7();
    }

    public static Solver $lessinit$greater$default$6() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$6();
    }

    public static Product[] supportedSolvers() {
        return WeightedLeastSquares$.MODULE$.supportedSolvers();
    }

    public static int MAX_NUM_FEATURES() {
        return WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES();
    }

    public boolean fitIntercept() {
        return this.fitIntercept;
    }

    public double regParam() {
        return this.regParam;
    }

    public double elasticNetParam() {
        return this.elasticNetParam;
    }

    public boolean standardizeFeatures() {
        return this.standardizeFeatures;
    }

    public boolean standardizeLabel() {
        return this.standardizeLabel;
    }

    public Solver solverType() {
        return this.solverType;
    }

    public int maxIter() {
        return this.maxIter;
    }

    public double tol() {
        return this.tol;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public WeightedLeastSquaresModel fit(RDD<Instance> instances, OptionalInstrumentation instr, int depth) {
        block28: {
            if (this.regParam() == 0.0) {
                instr.logWarning((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$1(), ()Ljava/lang/String;)());
            }
            summary = (Aggregator)instances.treeAggregate((Object)new Aggregator(), (Function2)(Function2 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fit$2(org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator org.apache.spark.ml.feature.Instance ), (Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;Lorg/apache/spark/ml/feature/Instance;)Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;)(), (Function2)(Function2 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fit$3(org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator ), (Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;)Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;)(), depth, ClassTag$.MODULE$.apply(Aggregator.class));
            summary.validate();
            instr.logInfo(LogEntry$.MODULE$.from((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$4(org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator ), ()Lorg/apache/spark/internal/MessageWithContext;)((Aggregator)summary)));
            k = this.fitIntercept() != false ? summary.k() + 1 : summary.k();
            numFeatures = summary.k();
            triK = summary.triK();
            wSum = summary.wSum();
            rawBStd = summary.bStd();
            rawBBar = summary.bBar();
            v0 = bStd = rawBStd == 0.0 ? package$.MODULE$.abs(rawBBar) : rawBStd;
            if (rawBStd == (double)false) {
                if (this.fitIntercept() || rawBBar == 0.0) {
                    if (rawBBar == 0.0) {
                        instr.logWarning((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$5(), ()Ljava/lang/String;)());
                    } else {
                        instr.logWarning((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$6(), ()Ljava/lang/String;)());
                    }
                    coefficients = new DenseVector((double[])Array$.MODULE$.ofDim(numFeatures, (ClassTag)ClassTag$.MODULE$.Double()));
                    intercept = rawBBar;
                    diagInvAtWA = new DenseVector(new double[]{0.0});
                    return new WeightedLeastSquaresModel(coefficients, intercept, diagInvAtWA, new double[]{0.0});
                }
                Predef$.MODULE$.require(!(this.regParam() > 0.0) || this.standardizeLabel() == false, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$7(), ()Ljava/lang/String;)());
                instr.logWarning((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$8(), ()Ljava/lang/String;)());
            }
            bBar = summary.bBar() / bStd;
            bbBar = summary.bbBar() / (bStd * bStd);
            aStd = summary.aStd();
            aStdValues = aStd.values();
            _aBar = summary.aBar();
            _aBarValues = _aBar.values();
            for (i = 0; i < numFeatures; ++i) {
                if (aStdValues[i] == 0.0) {
                    _aBarValues[i] = 0.0;
                    continue;
                }
                var33_22 = i;
                _aBarValues[var33_22] = _aBarValues[var33_22] / aStdValues[i];
            }
            aBar = _aBar;
            aBarValues = aBar.values();
            _abBar = summary.abBar();
            _abBarValues = _abBar.values();
            for (i = 0; i < numFeatures; ++i) {
                if (aStdValues[i] == 0.0) {
                    _abBarValues[i] = 0.0;
                    continue;
                }
                var39_28 = i;
                _abBarValues[var39_28] = _abBarValues[var39_28] / (aStdValues[i] * bStd);
            }
            abBar = _abBar;
            abBarValues = abBar.values();
            _aaBar = summary.aaBar();
            _aaBarValues = _aaBar.values();
            p = 0;
            for (j = 0; j < numFeatures; ++j) {
                aStdJ = aStdValues[j];
                for (i = 0; i <= j; ++i) {
                    aStdI = aStdValues[i];
                    if (aStdJ == 0.0 || aStdI == 0.0) {
                        _aaBarValues[p] = 0.0;
                    } else {
                        var51_38 = p;
                        _aaBarValues[var51_38] = _aaBarValues[var51_38] / (aStdI * aStdJ);
                    }
                    ++p;
                }
            }
            aaBar = _aaBar;
            aaBarValues = aaBar.values();
            effectiveRegParam = this.regParam() / bStd;
            effectiveL1RegParam = this.elasticNetParam() * effectiveRegParam;
            effectiveL2RegParam = (1.0 - this.elasticNetParam()) * effectiveRegParam;
            i = 0;
            j = 2;
            while (i < triK) {
                lambda = effectiveL2RegParam;
                if (!this.standardizeFeatures()) {
                    std = aStdValues[j - 2];
                    lambda = std != 0.0 ? (lambda /= std * std) : 0.0;
                }
                if (!this.standardizeLabel()) {
                    lambda *= bStd;
                }
                var65_46 = i;
                aaBarValues[var65_46] = aaBarValues[var65_46] + lambda;
                i += j;
                ++j;
            }
            aa = this.getAtA(aaBarValues, aBarValues);
            ab = this.getAtB(abBarValues, bBar);
            v1 = this.solverType();
            var69_51 = WeightedLeastSquares$Auto$.MODULE$;
            if (v1 != null ? v1.equals(var69_51) == false : var69_51 != null) break block28;
            if (this.elasticNetParam() != 0.0 && this.regParam() != 0.0) ** GOTO lbl-1000
        }
        v2 = this.solverType();
        var70_52 = WeightedLeastSquares$QuasiNewton$.MODULE$;
        if (!(v2 != null ? v2.equals(var70_52) == false : var70_52 != null)) lbl-1000:
        // 2 sources

        {
            effectiveL1RegFun = effectiveL1RegParam != 0.0 ? new Some((Object)(JFunction1.mcDI.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (I)D, $anonfun$fit$9(org.apache.spark.ml.optim.WeightedLeastSquares int double double[] int ), (I)D)((WeightedLeastSquares)this, (int)numFeatures, (double)effectiveL1RegParam, (double[])aStdValues)) : None$.MODULE$;
            v3 /* !! */  = new QuasiNewtonSolver(this.fitIntercept(), this.maxIter(), this.tol(), (Option<Function1<Object, Object>>)effectiveL1RegFun);
        } else {
            v3 /* !! */  = new CholeskySolver();
        }
        var73_55 = solver = v3 /* !! */ ;
        if (var73_55 instanceof CholeskySolver) {
            var74_56 = var73_55;
            try {
                v4 = var74_56.solve(bBar, bbBar, ab, aa, aBar);
            }
            catch (Throwable var75_57) {
                var76_58 = var75_57;
                if (var76_58 instanceof SingularMatrixException) {
                    v5 = this.solverType();
                    var77_59 = WeightedLeastSquares$Auto$.MODULE$;
                    if (!(v5 != null ? v5.equals(var77_59) == false : var77_59 != null)) {
                        instr.logWarning((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$10(), ()Ljava/lang/String;)());
                        _aa = this.getAtA(aaBarValues, aBarValues);
                        _ab = this.getAtB(abBarValues, bBar);
                        newSolver = new QuasiNewtonSolver(this.fitIntercept(), this.maxIter(), this.tol(), (Option<Function1<Object, Object>>)None$.MODULE$);
                        v4 = newSolver.solve(bBar, bbBar, _ab, _aa, aBar);
                    }
                }
                throw var75_57;
            }
        } else if (var73_55 instanceof QuasiNewtonSolver) {
            var81_63 = (QuasiNewtonSolver)var73_55;
            v4 = var81_63.solve(bBar, bbBar, ab, aa, aBar);
        } else {
            throw new MatchError((Object)var73_55);
        }
        solution = v4;
        v6 = var83_65 = this.fitIntercept() != false ? new Tuple2(ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.doubleArrayOps(solution.coefficients()), 0, solution.coefficients().length - 1), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.doubleArrayOps(solution.coefficients()))) * bStd))) : new Tuple2((Object)solution.coefficients(), (Object)BoxesRunTime.boxToDouble((double)0.0));
        if (var83_65 == null) {
            throw new MatchError((Object)var83_65);
        }
        coefficientArray = (double[])var83_65._1();
        intercept = var83_65._2$mcD$sp();
        var82_68 = new Tuple2((Object)coefficientArray, (Object)BoxesRunTime.boxToDouble((double)intercept));
        coefficientArray = (double[])var82_68._1();
        intercept = var82_68._2$mcD$sp();
        len = coefficientArray.length;
        for (q = 0; q < len; ++q) {
            var92_73 = q;
            coefficientArray[var92_73] = coefficientArray[var92_73] * (aStdValues[q] != 0.0 ? bStd / aStdValues[q] : 0.0);
        }
        diagInvAtWA = (DenseVector)solution.aaInv().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fit$11(org.apache.spark.ml.optim.WeightedLeastSquares int double[] double double[] ), ([D)Lorg/apache/spark/ml/linalg/DenseVector;)((WeightedLeastSquares)this, (int)k, (double[])aStdValues, (double)wSum)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$13(), ()Lorg/apache/spark/ml/linalg/DenseVector;)());
        return new WeightedLeastSquaresModel(new DenseVector(coefficientArray), intercept, diagInvAtWA, (double[])solution.objectiveHistory().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$14(), ()[D)()));
    }

    public OptionalInstrumentation fit$default$2() {
        return OptionalInstrumentation$.MODULE$.create(WeightedLeastSquares.class);
    }

    public int fit$default$3() {
        return 2;
    }

    private DenseVector getAtA(double[] aaBar, double[] aBar) {
        if (this.fitIntercept()) {
            return new DenseVector((double[])Array$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new double[][]{aaBar, aBar, {1.0}}), (ClassTag)ClassTag$.MODULE$.Double()));
        }
        return new DenseVector((double[])aaBar.clone());
    }

    private DenseVector getAtB(double[] abBar, double bBar) {
        if (this.fitIntercept()) {
            return new DenseVector((double[])Array$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new double[][]{abBar, {bBar}}), (ClassTag)ClassTag$.MODULE$.Double()));
        }
        return new DenseVector((double[])abBar.clone());
    }

    public static final /* synthetic */ String $anonfun$fit$1() {
        return "regParam is zero, which might cause numerical instability and overfitting.";
    }

    public static final /* synthetic */ Aggregator $anonfun$fit$2(Aggregator x$1, Instance x$2) {
        return x$1.add(x$2);
    }

    public static final /* synthetic */ Aggregator $anonfun$fit$3(Aggregator x$3, Aggregator x$4) {
        return x$3.merge(x$4);
    }

    public static final /* synthetic */ MessageWithContext $anonfun$fit$4(Aggregator summary$1) {
        return MavenUtils$.MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Number of instances: ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.COUNT$.MODULE$, (Object)BoxesRunTime.boxToLong((long)summary$1.count()))}));
    }

    public static final /* synthetic */ String $anonfun$fit$5() {
        return "Mean and standard deviation of the label are zero, so the coefficients and the intercept will all be zero; as a result, training is not needed.";
    }

    public static final /* synthetic */ String $anonfun$fit$6() {
        return "The standard deviation of the label is zero, so the coefficients will be zeros and the intercept will be the mean of the label; as a result, training is not needed.";
    }

    public static final /* synthetic */ String $anonfun$fit$7() {
        return "The standard deviation of the label is zero. Model cannot be regularized when labels are standardized.";
    }

    public static final /* synthetic */ String $anonfun$fit$8() {
        return "The standard deviation of the label is zero. Consider setting fitIntercept=true.";
    }

    public static final /* synthetic */ double $anonfun$fit$9(WeightedLeastSquares $this, int numFeatures$1, double effectiveL1RegParam$1, double[] aStdValues$1, int index) {
        if ($this.fitIntercept() && index == numFeatures$1) {
            return 0.0;
        }
        if ($this.standardizeFeatures()) {
            return effectiveL1RegParam$1;
        }
        if (aStdValues$1[index] != 0.0) {
            return effectiveL1RegParam$1 / aStdValues$1[index];
        }
        return 0.0;
    }

    public static final /* synthetic */ String $anonfun$fit$10() {
        return "Cholesky solver failed due to singular covariance matrix. Retrying with Quasi-Newton solver.";
    }

    public static final /* synthetic */ DenseVector $anonfun$fit$11(WeightedLeastSquares $this, int k$1, double[] aStdValues$1, double wSum$1, double[] inv) {
        return new DenseVector((double[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), k$1).map((Function1)(JFunction1.mcDI.sp & Serializable)i -> {
            double multiplier = i == k$1 && $this.fitIntercept() ? 1.0 : aStdValues$1[i - 1] * aStdValues$1[i - 1];
            return inv[i + (i - 1) * i / 2 - 1] / (wSum$1 * multiplier);
        }).toArray((ClassTag)ClassTag$.MODULE$.Double()));
    }

    public static final /* synthetic */ DenseVector $anonfun$fit$13() {
        return new DenseVector(new double[]{0.0});
    }

    public static final /* synthetic */ double[] $anonfun$fit$14() {
        return new double[]{0.0};
    }

    public WeightedLeastSquares(boolean fitIntercept, double regParam, double elasticNetParam, boolean standardizeFeatures, boolean standardizeLabel, Solver solverType, int maxIter, double tol) {
        this.fitIntercept = fitIntercept;
        this.regParam = regParam;
        this.elasticNetParam = elasticNetParam;
        this.standardizeFeatures = standardizeFeatures;
        this.standardizeLabel = standardizeLabel;
        this.solverType = solverType;
        this.maxIter = maxIter;
        this.tol = tol;
        Predef$.MODULE$.require(regParam >= 0.0, (Function0 & Serializable)() -> "regParam cannot be negative: " + this.regParam());
        Predef$.MODULE$.require(elasticNetParam >= 0.0 && elasticNetParam <= 1.0, (Function0 & Serializable)() -> "elasticNetParam must be in [0, 1]: " + this.elasticNetParam());
        Predef$.MODULE$.require(maxIter > 0, (Function0 & Serializable)() -> "maxIter must be a positive integer: " + this.maxIter());
        Predef$.MODULE$.require(tol >= 0.0, (Function0 & Serializable)() -> "tol must be >= 0, but was set to " + this.tol());
    }

    private static class Aggregator
    implements Serializable {
        private boolean initialized = false;
        private int k;
        private long count;
        private int triK;
        private double wSum;
        private double wwSum;
        private double bSum;
        private double bbSum;
        private DenseVector aSum;
        private DenseVector abSum;
        private DenseVector aaSum;

        public boolean initialized() {
            return this.initialized;
        }

        public void initialized_$eq(boolean x$1) {
            this.initialized = x$1;
        }

        public int k() {
            return this.k;
        }

        public void k_$eq(int x$1) {
            this.k = x$1;
        }

        public long count() {
            return this.count;
        }

        public void count_$eq(long x$1) {
            this.count = x$1;
        }

        public int triK() {
            return this.triK;
        }

        public void triK_$eq(int x$1) {
            this.triK = x$1;
        }

        public double wSum() {
            return this.wSum;
        }

        public void wSum_$eq(double x$1) {
            this.wSum = x$1;
        }

        private double wwSum() {
            return this.wwSum;
        }

        private void wwSum_$eq(double x$1) {
            this.wwSum = x$1;
        }

        private double bSum() {
            return this.bSum;
        }

        private void bSum_$eq(double x$1) {
            this.bSum = x$1;
        }

        private double bbSum() {
            return this.bbSum;
        }

        private void bbSum_$eq(double x$1) {
            this.bbSum = x$1;
        }

        private DenseVector aSum() {
            return this.aSum;
        }

        private void aSum_$eq(DenseVector x$1) {
            this.aSum = x$1;
        }

        private DenseVector abSum() {
            return this.abSum;
        }

        private void abSum_$eq(DenseVector x$1) {
            this.abSum = x$1;
        }

        private DenseVector aaSum() {
            return this.aaSum;
        }

        private void aaSum_$eq(DenseVector x$1) {
            this.aaSum = x$1;
        }

        private void init(int k) {
            Predef$.MODULE$.require(k <= WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES(), (Function0 & Serializable)() -> "In order to take the normal equation approach efficiently, we set the max number of features to " + WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES() + " but got " + k + ".");
            this.k_$eq(k);
            this.triK_$eq(k * (k + 1) / 2);
            this.count_$eq(0L);
            this.wSum_$eq(0.0);
            this.wwSum_$eq(0.0);
            this.bSum_$eq(0.0);
            this.bbSum_$eq(0.0);
            this.aSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, (ClassTag)ClassTag$.MODULE$.Double())));
            this.abSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, (ClassTag)ClassTag$.MODULE$.Double())));
            this.aaSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(this.triK(), (ClassTag)ClassTag$.MODULE$.Double())));
            this.initialized_$eq(true);
        }

        public Aggregator add(Instance instance) {
            Instance instance2 = instance;
            if (instance2 == null) {
                throw new MatchError((Object)instance2);
            }
            double l = instance2.label();
            double w = instance2.weight();
            Vector f = instance2.features();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)l), (Object)BoxesRunTime.boxToDouble((double)w), (Object)f);
            double l2 = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double w2 = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            Vector f2 = (Vector)tuple3._3();
            int ak = f2.size();
            if (!this.initialized()) {
                this.init(ak);
            }
            Predef$.MODULE$.assert(ak == this.k(), (Function0 & Serializable)() -> "Dimension mismatch. Expect vectors of size " + this.k() + " but got " + ak + ".");
            this.count_$eq(this.count() + 1L);
            this.wSum_$eq(this.wSum() + w2);
            this.wwSum_$eq(this.wwSum() + w2 * w2);
            this.bSum_$eq(this.bSum() + w2 * l2);
            this.bbSum_$eq(this.bbSum() + w2 * l2 * l2);
            BLAS$.MODULE$.axpy(w2, f2, (Vector)this.aSum());
            BLAS$.MODULE$.axpy(w2 * l2, f2, (Vector)this.abSum());
            BLAS$.MODULE$.spr(w2, f2, this.aaSum());
            return this;
        }

        public Aggregator merge(Aggregator other) {
            if (!other.initialized()) {
                return this;
            }
            if (!this.initialized()) {
                this.init(other.k());
            }
            Predef$.MODULE$.assert(this.k() == other.k(), (Function0 & Serializable)() -> "dimension mismatch: this.k = " + this.k() + " but other.k = " + other.k());
            this.count_$eq(this.count() + other.count());
            this.wSum_$eq(this.wSum() + other.wSum());
            this.wwSum_$eq(this.wwSum() + other.wwSum());
            this.bSum_$eq(this.bSum() + other.bSum());
            this.bbSum_$eq(this.bbSum() + other.bbSum());
            BLAS$.MODULE$.axpy(1.0, (Vector)other.aSum(), (Vector)this.aSum());
            BLAS$.MODULE$.axpy(1.0, (Vector)other.abSum(), (Vector)this.abSum());
            BLAS$.MODULE$.axpy(1.0, (Vector)other.aaSum(), (Vector)this.aaSum());
            return this;
        }

        public void validate() {
            Predef$.MODULE$.assert(this.initialized(), (Function0 & Serializable)() -> "Training dataset is empty.");
            Predef$.MODULE$.assert(this.wSum() > 0.0, (Function0 & Serializable)() -> "Sum of weights cannot be zero.");
        }

        public DenseVector aBar() {
            DenseVector output = this.aSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return output;
        }

        public double bBar() {
            return this.bSum() / this.wSum();
        }

        public double bbBar() {
            return this.bbSum() / this.wSum();
        }

        public double bStd() {
            double variance = package$.MODULE$.max(this.bbSum() / this.wSum() - this.bBar() * this.bBar(), 0.0);
            return package$.MODULE$.sqrt(variance);
        }

        public DenseVector abBar() {
            DenseVector output = this.abSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return output;
        }

        public DenseVector aaBar() {
            DenseVector output = this.aaSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return output;
        }

        public DenseVector aStd() {
            double[] std = (double[])Array$.MODULE$.ofDim(this.k(), (ClassTag)ClassTag$.MODULE$.Double());
            int i = 0;
            int j = 2;
            double[] aaValues = this.aaSum().values();
            while (i < this.triK()) {
                int l = j - 2;
                double aw = this.aSum().apply(l) / this.wSum();
                std[l] = package$.MODULE$.sqrt(package$.MODULE$.max(aaValues[i] / this.wSum() - aw * aw, 0.0));
                i += j;
                ++j;
            }
            return new DenseVector(std);
        }

        public DenseVector aVar() {
            double[] variance = (double[])Array$.MODULE$.ofDim(this.k(), (ClassTag)ClassTag$.MODULE$.Double());
            int i = 0;
            int j = 2;
            double[] aaValues = this.aaSum().values();
            while (i < this.triK()) {
                int l = j - 2;
                double aw = this.aSum().apply(l) / this.wSum();
                variance[l] = package$.MODULE$.max(aaValues[i] / this.wSum() - aw * aw, 0.0);
                i += j;
                ++j;
            }
            return new DenseVector(variance);
        }
    }

    public static interface Solver {
    }
}

