/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.security;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.crypto.random.CryptoRandomFactory;
import org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.commons.crypto.stream.CryptoOutputStream;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.util.CryptoUtils;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.security.CryptoStreamUtils;
import org.slf4j.Logger;
import org.sparkproject.guava.io.ByteStreams;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CryptoStreamUtils$
implements Logging {
    public static final CryptoStreamUtils$ MODULE$ = new CryptoStreamUtils$();
    private static final int IV_LENGTH_IN_BYTES;
    private static final String SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        IV_LENGTH_IN_BYTES = 16;
        SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX = "spark.io.encryption.commons.config.";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int IV_LENGTH_IN_BYTES() {
        return IV_LENGTH_IN_BYTES;
    }

    public String SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX() {
        return SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX;
    }

    public OutputStream createCryptoOutputStream(OutputStream os, SparkConf sparkConf, byte[] key) {
        CryptoStreamUtils.CryptoParams params = new CryptoStreamUtils.CryptoParams(key, sparkConf);
        byte[] iv = this.createInitializationVector(params.conf());
        os.write(iv);
        return new CryptoOutputStream(params.transformation(), params.conf(), os, (Key)params.keySpec(), (AlgorithmParameterSpec)new IvParameterSpec(iv));
    }

    public WritableByteChannel createWritableChannel(WritableByteChannel channel, SparkConf sparkConf, byte[] key) {
        CryptoStreamUtils.CryptoParams params = new CryptoStreamUtils.CryptoParams(key, sparkConf);
        byte[] iv = this.createInitializationVector(params.conf());
        CryptoStreamUtils.CryptoHelperChannel helper = new CryptoStreamUtils.CryptoHelperChannel(channel);
        helper.write(ByteBuffer.wrap(iv));
        return new CryptoOutputStream(params.transformation(), params.conf(), (WritableByteChannel)helper, (Key)params.keySpec(), (AlgorithmParameterSpec)new IvParameterSpec(iv));
    }

    public InputStream createCryptoInputStream(InputStream is, SparkConf sparkConf, byte[] key) {
        byte[] iv = new byte[this.IV_LENGTH_IN_BYTES()];
        ByteStreams.readFully((InputStream)is, (byte[])iv);
        CryptoStreamUtils.CryptoParams params = new CryptoStreamUtils.CryptoParams(key, sparkConf);
        return new CryptoInputStream(params.transformation(), params.conf(), is, (Key)params.keySpec(), (AlgorithmParameterSpec)new IvParameterSpec(iv));
    }

    public ReadableByteChannel createReadableChannel(ReadableByteChannel channel, SparkConf sparkConf, byte[] key) {
        byte[] iv = new byte[this.IV_LENGTH_IN_BYTES()];
        ByteBuffer buf = ByteBuffer.wrap(iv);
        JavaUtils.readFully((ReadableByteChannel)channel, (ByteBuffer)buf);
        CryptoStreamUtils.CryptoParams params = new CryptoStreamUtils.CryptoParams(key, sparkConf);
        return new CryptoInputStream(params.transformation(), params.conf(), channel, (Key)params.keySpec(), (AlgorithmParameterSpec)new IvParameterSpec(iv));
    }

    public Properties toCryptoConf(SparkConf conf) {
        return CryptoUtils.toCryptoConf((String)this.SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.wrapRefArray((Object[])conf.getAll()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava().entrySet());
    }

    public byte[] createKey(SparkConf conf) {
        int keyLen = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.IO_ENCRYPTION_KEY_SIZE_BITS()));
        String ioKeyGenAlgorithm = conf.get(package$.MODULE$.IO_ENCRYPTION_KEYGEN_ALGORITHM());
        KeyGenerator keyGen = KeyGenerator.getInstance(ioKeyGenAlgorithm);
        keyGen.init(keyLen);
        return keyGen.generateKey().getEncoded();
    }

    private byte[] createInitializationVector(Properties properties) {
        byte[] iv;
        block0: {
            iv = new byte[this.IV_LENGTH_IN_BYTES()];
            long initialIVStart = System.nanoTime();
            CryptoRandomFactory.getCryptoRandom((Properties)properties).nextBytes(iv);
            long initialIVFinish = System.nanoTime();
            long initialIVTime = TimeUnit.NANOSECONDS.toMillis(initialIVFinish - initialIVStart);
            if (initialIVTime <= 2000L) break block0;
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"It costs ", " milliseconds "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TIME_UNITS$.MODULE$, (Object)BoxesRunTime.boxToLong((long)initialIVTime))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to create the Initialization Vector used by CryptoStream"}))).log((Seq)Nil$.MODULE$))));
        }
        return iv;
    }

    private CryptoStreamUtils$() {
    }
}

