from __future__ import annotations

import lldb
from jb_declarative_formatters.type_viz_generated_method import GeneratedMethodDefinition
from renderers.jb_lldb_logging import log


class LLDBTopLevelLazyDeclarations:
    @classmethod
    def declare_lazy_declaration(cls, debugger: lldb.SBDebugger, lazy_declaration: GeneratedMethodDefinition):
        if getattr(debugger, "AddTopLevelLazyDeclaration", None) is None:
            return

        decl_context = ""
        if lazy_declaration.declaration_context is not None:
            decl_context = lazy_declaration.declaration_context.get_full_name_with_wildcards()

        error: lldb.SBError = debugger.AddTopLevelLazyDeclaration(decl_context, lazy_declaration.declaration_name,
                                                                  lazy_declaration.definition_template, lldb.eLanguageTypeC_plus_plus_14)

        if not error.Success():
            log(f"Can't add lazy declarations by regex for '{decl_context}::{lazy_declaration.declaration_name}': {error.description}")

    @classmethod
    def remove_all_top_level_lazy_declarations(cls, debugger: lldb.SBDebugger):
        if getattr(debugger, "RemoveAllTopLevelLazyDeclarations", None) is None:
            return

        debugger.RemoveAllTopLevelLazyDeclarations()
