/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.Client;
import com.android.tools.idea.execution.common.debug.AndroidDebugger;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerConfigurable;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerState;
import com.android.tools.idea.execution.common.debug.impl.java.AndroidJavaDebugger;
import com.android.tools.idea.execution.common.debug.utils.FacetFinder;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.projectsystem.ApplicationProjectContext;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.editor.AutoAndroidDebuggerState;
import com.android.tools.ndk.run.editor.HybridAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerConfigurable;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoAndroidDebugger
implements AndroidDebugger<AutoAndroidDebuggerState> {
    public static final String ID = "Auto";
    private HybridAndroidDebugger myHybridAndroidDebugger;
    private AndroidJavaDebugger myAndroidJavaDebugger;
    private NativeAndroidDebugger myNativeAndroidDebugger;

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        return "Detect Automatically";
    }

    @NotNull
    public AutoAndroidDebuggerState createState() {
        return new AutoAndroidDebuggerState(this);
    }

    @NotNull
    public AndroidDebuggerConfigurable<AutoAndroidDebuggerState> createConfigurable(@NotNull RunConfiguration runConfiguration) {
        return new NativeAndroidDebuggerConfigurable<AutoAndroidDebuggerState>(runConfiguration.getProject(), true, true);
    }

    public boolean supportsProject(@NotNull Project project) {
        return ProjectSystemUtil.getProjectSystem((Project)project) instanceof GradleProjectSystem || AndroidProjectInfo.getInstance((Project)project).isApkProject();
    }

    public boolean isNative(@NotNull Project project) {
        return NdkHelper.isNdkProject(project);
    }

    @WorkerThread
    public XDebugSession getExistingDebugSession(@NotNull Project project, @NotNull Client client) {
        boolean useNativeDebugger = this.isNativeProject(project);
        return this.getInternalDebugger(useNativeDebugger).getExistingDebugSession(project, client);
    }

    public boolean shouldBeDefault() {
        return true;
    }

    public XDebugProcessStarter getDebugProcessStarterForExistingProcess(Project project, Client client, ApplicationProjectContext applicationContext, AutoAndroidDebuggerState debugState) throws ExecutionException {
        boolean useNativeDebugger = this.isNativeProject(project);
        return this.getInternalDebugger(useNativeDebugger).getDebugProcessStarterForExistingProcess(project, client, applicationContext, (AndroidDebuggerState)debugState);
    }

    public XDebugProcessStarter getDebugProcessStarterForNewProcess(@NotNull Project project, @NotNull Client client, @NotNull ApplicationProjectContext applicationContext, @NotNull AutoAndroidDebuggerState debugState, @Nullable ConsoleView consoleViewToReuse) throws ExecutionException {
        boolean useNativeDebugger = this.isNativeDeployment(project, client) || !debugState.getSymbolDirs().isEmpty();
        return this.getInternalDebugger(useNativeDebugger).getDebugProcessStarterForNewProcess(project, client, applicationContext, (AndroidDebuggerState)debugState, consoleViewToReuse);
    }

    protected boolean isNativeProject(@NotNull Project project) {
        return NdkHelper.isNdkProject(project);
    }

    protected boolean isNativeDeployment(@NotNull Project project, @NotNull Client client) throws ExecutionException {
        AndroidFacet facet = FacetFinder.INSTANCE.findFacetForProcess(project, client).getFacet();
        return NdkHelper.isNdkDeployment(project, facet.getModule());
    }

    private synchronized void findDebuggers() {
        if (this.myHybridAndroidDebugger != null && this.myNativeAndroidDebugger != null && this.myAndroidJavaDebugger != null) {
            return;
        }
        for (AndroidDebugger debugger : (AndroidDebugger[])AndroidDebugger.EP_NAME.getExtensions()) {
            if (debugger instanceof HybridAndroidDebugger) {
                this.myHybridAndroidDebugger = (HybridAndroidDebugger)debugger;
                continue;
            }
            if (debugger instanceof NativeAndroidDebugger) {
                this.myNativeAndroidDebugger = (NativeAndroidDebugger)debugger;
                continue;
            }
            if (!(debugger instanceof AndroidJavaDebugger)) continue;
            this.myAndroidJavaDebugger = (AndroidJavaDebugger)debugger;
        }
    }

    @NotNull
    private synchronized AndroidDebugger getInternalDebugger(boolean useNativeDebugger) {
        this.findDebuggers();
        if (!useNativeDebugger) {
            return this.myAndroidJavaDebugger;
        }
        return this.myHybridAndroidDebugger;
    }
}

